<?php
require_once('../Connections/conexionlab.php');
include('../excel/excelwriter.inc.php');
include('../assets/php/noCache.php');

// Se previene que el usuario descargue una versión almacenada en el caché.
noCache();

$archivo_temporal = tempnam(sys_get_temp_dir(), 'est');
if ($archivo_temporal == false) {
	echo 'Error al crear el archivo temporal.';
	die();
}

$excel = new ExcelWriter($archivo_temporal);
// En caso de que no se pueda acceder al archivo con la librería, se imprime el error y se termina la ejecución del script.
if ($excel == false) {
	echo $excel->error;
	die();
}

// Escribimos la primera fila con las cabeceras.
$myArr = array("Atencion", "Fecha", "Hora", "Local", "Paciente", "RUT Paciente", "Prevision", "Convenio", "Medico", "Codigo", "Nombre", "Precio ($)");
$excel->writeLine($myArr);

if (isset($_REQUEST['fe_ini']) && isset($_REQUEST['fe_ter'])) {
	$f_ini = $_REQUEST['fe_ini'];
	$f_ter = $_REQUEST['fe_ter'];
	$sql = "AND ate.FECHA BETWEEN '$f_ini' AND '$f_ter'";
} else {
	$sql = '';
}
mysql_select_db($database_conexionlab, $conexionlab); /* Se cambia precio de examen por precio examen en atencion 01/03/2019 */
$query_todo = "SELECT exate.ID_ATENCION, ate.FECHA, DATE_FORMAT(ate.FECHA,'%d/%m/%Y') AS F_CHILE ,ate.HORA ,exate.ID_EXATE, exate.COD_EXAMEN, ex.NOMBRE,
ex.FLAG_AGRUPACION, exate.PRECIO_EXAMEN, CONCAT(pa.NRO_RUT,'-',pa.DV_RUT) AS RUT, pa.NOMBRES AS N_PAC, pa.APELLIDO_PATERNO AS A1_PAC, pa.APELLIDO_MATERNO AS A2_PAC,
me.NOMBRES AS N_MED, me.APELLIDO_PATERNO AS A1_MED, me.APELLIDO_MATERNO AS A2_MED, em.NOMBRE_E, ccto.NOMBRE AS LOCAL, con.NOMBRE_E AS CONVENIO
FROM examenes_atenciones exate
LEFT JOIN examenes ex ON exate.COD_EXAMEN=ex.COD_INTERNO
LEFT JOIN atenciones ate ON exate.ID_ATENCION=ate.ID_ATENCION
LEFT JOIN personas pa ON ate.ID_CLIENTE=pa.ID_PERSONA
LEFT JOIN personas me ON ate.ID_MEDICO=me.ID_PERSONA
LEFT JOIN empresas em ON ate.ID_PREVISION=em.ID_EMPRESA
LEFT JOIN centros_contacto ccto ON ate.ID_CENTRO_CONTACTO=ccto.ID_CENTRO_CONTACTO
LEFT JOIN empresas con ON con.ID_EMPRESA=ate.ID_CONVENIO
WHERE ate.FLAG_ELIMINADO = 0 AND exate.F_HIJO IS NULL $sql
GROUP BY ate.ID_ATENCION, COD_EXAMEN /* HAVING MAX(pex.FECHA_INICIO)< ate.FECHA */";
$todo = mysql_query($query_todo, $conexionlab) or die(mysql_error());

// Escribimos todos los registros de la base de datos en el fichero Excel.
while ($Rs2 = mysql_fetch_array($todo)) {
	$myArr = array(
		$Rs2['ID_ATENCION'],
		$Rs2['F_CHILE'],
		$Rs2['HORA'],
		$Rs2['LOCAL'],
		$Rs2['N_PAC'] . " " . $Rs2['A1_PAC'] . " " . $Rs2['A2_PAC'],
		$Rs2['RUT'],
		$Rs2['NOMBRE_E'],
		$Rs2['CONVENIO'],
		$Rs2['N_MED'] . " " . $Rs2['A1_MED'] . " " . $Rs2['A2_MED'],
		$Rs2['COD_EXAMEN'],
		$Rs2['NOMBRE'],
		$Rs2['PRECIO_EXAMEN']
	);
	$excel->writeLine($myArr);
	// Otra forma es:
	// $excel->writeLine($Rs2);
	// De este modo, volcaráamos todos los registros seleccionados sin necesidad de colocarlos/filtrar previamente en $myArr.
}
$excel->close();

// Enviamos el fichero excel que acabamos de crear.
header("Content-disposition: attachment;filename=estadistica.xls");
readfile($archivo_temporal);

// Eliminamos el archivo temporal.
unlink($archivo_temporal);
