<?php
$pantalla_actual = 'CON_ESTA';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$tim = time();
$hoy = date('Y-m-d', $tim);
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$where = '';
if (isset($_GET['fe_ini'])) {
  $where .= 'AND FECHA>="' . $_GET['fe_ini'] . '"';
}
if (isset($_GET['fe_ter'])) {
  $where .= ' AND FECHA<="' . $_GET['fe_ter'] . '"';
}

$stmt = $mysqli->prepare("SELECT a.ID_CENTRO_CONTACTO, cct.NOMBRE, COUNT(DISTINCT a.ID_ATENCION) AS ATENCIONES, COUNT(exat.ID_EXATE) AS EXAMENES, SUM(exat.PRECIO_EXAMEN) AS VALOR
FROM atenciones a
LEFT JOIN centros_contacto cct ON a.ID_CENTRO_CONTACTO= cct.ID_CENTRO_CONTACTO
LEFT JOIN examenes_atenciones exat ON a.ID_ATENCION=exat.ID_ATENCION AND exat.F_HIJO IS NULL
WHERE a.FLAG_ELIMINADO = 0 $where
GROUP BY ID_CENTRO_CONTACTO
ORDER BY cct.NOMBRE");
$stmt->execute();
$resultado = $stmt->get_result();
$datos = $resultado->fetch_all(MYSQLI_ASSOC);

//------------------------------------------
//consulta estadisticas CON FILTRO

$sum_pac = 0;
$sum_ex = 0;
$sum_val = 0;

ob_start();

?>

<form id="form1" name="form1" method="get" action="">
  <table class="table table-responsive">
    <tr>
      <td> Entre:</td>
      <td><input type="date" name="fe_ini" class="form-control" value="<?php if (isset($_GET['fe_ini'])) {
                                                                          echo $_GET['fe_ini'];
                                                                        } ?>" required="required" /></td>
      <td>y </td>
      <td><input type="date" name="fe_ter" class="form-control" value="<?php if (isset($_GET['fe_ter'])) {
                                                                          echo $_GET['fe_ter'];
                                                                        } ?>" required="required" /></td>
      <td><button name="button" id="button" class="btn btn-success" value="buscar" title="Buscar">Buscar</button>
        <input name="busqueda" type="hidden" id="busqueda" value="S" />
      <td><button name="boton" type="button" class="btn btn-info" value="Ver todo" title="Ver Todo" onclick="location.href='principalV2.php'">Ver Todo</button></td>
      <td><a href="principal_pdf.php<?php if (isset($_GET['fe_ini'])) {
                                      echo "?fe_ini=" . $_GET['fe_ini'] . "&fe_ter=" . $_GET['fe_ter'];
                                    } ?>" class="btn btn-danger" target="_blank"> Generar PDF</a></td>
      <td><a href="estad_excel.php<?php if (isset($_GET['fe_ini']) && (isset($_GET['fe_ter']))) {
                                    echo "?fe_ini=" . $_GET['fe_ini'] . "&fe_ter=" . $_GET['fe_ter'];
                                  } ?>" class="btn btn-success" target="_blank"> Generar Excel </a>
      </td>
      </td>
  </table>
</form>
<table class="table table-responsive table-hover">
  <thead>
    <tr bgcolor="#999999">
      <th>Centro</th>
      <th>Cantidad Atenciones</th>
      <th>Cantidad Examens</th>
      <th><?php if (in_array(58, $autorizaciones)) echo 'Valor $' ?></th>
      <th>Detalle</th>
    </tr>
  </thead>
  <?php
  foreach ($datos as $dato) { ?>
    <tbody>
      <tr>
        <td><?= $dato['NOMBRE'] ?></td>
        <td><?= number_format($dato['ATENCIONES'], '0', ',', '.') ?></td>
        <td><?= number_format($dato['EXAMENES'], '0', ',', '.') ?></td>
        <td><?php if (in_array(58, $autorizaciones)) echo number_format($dato['VALOR'], '0', ',', '.') ?></td>
        <td>
          <a href="detalleV2.php?idc=<?= $dato['ID_CENTRO_CONTACTO']; if (isset($_GET['fe_ini']) && (isset($_GET['fe_ter']))) echo "&fe_ini=" . $_GET['fe_ini'] . "&fe_ter=" . $_GET['fe_ter'] ?>"><i class="fa fa-pencil-square-o fa-lg"></i></a>
        </td>
      </tr>
    <?php
    $sum_pac = $dato['ATENCIONES'] + $sum_pac;
    $sum_ex = $dato['EXAMENES'] + $sum_ex;
    $sum_val = $dato['VALOR'] + $sum_val;
  } ?>
    </tbody>
    <tfoot>
      <tr bgcolor="#999999">
        <td>Totales</td>
        <td><?= number_format($sum_pac, '0', ',', '.') ?></td>
        <td><?= number_format($sum_ex, '0', ',', '.') ?></td>
        <td><?php if (in_array(58, $autorizaciones)) echo number_format($sum_val, '0', ',', '.') ?></td>
        <td>
          <a href="detalleV2.php?idc=all<?php if (isset($_GET['fe_ini']) && (isset($_GET['fe_ter']))) echo "&fe_ini=" . $_GET['fe_ini'] . "&fe_ter=" . $_GET['fe_ter'] ?>">
            <i class="fa fa-pencil-square-o"></i></a>
        </td>
      </tr>
    </tfoot>
</table>
<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title'],
  "icon" => 'fa fa-cog',
  'toolbar' => array(
    array(
      "id" => "toolbar-id",
      "content" => '<a href="#" data-toggle="modal" data-target="#myModalNew"></a>',
      "class" => 'smart-form'
    )
  )
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php
  include("../inc/ribbon.php");
  ?>

  <!-- MAIN CONTENT -->
  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>
</div>
<!-- END MAIN PANEL -->
<!-- ==========================CONTENT ENDS HERE ========================== -->

<!-- PAGE FOOTER -->
<?php
// include page footer
include("../inc/footer.php");
?>
<!-- END PAGE FOOTER -->

<?php
//include required scripts
include("../inc/scripts.php");
?>

<!-- PAGE RELATED PLUGIN(S)
<script src="<?= ASSETS_URL ?>/js/plugin/YOURJS.js"></script>-->

<?php
//include footer
include("../inc/google-analytics.php");
?>