<?php
$pantalla_actual = 'DESC_ARCH';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$query = $mysqli->prepare("SELECT *
FROM tipos_informe
# LEFT JOIN personas pac ON a.ID_CLIENTE = pac.ID_PERSONA
WHERE 1
ORDER BY ID_TIPO_INFORME ASC");
$query->execute();
$result = $query->get_result();
$tipos_informe = $result->fetch_all(MYSQLI_ASSOC);
$query->close();

ob_start();
?>

<?php foreach ($tipos_informe as $tipo_informe) {
	$query_informes = $mysqli->prepare("SELECT *, DATE_FORMAT(FECHA, '%d/%m/%Y') AS fechaConFormato
	FROM informes
	WHERE ID_TIPO_INFORME = ?
	ORDER BY ID_INFORME DESC");
	$query_informes->bind_param("i", $tipo_informe["ID_TIPO_INFORME"]);
	$query_informes->execute();
	$result = $query_informes->get_result();
	$informes = $result->fetch_all(MYSQLI_ASSOC);
?>
	<div class="panel-group" id="accordion">
		<div class="panel panel-default">
			<div class="panel-heading">
				<h4 class="panel-title">
					<a data-toggle="collapse" href="#collapse<?= $tipo_informe["ID_TIPO_INFORME"] ?>"><?= $tipo_informe["NOMBRE"] ?></a>
				</h4>
			</div>
			<div id="collapse<?= $tipo_informe["ID_TIPO_INFORME"] ?>" class="panel-collapse collapse">
				<div class="panel-body">
					<?php 
					if (!$informes) echo "<tr> <td> No hay informes guardados para este tipo de informe. </td> </tr>";
					if ($informes) {
					?>
					<div class="table-responsive">
						<table class="table table-hover table-condensed" style="width:100%">
							<thead>
								<tr>
									<th>Descripción</th>
									<th>Fecha</th>
									<th>Filtros</th>
									<th>Ver PDF</th>
									<th>Ver Excel</th>
									<th>Eliminar</th>
								</tr>
							</thead>
							<tbody>
								<?php foreach ($informes as $informe) { ?>
									<tr>
										<td> <?= $informe['DESCRIPCION'] ?> </td>
										<td> <?= $informe['fechaConFormato'] ?> </td>
										<td> <?= $informe['FILTROS'] ? $informe['FILTROS'] : "-" ?> </td>
										<td> <a style="padding:0px 12px" class="btn btn-link" href="<?= $informe['NOMBRE_ARCHIVO_PDF'] ?>" target="_blank"> <i class="fa fa-lg fa-file-pdf-o"></i> </a> </td>
										<td> <a style="padding:0px 12px" class="btn btn-link" href="<?= $informe['NOMBRE_ARCHIVO_EXCEL'] ?>" target="_blank"> <i class="fa fa-lg fa-file-excel-o"></i> </a> </td>
										<td> <a style="padding:0px 12px" class="btn btn-link txt-color-red btn-eliminarInforme" data-id="<?= $informe['ID_INFORME'] ?>"> <i class="fa fa-lg fa-trash-o"></i> </a> </td>
									</tr>
								<?php } ?>
							</tbody>
						</table>
					</div>
					<?php } ?>
				</div>
			</div>
		</div>
	</div>
<?php } ?>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
	"title" => $datos_pantallas[$pantalla_actual]['body_title'],
	"icon" => 'fa fa-cog',
	'toolbar' => array(
		array(
			"id" => "toolbar-id",
			"content" => '<a href="#"  data-toggle="modal" data-target="#myModalNew"></a>',
			"class" => 'smart-form'
		)
	)
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
	<?php
	include("../inc/ribbon.php");
	?>
	<div id="content">
		<?php
		$widget->print_html();
		?>
	</div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<script>
	$(document).ready(function() {
		var dataTable = $('.dt-informes').DataTable({
			'lengthMenu': [
				[50, 100, 200, 500],
				[50, 100, 200, 500]
			],
			"language": {
				"sProcessing": "Procesando...",
				"sZeroRecords": "No se encontraron resultados",
				"sInfoPostFix": "",
				"sUrl": "",
				"oPaginate": {
					"sFirst": "Primero",
					"sPrevious": "Anterior",
					"sNext": "Siguiente",
					"sLast": "Último"
				},
				"sInfo": "_START_ a _END_ de _TOTAL_ Registros",
				"sInfoEmpty": "0 Registros",
				"sInfoFiltered": "(de _MAX_ Registros en total)",
				"sLengthMenu": "Mostrar _MENU_ Registros",
				"sSearch": "Buscar: "
			},
			"order": [0, 'asc']
		});

	});
</script>

<?php include("../inc/google-analytics.php"); ?>