<?php
$pagina = 1;

define('PERMITIDO', true);
require_once("../inc/init.php");
require_once('../assets/tcpdf/tcpdf.php');

$titulo = 'Laboratorio Central<br>Arlegui 440 - Oficina 218<br>Viña del Mar<br>Fono: 32-2714189';
$firma = 'QF Andoni Etcheverry<br>Director Técnico';
$nombre_centro_contacto = '';

if ($_GET['idcc'] != '') {
	$query_centro_cto = 'SELECT NOMBRE from centros_contacto WHERE ID_CENTRO_CONTACTO = ?';
	$centro_contacto = $mysqli->prepare($query_centro_cto);
	echo $mysqli->error;
	$centro_contacto->bind_param('i', $_GET['idcc']);

	$centro_contacto->execute();
	$centro_contacto->bind_result($nombre_centro_contacto);
	$centro_contacto->store_result();
	$centro_contacto->fetch();
}

$nombre_turno_dialisis = '';

if ($_GET['idtd'] != '') {
	$query_turno_dialisis = 'SELECT DESCRIPCION_CG from codigos_generales WHERE CODIGO = ? AND COD_TABLA = \'SIS_TURDIA\'';
	$turno_dialisis = $mysqli->prepare($query_turno_dialisis);
	echo $mysqli->error;
	$turno_dialisis->bind_param('i', $_GET['idtd']);

	$turno_dialisis->execute();
	$turno_dialisis->bind_result($nombre_turno_dialisis);
	$turno_dialisis->store_result();
	$turno_dialisis->fetch();
}

$fi = (isset($_GET['f_inicio'])) ? $_GET['f_inicio'] : date('Y-m-d', strtotime('-1 week'));
$ft = (isset($_GET['f_termino'])) ? $_GET['f_termino'] : date('Y-m-d');
$f_prev = ($_GET['idpv'] != '') ? " AND a.ID_PREVISION = {$_GET['idpv']}" : "";
$f_conv = ($_GET['idcv'] != '') ? " AND a.ID_CONVENIO = {$_GET['idcv']}" : "";
$f_cto = ($_GET['idcc'] != '')  ? " AND a.ID_CENTRO_CONTACTO = {$_GET['idcc']}" : "";
$f_turdia = ($_GET['idtd'] != "") ? " AND a.TURNO_DIALISIS = {$_GET['idtd']}" : "";

$query = "SELECT DATE_FORMAT(FECHA_R,'%d/%m/%Y'), cg.DESCRIPCION_CG, a.HORA_R, a.ID_ATENCION,
CONCAT_WS(' ', pac.NOMBRES, pac.APELLIDO_PATERNO, pac.APELLIDO_MATERNO) AS paciente, obsr.OBS
FROM atenciones a
LEFT JOIN codigos_generales cg ON a.TURNO_DIALISIS = cg.CODIGO AND cg.COD_TABLA='SIS_TURDIA'
INNER JOIN personas pac ON a.ID_CLIENTE = pac.ID_PERSONA
LEFT JOIN obs_resultados obsr ON a.ID_ATENCION = obsr.ID_ATENCION
WHERE (FECHA BETWEEN ? AND ?) $f_prev $f_conv $f_cto $f_turdia AND FECHA_R IS NOT NULL
ORDER BY a.FECHA_R, HORA_R";
$qresultados = $mysqli->prepare($query);
echo $mysqli->error;
$qresultados->bind_param('ss', $fi, $ft);
$qresultados->execute();
$qresultados->bind_result($at_fecha, $at_turno_dialisis, $at_hora, $at_idAtencion, $at_paciente, $at_obs);
$qresultados->store_result();
$nroAtenciones = $qresultados->num_rows;
$npaginas = floor($qresultados->num_rows / 22);

$resultados = array();
$analisis_disponibles = array();

class ResultadosDialisis extends TCPDF
{
	public function Header()
	{
		global $titulo;
		global $nombre_centro_contacto;
		global $nombre_turno_dialisis;
		global $nroAtenciones;
		$this->SetFont('times', '', 10);

		if ($nombre_centro_contacto != '') $this->writeHTMLCell('150', '', 120, 10, 'Centro de Toma de Muestras: ' . $nombre_centro_contacto, 0, 1, 0, true, 'L', true);

		$label = $nombre_turno_dialisis != "" ? $nombre_turno_dialisis : "Todos";
		$this->writeHTMLCell('150', '', 120, 20, "Turno de Diálisis: $label<br>N° de Atenciones: $nroAtenciones", 0, 1, 0, true, 'L', true);
		$this->writeHTMLCell('50', '', 230, 10, $titulo, 0, 1, 0, true, 'C', true);

		$this->setImageScale(2);
		$this->setJPEGQuality(100);
		$this->Image('logo.jpg', '10', '10');
	}

	public function Footer()
	{
		global $firma;
		$this->SetFont('times', '', 10);

		$this->writeHTMLCell('50', '', 230, 180, $firma, 0, 1, 0, true, 'C', true);
		$paginas = "Página " . $this->getAliasNumPage() . ' de ' . $this->getAliasNbPages();
		$this->writeHTMLCell('', '', '', '', $paginas, 0, 1, 0, true, 'C', true);
		$this->setImageScale(2.5);
		$this->setJPEGQuality(100);
		$this->Image('firma.jpg', '235', '160');
	}
}

$pdf = new ResultadosDialisis('L', 'mm', 'letter', true, 'UTF-8', false);

$pdf->SetMargins(10, 35, 10);
$pdf->SetHeaderMargin(10);
$pdf->SetFooterMargin(10);
$pdf->SetAutoPageBreak(true, 58);
$pdf->setFontSubsetting(true);
$pdf->SetFont('times', '', 10);

while ($qresultados->fetch()) {
	$resultados[$at_idAtencion] = array(
		'at_fecha' => $at_fecha,
		'at_turno_dialisis' => $at_turno_dialisis,
		'at_hora' => $at_hora,
		'at_paciente' => $at_paciente,
		'at_obs' => $at_obs,
		'at_idAtencion' => $at_idAtencion
	);
	$qanalisis = $mysqli->prepare('SELECT examenes_atenciones.COD_EXAMEN, ex.NOMBRE, RESULTADO, cg.DESCRIPCION_CG AS unidad, N_DECIMALES
FROM examenes_atenciones
INNER JOIN examenes ex ON examenes_atenciones.COD_EXAMEN=ex.COD_INTERNO
INNER JOIN codigos_generales cg ON ex.UNIDAD_MEDIDA=cg.CODIGO AND cg.COD_TABLA=\'SIS_UNIMED\'
WHERE ID_ATENCION=?');
	$qanalisis->bind_param('i', $at_idAtencion);
	$qanalisis->execute();
	$qanalisis->bind_result($ana_codExamen, $ana_nombre, $ana_resultado, $ana_unidad, $ana_ndecimales);
	$qanalisis->store_result();

	while ($qanalisis->fetch()) {
		if (is_numeric($ana_resultado)) {
			if ($ana_ndecimales == "") {
				$ana_resultado = number_format($ana_resultado, '2', ',', '.');
			} else {
				$ana_resultado = number_format($ana_resultado, $ana_ndecimales, ',', '.');
			}
		}

		if (strpos($ana_codExamen, '04.01.026') !== false) {
			$resultados[$at_idAtencion]['FERRI'] = $ana_resultado;
			$analisis_disponibles['FERRI'] = true;
		} elseif (strpos($ana_codExamen, '04.03.018') !== false) {
			$resultados[$at_idAtencion]['PARAT'] = $ana_resultado;
			$analisis_disponibles['PARAT'] = true;
		} elseif (strpos($ana_codExamen, '11.06.16') !== false) {
			$resultados[$at_idAtencion]['VIH'] = $ana_resultado;
			$analisis_disponibles['VIH'] = true;
		} elseif (strpos($ana_codExamen, '05.06.077') !== false) {
			$resultados[$at_idAtencion]['HEPB'] = $ana_resultado;
			$analisis_disponibles['HEPB'] = true;
		} elseif (strpos($ana_codExamen, '05.06.081') !== false) {
			$resultados[$at_idAtencion]['HEPC'] = $ana_resultado;
			$analisis_disponibles['HEPC'] = true;
		}
	}
	$qanalisis->close();
}
$qresultados->close();

$lista_resultados = array_values($resultados);
//for($i = 0; $i < $npaginas; $i++) {
$pdf->AddPage();
$tbl =
	'<table border="1" cellpadding="2" style="text-align: center">
		<thead>
			<tr>
				<th>FECHA RECEP.</th>
				<th>N° ATE</th>
				<th colspan="4">PACIENTE</th>';

if (isset($analisis_disponibles['FERRI'])) {
	$tbl .= '<th>FERRI</th>';
}
if (isset($analisis_disponibles['PARAT'])) {
	$tbl .= '<th>PARAT</th>';
}
if (isset($analisis_disponibles['VIH'])) {
	$tbl .= '<th>VIH</th>';
}
if (isset($analisis_disponibles['HEPB'])) {
	$tbl .= '<th>HEPB</th>';
}
if (isset($analisis_disponibles['HEPC'])) {
	$tbl .= '<th>HEPC</th>';
}
$tbl .= '
			</tr>
		</thead>
	<tbody>';

for ($j = 0; $j < count($lista_resultados); $j++) {
	//		$j = $i * 22 + $j;
	$tbl .= '<tr nobr="true">
			<td>' . $lista_resultados[$j]['at_fecha'] . '</td>
			<td>' . $lista_resultados[$j]['at_idAtencion'] . '</td>
			<td colspan="4" style="text-align: left">' . $lista_resultados[$j]['at_paciente'] . '</td>';

	if (isset($analisis_disponibles['FERRI'])) {
		$tbl .= '<td>' . $lista_resultados[$j]['FERRI'] . '</td>';
	}
	if (isset($analisis_disponibles['PARAT'])) {
		$tbl .= '<td>' . $lista_resultados[$j]['PARAT'] . '</td>';
	}
	if (isset($analisis_disponibles['VIH'])) {
		$tbl .= '<td>' . $lista_resultados[$j]['VIH'] . '</td>';
	}
	if (isset($analisis_disponibles['HEPB'])) {
		$tbl .= '<td>' . $lista_resultados[$j]['HEPB'] . '</td>';
	}
	if (isset($analisis_disponibles['HEPC'])) {
		$tbl .= '<td>' . $lista_resultados[$j]['HEPC'] . '</td>';
	}
	$tbl .= '</tr>';
}

$tbl .= '</tbody></table>';

$pdf->SetFont('times', '', 9);

$pdf->writeHTML($tbl, true, false, false, false, '');

ob_end_clean();
$pdf->Output('documento_pdf_nuevo.pdf', 'I');
