<?php
$pagina = 1;

define('PERMITIDO', true);
require_once("../inc/init.php");
require_once('../assets/tcpdf/tcpdf.php');

$titulo = 'Laboratorio Central<br>Arlegui 440 - Oficina 218<br>Viña del Mar<br>Fono: 32-2714189';
$firma = 'QF Andoni Etcheverry<br>Director Técnico';
$nombre_centro_contacto = '';

if ($_GET['idcc'] != '') {
	$query_centro_cto = 'SELECT NOMBRE from centros_contacto WHERE ID_CENTRO_CONTACTO = ?';
	$centro_contacto = $mysqli->prepare($query_centro_cto);
	echo $mysqli->error;
	$centro_contacto->bind_param('i', $_GET['idcc']);

	$centro_contacto->execute();
	$centro_contacto->bind_result($nombre_centro_contacto);
	$centro_contacto->store_result();
	$centro_contacto->fetch();
}

$nombre_turno_dialisis = '';

if ($_GET['idtd'] != '') {
	$query_turno_dialisis = 'SELECT DESCRIPCION_CG from codigos_generales WHERE CODIGO = ? AND COD_TABLA = \'SIS_TURDIA\'';
	$turno_dialisis = $mysqli->prepare($query_turno_dialisis);
	echo $mysqli->error;
	$turno_dialisis->bind_param('i', $_GET['idtd']);

	$turno_dialisis->execute();
	$turno_dialisis->bind_result($nombre_turno_dialisis);
	$turno_dialisis->store_result();
	$turno_dialisis->fetch();
}

$fi = (isset($_GET['f_inicio'])) ? $_GET['f_inicio'] : date('Y-m-d', strtotime('-1 week'));
$ft = (isset($_GET['f_termino'])) ? $_GET['f_termino'] : date('Y-m-d');
$f_prev = ($_GET['idpv'] != '') ? " AND a.ID_PREVISION = {$_GET['idpv']}" : "";
$f_conv = ($_GET['idcv'] != '') ? " AND a.ID_CONVENIO = {$_GET['idcv']}" : "";
$f_cto = ($_GET['idcc'] != '')  ? " AND a.ID_CENTRO_CONTACTO = {$_GET['idcc']}" : "";
$f_turdia = ($_GET['idtd'] != "") ? " AND a.TURNO_DIALISIS = {$_GET['idtd']}" : "";

$query = "SELECT DATE_FORMAT(FECHA_R,'%d/%m/%Y'), cg.DESCRIPCION_CG, a.HORA_R, a.ID_ATENCION,
CONCAT_WS(' ', pac.NOMBRES, pac.APELLIDO_PATERNO, pac.APELLIDO_MATERNO) AS paciente, obsr.OBS
FROM atenciones a
LEFT JOIN codigos_generales cg ON a.TURNO_DIALISIS = cg.CODIGO AND cg.COD_TABLA='SIS_TURDIA'
INNER JOIN personas pac ON a.ID_CLIENTE = pac.ID_PERSONA
LEFT JOIN obs_resultados obsr ON a.ID_ATENCION = obsr.ID_ATENCION
WHERE (a.FECHA BETWEEN ? AND ?) AND a.FLAG_ELIMINADO = 0 AND FECHA_R IS NOT NULL $f_prev $f_conv $f_cto $f_turdia 
ORDER BY a.FECHA_R, HORA_R";
$qresultados = $mysqli->prepare($query);
echo $mysqli->error;
$qresultados->bind_param('ss', $fi, $ft);
$qresultados->execute();
$qresultados->bind_result($at_fecha, $at_turno_dialisis, $at_hora, $at_idAtencion, $at_paciente, $at_obs);
$qresultados->store_result();
$nroAtenciones = $qresultados->num_rows;
$npaginas = floor($qresultados->num_rows / 22);

$resultados = array();
$analisis_disponibles = array();

class ResultadosDialisis extends TCPDF
{
	public function Header()
	{
		global $titulo;
		global $nombre_centro_contacto;
		global $nombre_turno_dialisis;
		global $nroAtenciones;
		$this->SetFont('times', '', 10);		
		
		if ($nombre_centro_contacto != '') $this->writeHTMLCell('150', '', 120, 10, 'Centro de Toma de Muestras: ' . $nombre_centro_contacto, 0, 1, 0, true, 'L', true);

		$label = $nombre_turno_dialisis != "" ? $nombre_turno_dialisis : "Todos";
		$this->writeHTMLCell('150', '', 120, 20, "Turno de Diálisis: $label<br>N° de Atenciones: $nroAtenciones", 0, 1, 0, true, 'L', true);
		$this->writeHTMLCell('50', '', 230, 10, $titulo, 0, 1, 0, true, 'C', true);
		
		$this->setImageScale(2);
		$this->setJPEGQuality(100);
		$this->Image('logo.jpg', '10', '10');
	}

	public function Footer()
	{
		global $firma;
		$this->SetFont('times', '', 10);

		$this->writeHTMLCell('50', '', 230, 180, $firma, 0, 1, 0, true, 'C', true);
		$paginas = "Página " . $this->getAliasNumPage() . ' de ' . $this->getAliasNbPages();
		$this->writeHTMLCell('', '', '', '', $paginas, 0, 1, 0, true, 'C', true);
		$this->setImageScale(2.5);
		$this->setJPEGQuality(100);
		$this->Image('firma.jpg', '235', '160');
	}
}

$pdf = new ResultadosDialisis('L', 'mm', 'letter', true, 'UTF-8', false);

$pdf->SetMargins(10, 35, 10);
$pdf->SetHeaderMargin(10);
$pdf->SetFooterMargin(10);
$pdf->SetAutoPageBreak(true, 58);
$pdf->setFontSubsetting(true);
$pdf->SetFont('times', '', 10);

while ($qresultados->fetch()) {
	$resultados[$at_idAtencion] = array(
		'at_fecha' => $at_fecha,
		'at_turno_dialisis' => $at_turno_dialisis,
		'at_hora' => $at_hora,
		'at_paciente' => $at_paciente,
		'at_obs' => $at_obs,
		'at_idAtencion' => $at_idAtencion
	);
	$qanalisis = $mysqli->prepare("SELECT examenes_atenciones.COD_EXAMEN, ex.NOMBRE, RESULTADO, cg.DESCRIPCION_CG, N_DECIMALES
	FROM examenes_atenciones
	INNER JOIN examenes ex ON examenes_atenciones.COD_EXAMEN = ex.COD_INTERNO
	INNER JOIN codigos_generales cg ON ex.UNIDAD_MEDIDA = cg.CODIGO AND cg.COD_TABLA = 'SIS_UNIMED'
	WHERE ID_ATENCION = ?");
	$qanalisis->bind_param('i', $at_idAtencion);
	$qanalisis->execute();
	$qanalisis->bind_result($ana_codExamen, $ana_nombre, $ana_resultado, $ana_unidad, $ana_ndecimales);
	$qanalisis->store_result();

	while ($qanalisis->fetch()) {
		if (is_numeric($ana_resultado)) {
			if ($ana_ndecimales == "") {
				$ana_resultado = number_format($ana_resultado, '2', ',', '.');
			} else {
				$ana_resultado = number_format($ana_resultado, $ana_ndecimales, ',', '.');
			}
		}

		if (strpos($ana_codExamen, "01.01.036") !== false) {
			$resultados[$at_idAtencion]['HEMA'] = $ana_resultado;
			$analisis_disponibles['HEMA'] = true;
		} elseif (strpos($ana_codExamen, "02.02.323") !== false) {
			$resultados[$at_idAtencion]['POT'] = $ana_resultado;
			$analisis_disponibles['POT'] = true;
		} elseif (strpos($ana_codExamen, "02.02.322") !== false) {
			$resultados[$at_idAtencion]['SOD'] = $ana_resultado;
			$analisis_disponibles['SOD'] = true;
		} elseif (strpos($ana_codExamen, "02.02.157") !== false) {
			$resultados[$at_idAtencion]['NUPRE'] = $ana_resultado;
			$analisis_disponibles['NUPRE'] = true;
		} elseif (strpos($ana_codExamen, "02.02.557") !== false) {
			$resultados[$at_idAtencion]['NUPOST'] = $ana_resultado;
			$analisis_disponibles['NUPOST'] = true;
		} elseif (strpos($ana_codExamen, "02.02.023") !== false) {
			$resultados[$at_idAtencion]['CREA'] = $ana_resultado;
			$analisis_disponibles['CREA'] = true;
		} elseif (strpos($ana_codExamen, "02.02.047") !== false) {
			$resultados[$at_idAtencion]['GLUC'] = $ana_resultado;
			$analisis_disponibles['GLUC'] = true;
		} elseif (strpos($ana_codExamen, "02.02.015") !== false) {
			$resultados[$at_idAtencion]['CAL'] = $ana_resultado;
			$analisis_disponibles['CAL'] = true;
		} elseif (strpos($ana_codExamen, "02.02.042") !== false) {
			$resultados[$at_idAtencion]['FOSF'] = $ana_resultado;
			$analisis_disponibles['FOSF'] = true;
		} elseif (strpos($ana_codExamen, "02.02.631") !== false) {
			$resultados[$at_idAtencion]['GOT'] = $ana_resultado;
			$analisis_disponibles['GOT'] = true;
		} elseif (strpos($ana_codExamen, "02.02.632") !== false) {
			$resultados[$at_idAtencion]['GPT'] = $ana_resultado;
			$analisis_disponibles['GPT'] = true;
		} elseif (strpos($ana_codExamen, "02.02.040") !== false) {
			$resultados[$at_idAtencion]['FALC'] = $ana_resultado;
			$analisis_disponibles['FALC'] = true;
		} elseif (strpos($ana_codExamen, "02.02.261") !== false) {
			$resultados[$at_idAtencion]['ALB'] = $ana_resultado;
			$analisis_disponibles['ALB'] = true;
		} elseif (strpos($ana_codExamen, "02.02.046") !== false) {
			$resultados[$at_idAtencion]['BIC'] = $ana_resultado;
			$analisis_disponibles['BIC'] = true;
		} elseif (strpos($ana_codExamen, "02.02.067") !== false) {
			$resultados[$at_idAtencion]['COL'] = $ana_resultado;
			$analisis_disponibles['COL'] = true;
		} elseif (strpos($ana_codExamen, "02.02.064") !== false) {
			$resultados[$at_idAtencion]['TRIG'] = $ana_resultado;
			$analisis_disponibles['TRIG'] = true;
			/*}elseif(strpos($ana_codExamen, "05.06.077")!==false){
			$resultados[$at_idAtencion]['HEPB']=$ana_resultado;
			$analisis_disponibles['HEPB'] = true;
		}elseif(strpos($ana_codExamen, "05.06.081")!==false){
			$resultados[$at_idAtencion]['HEPC']=$ana_resultado;
			$analisis_disponibles['HEPC'] = true;
		}elseif(strpos($ana_codExamen, "11.06.169")!==false){
			$resultados[$at_idAtencion]['VIH']=$ana_resultado;
			$analisis_disponibles['VIH'] = true;*/
		} elseif (strpos($ana_codExamen, "02.02.057") !== false) {
			$resultados[$at_idAtencion]['UPRE'] = $ana_resultado;
			$analisis_disponibles['UPRE'] = true;
		} elseif (strpos($ana_codExamen, "02.02.576") !== false) {
			$resultados[$at_idAtencion]['UPOST'] = $ana_resultado;
			$analisis_disponibles['UPOST'] = true;
		} elseif (strpos($ana_codExamen, "04.01.026") !== false) {
			$resultados[$at_idAtencion]['FERRI'] = $ana_resultado;
			$analisis_disponibles['FERRI'] = true;
		} elseif (strpos($ana_codExamen, "04.03.018") !== false) {
			$resultados[$at_idAtencion]['PARAT'] = $ana_resultado;
			$analisis_disponibles['PARAT'] = true;
		} elseif (strpos($ana_codExamen, "01.01.038") !== false) {
			$resultados[$at_idAtencion]['HEMO'] = $ana_resultado;
			$analisis_disponibles['HEMO'] = true;
		} elseif (strpos($ana_codExamen, "04.01.028") !== false) {
			$resultados[$at_idAtencion]['FIE'] = $ana_resultado;
			$analisis_disponibles['FIE'] = true;
		} elseif (strpos($ana_codExamen, "04.01.128") !== false) {
			$resultados[$at_idAtencion]['SAT'] = $ana_resultado;
			$analisis_disponibles['SAT'] = true;
		} elseif (strpos($ana_codExamen, "04.01.228") !== false) {
			$resultados[$at_idAtencion]['TIBC'] = $ana_resultado;
			$analisis_disponibles['TIBC'] = true;
		}
	}
	$qanalisis->close();
}
$qresultados->close();

$lista_resultados = array_values($resultados);
//for($i = 0; $i < $npaginas; $i++) {
$pdf->AddPage();
$tbl =
	'<table border="1" cellpadding="2" style="text-align: center">
		<thead>
			<tr>
				<th>FECHA RECEP.</th>
				<th>N° ATE</th>
				<th colspan="4">PACIENTE</th>';

if (isset($analisis_disponibles['HEMA'])) {
	$tbl .= '<th>HEMA</th>';
}
if (isset($analisis_disponibles['HEMO'])) {
	$tbl .= '<th>HEMO</th>';
}
if (isset($analisis_disponibles['POT'])) {
	$tbl .= '<th>POT</th>';
}
if (isset($analisis_disponibles['SOD'])) {
	$tbl .= '<th>SOD</th>';
}
if (isset($analisis_disponibles['NUPRE'])) {
	$tbl .= '<th>NUPRE</th>';
}
if (isset($analisis_disponibles['NUPOST'])) {
	$tbl .= '<th>NUPOST</th>';
}
if (isset($analisis_disponibles['UPRE'])) {
	$tbl .= '<th>UPRE</th>';
}
if (isset($analisis_disponibles['UPOST'])) {
	$tbl .= '<th>UPOST</th>';
}
if (isset($analisis_disponibles['CREA'])) {
	$tbl .= '<th>CREA</th>';
}
if (isset($analisis_disponibles['GLUC'])) {
	$tbl .= '<th>GLUC</th>';
}
if (isset($analisis_disponibles['CAL'])) {
	$tbl .= '<th>CAL</th>';
}
if (isset($analisis_disponibles['FOSF'])) {
	$tbl .= '<th>FOSF</th>';
}
if (isset($analisis_disponibles['GOT'])) {
	$tbl .= '<th>GOT</th>';
}
if (isset($analisis_disponibles['GPT'])) {
	$tbl .= '<th>GPT</th>';
}
if (isset($analisis_disponibles['FALC'])) {
	$tbl .= '<th>FALC</th>';
}
if (isset($analisis_disponibles['ALB'])) {
	$tbl .= '<th>ALB</th>';
}
if (isset($analisis_disponibles['BIC'])) {
	$tbl .= '<th>BIC</th>';
}
if (isset($analisis_disponibles['COL'])) {
	$tbl .= '<th>COL</th>';
}
if (isset($analisis_disponibles['TRIG'])) {
	$tbl .= '<th>TRIG</th>';
}
/*if(isset($analisis_disponibles['HEPB'])) {
		$tbl .= '<th>HEPB</th>';
	}
	if(isset($analisis_disponibles['HEPC'])) {
		$tbl .= '<th>HEPC</th>';
	}
	if(isset($analisis_disponibles['VIH'])) {
		$tbl .= '<th>VIH</th>';
	}
	if(isset($analisis_disponibles['FERRI'])) { #SE SACA EL 06-07-18 POR AE
		$tbl .= '<th>FERRI</th>';
	}
	if(isset($analisis_disponibles['PARAT'])) { #SE SACA EL 06-07-18 POR AE
		$tbl .= '<th>PARAT</th>';
	}*/
if (isset($analisis_disponibles['FIE'])) {
	$tbl .= '<th>FIE</th>';
}
if (isset($analisis_disponibles['SAT'])) {
	$tbl .= '<th>SAT</th>';
}
if (isset($analisis_disponibles['TIBC'])) {
	$tbl .= '<th>TIBC</th>';
}
$tbl .= '
			</tr>
		</thead>
	<tbody>';

for ($j = 0; $j < count($lista_resultados); $j++) {
	$tbl .= '<tr nobr="true">
		<td>' . $lista_resultados[$j]['at_fecha'] . '</td>
		<td>' . $lista_resultados[$j]['at_idAtencion'] . '</td>
		<td colspan="4" style="text-align: left">' . $lista_resultados[$j]['at_paciente'] . '</td>';

	if (isset($analisis_disponibles['HEMA'])) {
		$tbl .= '<td>' . $lista_resultados[$j]['HEMA'] . '</td>';
	}
	if (isset($analisis_disponibles['HEMO'])) {
		$tbl .= '<td>' . $lista_resultados[$j]['HEMO'] . '</td>';
	}
	if (isset($analisis_disponibles['POT'])) {
		$tbl .= '<td>' . $lista_resultados[$j]['POT'] . '</td>';
	}
	if (isset($analisis_disponibles['SOD'])) {
		$tbl .= '<td>' . $lista_resultados[$j]['SOD'] . '</td>';
	}
	if (isset($analisis_disponibles['NUPRE'])) {
		$tbl .= '<td>' . $lista_resultados[$j]['NUPRE'] . '</td>';
	}
	if (isset($analisis_disponibles['NUPOST'])) {
		$tbl .= '<td>' . $lista_resultados[$j]['NUPOST'] . '</td>';
	}
	if (isset($analisis_disponibles['UPRE'])) {
		$tbl .= '<td>' . $lista_resultados[$j]['UPRE'] . '</td>';
	}
	if (isset($analisis_disponibles['UPOST'])) {
		$tbl .= '<td>' . $lista_resultados[$j]['UPOST'] . '</td>';
	}
	if (isset($analisis_disponibles['CREA'])) {
		$tbl .= '<td>' . $lista_resultados[$j]['CREA'] . '</td>';
	}
	if (isset($analisis_disponibles['GLUC'])) {
		$tbl .= '<td>' . $lista_resultados[$j]['GLUC'] . '</td>';
	}
	if (isset($analisis_disponibles['CAL'])) {
		$tbl .= '<td>' . $lista_resultados[$j]['CAL'] . '</td>';
	}
	if (isset($analisis_disponibles['FOSF'])) {
		$tbl .= '<td>' . $lista_resultados[$j]['FOSF'] . '</td>';
	}
	if (isset($analisis_disponibles['GOT'])) {
		$tbl .= '<td>' . $lista_resultados[$j]['GOT'] . '</td>';
	}
	if (isset($analisis_disponibles['GPT'])) {
		$tbl .= '<td>' . $lista_resultados[$j]['GPT'] . '</td>';
	}
	if (isset($analisis_disponibles['FALC'])) {
		$tbl .= '<td>' . $lista_resultados[$j]['FALC'] . '</td>';
	}
	if (isset($analisis_disponibles['ALB'])) {
		$tbl .= '<td>' . $lista_resultados[$j]['ALB'] . '</td>';
	}
	if (isset($analisis_disponibles['BIC'])) {
		$tbl .= '<td>' . $lista_resultados[$j]['BIC'] . '</td>';
	}
	if (isset($analisis_disponibles['COL'])) {
		$tbl .= '<td>' . $lista_resultados[$j]['COL'] . '</td>';
	}
	if (isset($analisis_disponibles['TRIG'])) {
		$tbl .= '<td>' . $lista_resultados[$j]['TRIG'] . '</td>';
	}
	if (isset($analisis_disponibles['HEPB'])) {
		$tbl .= '<td>' . $lista_resultados[$j]['HEPB'] . '</td>';
	}
	if (isset($analisis_disponibles['HEPC'])) {
		$tbl .= '<td>' . $lista_resultados[$j]['HEPC'] . '</td>';
	}
	if (isset($analisis_disponibles['VIH'])) {
		$tbl .= '<td>' . $lista_resultados[$j]['VIH'] . '</td>';
	}
	/*
	if(isset($analisis_disponibles['FERRI'])) {
		$tbl .= '<td>' . $lista_resultados[$j]['FERRI'] . '</td>';
	}
	if(isset($analisis_disponibles['PARAT'])) {
		$tbl .= '<td>' . $lista_resultados[$j]['PARAT'] . '</td>';
	}*/
	if (isset($analisis_disponibles['FIE'])) {
		$tbl .= '<td>' . $lista_resultados[$j]['FIE'] . '</td>';
	}
	if (isset($analisis_disponibles['SAT'])) {
		$tbl .= '<td>' . $lista_resultados[$j]['SAT'] . '</td>';
	}
	if (isset($analisis_disponibles['TIBC'])) {
		$tbl .= '<td>' . $lista_resultados[$j]['TIBC'] . '</td>';
	}
	$tbl .= '</tr>';
}

$tbl .= '</tbody></table>';
$pdf->SetFont('times', '', 8);
$pdf->writeHTML($tbl, true, false, false, false, '');

ob_end_clean();
$pdf->Output('documento_pdf_nuevo.pdf', 'I');
