<?php
define('PERMITIDO', true);
# $pagina = 34;
require_once("../inc/init.php");
require_once '../assets/php/PHPExcel.php';

/** Error reporting */
error_reporting(E_ALL);
ini_set('display_errors', TRUE);
ini_set('display_startup_errors', TRUE);

if (PHP_SAPI == 'cli') die('This file should only be run from a Web Browser');

// ini_set("memory_limit","512M");
// ini_set('max_execution_time', 20);

$objPHPExcel = new PHPExcel();
$objPHPExcel->getProperties()->setCreator('RIPIT')->setTitle('Reporte');
$objPHPExcel->setActiveSheetIndex(0);

// // Set document properties
// $objPHPExcel->getProperties()
//   ->setCreator("RIPIT Chile")
//   ->setLastModifiedBy("RIPIT Chile")
//   ->setTitle("Resultados Diálisis")
//   ->setSubject("Resultados Diálisis")
//   ->setDescription("Resultados Diálisis")
//   ->setKeywords("Resultados Diálisis")
//   ->setCategory("Resultados Diálisis");

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
////////////////////////     CONSULTAS      //////////////////////////////

$fechaDesde = (isset($_GET['f_desde'])) ? $_GET['f_desde'] : date('Y-m-d', strtotime('-1 week'));
$fechaHasta = (isset($_GET['f_hasta'])) ? $_GET['f_hasta'] : date('Y-m-d');
$f_prev = ($_GET['idpv'] != '') ? " AND a.ID_PREVISION = {$_GET['idpv']}" : "";
$f_conv = ($_GET['idcv'] != '') ? " AND a.ID_CONVENIO = {$_GET['idcv']}" : "";
$f_cto = ($_GET['idcc'] != '')  ? " AND a.ID_CENTRO_CONTACTO = {$_GET['idcc']}" : "";
$f_turdia = ($_GET['idtd'] != "") ? " AND a.TURNO_DIALISIS = {$_GET['idtd']}" : "";

$stmt_atenciones = $mysqli->prepare("SELECT DATE_FORMAT(FECHA_R,'%d/%m/%Y'), cg.DESCRIPCION_CG, a.HORA_R, a.ID_ATENCION,
CONCAT_WS(' ', pac.NOMBRES, pac.APELLIDO_PATERNO, pac.APELLIDO_MATERNO) AS paciente, obsr.OBS
FROM atenciones a
LEFT JOIN codigos_generales cg ON a.TURNO_DIALISIS = cg.CODIGO AND cg.COD_TABLA='SIS_TURDIA'
INNER JOIN personas pac ON a.ID_CLIENTE = pac.ID_PERSONA
LEFT JOIN obs_resultados obsr ON a.ID_ATENCION = obsr.ID_ATENCION
WHERE (a.FECHA BETWEEN ? AND ?) AND a.FLAG_ELIMINADO = 0 AND FECHA_R IS NOT NULL $f_prev $f_conv $f_cto $f_turdia 
ORDER BY a.FECHA_R, HORA_R");
echo $mysqli->error;
$stmt_atenciones->bind_param('ss', $fechaDesde, $fechaHasta);
$stmt_atenciones->execute();
$stmt_atenciones->bind_result($at_fecha, $at_turno_dialisis, $at_hora, $at_idAtencion, $at_paciente, $at_obs);
$stmt_atenciones->store_result();
$nroAtenciones = $stmt_atenciones->num_rows;

/******************************************************************************************************************************************************************************/
/******************************************************************************************************************************************************************************/
/******************************************************************************************************************************************************************************/

$examenesDeInforme = array(
  "04.01.026" => "FERRI",
  "04.03.018" => "PARAT",
  "11.06.169" => "VIH",
  "05.06.077" => "HEPB",
  "05.06.081" => "HEPC",
);

$headerStyle = array(
  'font'  => array(
    'name'  => 'Calibri',
    'size'  => 11,
    'color' => array('rgb' => 'FFFFFF'),
    'bold'  => true,
  ),
  'fill' => array(
    'type' => PHPExcel_Style_Fill::FILL_SOLID,
    'color' => array('rgb' => '4F81BD')
  ),
  'alignment' => array(
    'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,
    'wrapText' => true // Esto establece el texto envuelto para todas las celdas
  ),
  'borders' => array(
    'allborders' => array(
      'style' => PHPExcel_Style_Border::BORDER_THIN
    )
  ),
  'autoSize' => true // Esto establece el tamaño automático de las columnas
);

$cellStyle = array(
  'font'  => array(
    'name'  => 'Calibri',
    'size'  => 11,
    'color' => array('rgb' => 'FFFFFF'),
  ),
  'alignment' => array(
    'wrapText' => true // Esto establece el texto envuelto para todas las celdas
  ),
  'autoSize' => true // Esto establece el tamaño automático de las columnas
);

// Definir las variables para el inicio y el fin de las columnas
$columnasInicio = 'A';
$columnasFin = 'H';

// Establecer el formato de texto de las celdas (cuando sea necesario)
// $objPHPExcel->getActiveSheet()
//   ->getStyle($columnasInicio . '2:' . $columnasFin . $num_rows + 1)
//   ->getNumberFormat()
//   ->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_TEXT);

// Aplicar el estilo al rango de celdas
$objPHPExcel->getActiveSheet()->getStyle($columnasInicio . '1:' . $columnasFin . '1')->applyFromArray($headerStyle);

////////////////////////////////////////////////////////////////////////////////////
////////////////////////     ESCRITURA EN CELDAS      //////////////////////////////

$objPHPExcel->getActiveSheet()->setCellValue("A1", "Fecha Recepción");
$objPHPExcel->getActiveSheet()->setCellValue("B1", "N° Atención");
$objPHPExcel->getActiveSheet()->setCellValue("C1", "Paciente");
$columnaInicio = 'D'; // Letra de la primera columna
foreach ($examenesDeInforme as $valor) {
  $objPHPExcel->getActiveSheet()->setCellValue($columnaInicio . '1', $valor);
  $columnaInicio++; // Mover a la siguiente columna
}

while ($stmt_atenciones->fetch()) {
  $resultadosAtencion = []; // Array para almacenar los resultados de los exámenes de esta atención

  $stmt_examenesAtencion = $mysqli->prepare("SELECT ea.COD_EXAMEN, ex.NOMBRE, RESULTADO, cg.DESCRIPCION_CG, N_DECIMALES
	FROM examenes_atenciones ea
	INNER JOIN examenes ex ON ea.COD_EXAMEN = ex.COD_INTERNO
	INNER JOIN codigos_generales cg ON ex.UNIDAD_MEDIDA = cg.CODIGO AND cg.COD_TABLA = 'SIS_UNIMED'
	WHERE ID_ATENCION = ?");
  $stmt_examenesAtencion->bind_param('i', $at_idAtencion);
  $stmt_examenesAtencion->execute();
  $stmt_examenesAtencion->bind_result($ex_codExamen, $ex_nombre, $ex_resultado, $ex_unidad, $ex_ndecimales);
  $stmt_examenesAtencion->store_result();

  while ($stmt_examenesAtencion->fetch()) {
    // Verificar si el examen actual está en la lista $examenesDeInforme
    if (array_key_exists($ex_codExamen, $examenesDeInforme) && is_numeric($ex_resultado)) {
      $nro_decimales = ($ex_ndecimales != "") ? $ex_ndecimales : 2;
      $ex_resultado = number_format($ex_resultado, $nro_decimales, ',', '.');
      $resultadosAtencion[$examenesDeInforme[$ex_codExamen]] = $ex_resultado; // Agregar el resultado al array de resultados de esta atención
    }
  }
  $stmt_examenesAtencion->close();

  // Agregar esta atención y sus resultados a la lista de resultados
  $resultados[] = [
    'at_fecha' => $at_fecha,
    'at_idAtencion' => $at_idAtencion,
    'at_paciente' => $at_paciente,
    'resultados' => $resultadosAtencion // Almacenar los resultados de los exámenes relevantes
  ];
}

$indiceFila = 2;
foreach ($resultados as $resultado) {
  $objPHPExcel->getActiveSheet()
    ->setCellValue('A' . $indiceFila, $resultado['at_fecha'])
    ->setCellValue('B' . $indiceFila, $resultado['at_idAtencion'])
    ->setCellValue('C' . $indiceFila, $resultado['at_paciente']);

  $columnaActual = 'D'; // Comenzamos desde la columna D
  foreach ($examenesDeInforme as $clave => $valor) {
    // Verificar si hay un resultado para este examen en esta atención
    $resultadoExamen = isset($resultado['resultados'][$valor]) ? $resultado['resultados'][$valor] : ''; // Agregar el resultado a la celda correspondiente
    $objPHPExcel->getActiveSheet()->setCellValue($columnaActual . $indiceFila, $resultadoExamen);
    $columnaActual++; // Mover a la siguiente columna
  }
  // Incrementar el índice de fila para la siguiente atención
  $indiceFila++;
}

// Establecer tamaño automático de las columnas
for ($letra = $columnasInicio; $letra <= $columnasFin; $letra++) {
  $objPHPExcel->getActiveSheet()->getColumnDimension($letra)->setAutoSize(true);
}

$fechaDesdeFormateada = date('d-m-Y', strtotime($fechaDesde));
$fechaHastaFormateada = date('d-m-Y', strtotime($fechaHasta));

header('Content-Disposition: attachment;filename="Resultados Dialisis Parte 2 ' . $fechaDesdeFormateada . ' a ' . $fechaHastaFormateada . '.xlsx"');
$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');

die();
