<?php
$pagina = 7;
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
require_once __DIR__ . '/inc.php';

// function VerResulEmi($NumTransac) {
//   global $urlWsdlImed;

//   try {
//     $client = new SoapClient($urlWsdlImed, ['trace' => 1]);
//     $resVerResulEmi = $client->__soapCall("VerResulEmi", [
//       "CodUsuardio" => "78385630-1",
//       "CodClave" => "78385630",
//       "NumTransac" => $NumTransac
//     ]);
//     return $resVerResulEmi;
//   } catch (SoapFault $sf) {
//     return false; # $sf->getMessage()
//   }
// }

// $options_formaPago = "";
// $qOptionsFormaPago = $mysqli->prepare("SELECT CODIGO, DESCRIPCION_CG FROM codigos_generales WHERE COD_TABLA = 'SIS_FORPAG' AND DESCRIPCION_CG != 'BONO'");
// $qOptionsFormaPago->execute();
// $qOptionsFormaPago->bind_result($codigoMetodoPago, $descripcionMetodoPago);
// $qOptionsFormaPago->store_result();
// while ($qOptionsFormaPago->fetch()) {
//   $options_formaPago .= "<option value='$codigoMetodoPago'> $descripcionMetodoPago </option>";
// }
// $qOptionsFormaPago->close();

$idate = isset($_GET['idate']) ? $_GET['idate'] : "-1";
$idemp = isset($_GET['idemp']) ? $_GET['idemp'] : "-1";
$urlModal = "md_examenesAtencion.php?idate=$idate&idemp=$idemp";
# $urlPagosAtencion = "../c_pagos/d_pagos.php?idate=$idate";

$qAtencion = $mysqli->prepare("SELECT a.ID_CENTRO_CONTACTO, a.ID_CONVENIO, a.NUM_TRANSACCION_IMED, a.COD_AUDITORIA_IMED, a.FLAG_PAGO_IMED,
CONCAT_WS('-', p.NRO_RUT, p.DV_RUT), p.GENERO, cc.NOMBRE
FROM atenciones a
LEFT JOIN personas p ON p.ID_PERSONA = a.ID_CLIENTE
LEFT JOIN centros_contacto cc ON cc.ID_CENTRO_CONTACTO = a.ID_CENTRO_CONTACTO
WHERE a.ID_ATENCION = ?");
$qAtencion->bind_param('i', $idate);
$qAtencion->execute();
$qAtencion->bind_result(
  $ate_idCentroContacto,
  $ate_idConvenio,
  $ate_numTransacImed,
  $ate_codAuditoriaImed,
  $ate_flagPagoImed,
  $ate_rutPaciente,
  $ate_generoPaciente,
  $ate_nombreCentroContacto
);
$qAtencion->store_result();
$qAtencion->fetch();
$qAtencion->close();

# $resVerResulEmi = VerResulEmi($ate_numTransacImed);

$qEmpresa = $mysqli->prepare("SELECT NOMBRE_E, COD_FINANCIADOR_IMED FROM empresas WHERE ID_EMPRESA = ?");
$qEmpresa->bind_param('i', $idemp);
$qEmpresa->execute();
$qEmpresa->bind_result($nombreEmpresa, $codFinanciadorImedEmpresa);
$qEmpresa->store_result();
$qEmpresa->fetch();
$qEmpresa->close();

$validaciónPcr = validarDatosAtenciónPcr($idate);

$qExamenes = $mysqli->prepare("SELECT ea.COD_EXAMEN, ea.F_HIJO, ea.PRECIO_EXAMEN, ea.PREV, ea.ID_EXATE,
ex.NOMBRE, ex.FLAG_AGRUPACION, ex.FLAG_AGRUPACION_HOMOLOGADA_IMED, em.NBR  
FROM examenes_atenciones ea
INNER JOIN examenes ex ON ea.COD_EXAMEN = ex.COD_INTERNO 
LEFT JOIN empresas em ON ea.PREV = em.ID_EMPRESA 
WHERE ea.ID_ATENCION = ? AND ea.F_HIJO IS NULL");
$qExamenes->bind_param('i', $idate);
$qExamenes->execute();
$qExamenes->bind_result(
  $ex_codExamen,
  $ex_flagHijo,
  $ex_precio,
  $ex_prev,
  $ex_idExate,
  $ex_nombre,
  $ex_flagAgrupacion,
  $ex_flagAgrupacionHomologada,
  $ex_nbr
);
$qExamenes->store_result();

ob_start();
?>

<div class="modal-header">
  <button type="button" class="close" data-dismiss="modal" aria-hidden="true">
    &times;
  </button>
  <h4 class="modal-title" id="myModalLabel"> Ingreso de exámenes - Empresa: <?= $nombreEmpresa ?></h4>
</div>

<div class="modal-body smart-form">
  <form action="sql_cod.php" method="post" id="formAgregarExamen" class="smart-form">
    <div class="row">
      <section class="col col-8">
        <div class="inline-group">
          <label class="radio">
            <input type="radio" name="id_empresa" value="<?= $idemp ?>" checked>
            <i></i>Precio Empresa
          </label>
          <label class="radio">
            <input type="radio" name="id_empresa" value="37">
            <i></i>Precio Particular
          </label>
        </div>
      </section>
    </div>
    <div class="row">
      <section class="col col-9">
        <input id="selectExamen" name="cod_examen" style="width: -webkit-fill-available;">
      </section>
      <section class="col col-2">
        <a class="btn btn-sm btn-success btn-agregarExamen" data-form="#formAgregarExamen"> <i class="fa fa-lg fa-plus"> </i> Agregar examen </a>
      </section>
    </div>
    <input type="hidden" name="formAgregarExamen" value="formAgregarExamen" />
    <input type="hidden" name="id_convenio_atencion" value="<?= $ate_idConvenio ?>" />
    <input type="hidden" name="id_atencion" value="<?= $idate ?>" />
  </form>

  <table class="table table-hover table-responsive">
    <thead>
      <tr bgcolor="#999999">
        <th>Código</th>
        <th>Nombre</th>
        <th>Empresa</th>
        <th>Agrupación</th>
        <th>Precio</th>
        <th>&nbsp;</th>
      </tr>
    </thead>
    <tbody>
      <?php while ($qExamenes->fetch()) { ?>
        <tr>
          <td><?= $ex_codExamen ?></td>
          <td><?= $ex_nombre ?></td>
          <td><?= $ex_prev == 0 ? "PARTICULAR" : $ex_nbr ?></td> <!-- # prev = 0 para examenes con valor particular -->
          <td>
            <?= $ex_flagAgrupacion == "S" ? "Si" : "No"; ?>
            <? if ($integracionImed && $ex_flagAgrupacion == "S") echo $ex_flagAgrupacionHomologada == 1 ? "(homologada)" : "(no homologada)"; ?>
          </td>
          <td><?= "$ " . number_format($ex_precio, '0', ',', '.'); ?></td>
          <td>
            <a class="btn btn-link btn-eliminarExamen" data-id_exa="<?= $ex_idExate ?>" data-cod_ex="<?= $ex_codExamen ?>" data-precio="<?= $ex_precio ?>" data-id_prev="<?= $ex_prev ?>">
              <i class="fa fa-trash-o fa-lg txt-color-red"></i>
            </a>
          </td>
        </tr>
      <?php }
      $qExamenes->close(); ?>
    </tbody>
  </table>

  <? if ($integracionImed && $usuario_perfil != "EXTERNO") { ?>
    <br>
    <div class="row">
      <section class="col col-8">
        <h4> <b>Integración I-MED: </b> <a class="btn btn-link btn-reloadModal"> <i class="fa fa-refresh fa-lg txt-color-green"> </i> Actualizar </a> </h4>
      </section>
    </div>
    <? if (!$resVerResulEmi) { ?>
      <p> Error en I-MED </p>
    <? } else { ?>
      <form action="<?= $urlFormularioPostImed ?>" method="post" target="_blank" class="smart-form" id="FormEmitirBonoParte2">
        <!-- CodEstado: 1 = En proceso, 2 = Finalizado con éxito, 4 = No hay información, 5 = Anulado -->
        <div class="row">
          <section class="col col-3">
          </section>
          <section class="col col-3">
            <label class="select">
              <select id="id_centro_contacto" class="input-sm">
                <option value=''>Seleccione Local</option>
                <option value='15031'>Arcadia</option>
                <option value='5059'>Edwards</option>
              </select> <i></i>
            </label>
            <div class="note"> Local del lector de huella </div>
          </section>
          <section class="col col-2">
            <a <? if (in_array($resVerResulEmi['CodEstado'], [2])) echo "disabled" ?> class="btn btn-sm btn-block btn-success btn-emitirBonos" style="width:110%">
              <i class="fa fa-arrow-right"> </i> Emitir Bonos
            </a>
          </section>
          <section class="col col-4">
            <b>Estado: </b> (<?= $resVerResulEmi['CodEstado'] ?>) <?= $resVerResulEmi['GloEstado'] ?>
          </section>
          <!-- 
            <div class="col col-2">
              <button class="btn btn-sm btn-block btn-success" type="submit" > Terminar </button>
            </div>
            -->
        </div>
        <hr><br>
        <div class="row">
          <section class="col col-3">
            <?= $ate_nombreCentroContacto ?>
            <div class="note"> Local de atención </div>
          </section>
          <section class="col col-3">
            <label class="select">
              <select id="forma_pago" class="input-sm">
                <?= $options_formaPago ?>
              </select> <i></i>
            </label>
            <div class="note"> Forma de Pago del Copago </div>
          </section>
          <section class="col col-2">
            <a <? if (in_array($resVerResulEmi['CodEstado'], [1, 4, 5]) || $ate_flagPagoImed == 1) echo "disabled" ?> class="btn btn-sm btn-block btn-success btn-obtenerBonos" style="width:110%">
              <i class="fa fa-money"> </i> Obtener Bonos
            </a>
          </section>
          <section class="col col-4">
            <b>Estado: </b> <?= $ate_flagPagoImed == 1 ? 'Bonos obtenidos' : 'Pendiente' ?>
          </section>
        </div>
        <hr><br>
        <div class="row">
          <section class="col col-3">
          </section>
          <section class="col col-3">
            <label class="select">
              <select id="id_centro_contacto_anular" class="input-sm">
                <option value=''>Seleccione Local</option>
                <option value='15031'>Arcadia</option>
                <option value='5059'>Edwards</option>
              </select> <i></i>
            </label>
            <div class="note"> Local del lector de huella </div>
          </section>
          <section class="col col-2">
            <a <? if (in_array($resVerResulEmi['CodEstado'], [1, 4, 5]) || $ate_flagPagoImed == 0) echo "disabled" ?> class="btn btn-sm btn-warning btn-block btn-anularBonos" style="width:110%">
              <i class="fa fa-times"> </i> Anular Bonos
            </a>
          </section>
        </div>
        <input type="hidden" name="NumTransac" value="<?= $ate_numTransacImed ?>" />
        <input type="hidden" name="NroAuditoria" value="<?= $ate_codAuditoriaImed ?>" />
      </form>
    <? } ?>
  <? } ?>
</div>

<div class="modal-footer">
  <button type="button" class="btn btn-default" data-dismiss="modal">
    Cerrar
  </button>
</div>

<script>
  $(document).ready(function() {
    var validaciónPcr = '<?= $validaciónPcr ?>';
    $('#selectExamen').select2({
      placeholder: "Buscar examen",
      minimumInputLength: 1,
      formatInputTooShort: function() {
        return 'Ingrese uno o mas caracteres';
      },
      formatSearching: "Buscando...",
      formatNoMatches: "No se encontraron resultados",
      ajax: {
        type: "POST",
        url: "../o_atenciones/ajax_examenes.php",
        dataType: 'json',
        quietMillis: 100,
        data: function(term, page) {
          return {
            busqueda: term,
            id_atencion: "<?= $idate ?>",
            genero: "<?= $ate_generoPaciente ?>",
            id_empresa: $("input[name='id_empresa']:checked").val()
          };
        },
        results: function(data) {
          return {
            results: $.map(data, function(item) {
              return {
                id: item.codExamen,
                text: item.codExamen + " - " + item.nombreExamen,
              }
            })
          };
        },
        cache: true
      },
      escapeMarkup: function(m) {
        return m;
      } // we do not want to escape markup since we are displaying html in results
    });

    $(".btn-agregarExamen").on("click", function() {
      console.log($('#selectExamen').val(), validaciónPcr);
      if ($('#selectExamen').val() == "00.00.069" && validaciónPcr) {
        error(validaciónPcr);
        return false;
      }
      // $(this).attr('disabled'); 
      $('.btn-agregarExamen').prop('disabled', true);
      var form = $(this).data("form");
      $.post($(form).attr("action"), $(form).serialize(), function(data) {
        if (data.exito) {
          exito();
          $('#md_examenesAtencion .modal-content').load("<?= $urlModal ?>");
          $('#md_examenesAtencion').on('hidden.bs.modal', function() {
            location.reload();
          });
        } else {
          // $(this).removeAttr('disabled'); 
          // $('.btn-agregarExamen').prop('disabled', false);
          error(data.mensaje);
        }
      }, 'json');
    });

    $(".btn-eliminarExamen").on("click", function() {
      if (confirm("Desea eliminar el examen de la atención?")) {
        $.post("sql_cod.php", {
          eliminarExamen: 1,
          id_examen_atencion: $(this).data("id_exa"),
          cod_examen: $(this).data("cod_ex"),
          precio_examen: $(this).data("precio"),
          id_empresa_examen: $(this).data("id_prev"),
          id_atencion: "<?= $idate ?>",
          id_convenio_atencion: "<?= $ate_idConvenio ?>"
        }, function(data) {
          if (data.exito) {
            exito();
            $('#md_examenesAtencion .modal-content').load("<?= $urlModal ?>");
            $('#md_examenesAtencion').on('hidden.bs.modal', function() {
              location.reload()
            });
          } else {
            error(data.mensaje);
          }
        }, 'json');
      }
    });

    /////////////////////////////////////////// I-MED ////////////////////////////////////////////////////////////////
    /////////////////////////////////////////// I-MED ////////////////////////////////////////////////////////////////
    /////////////////////////////////////////// I-MED ////////////////////////////////////////////////////////////////
    // $('.btn-emitirBonos').on('click', function() {
    //   console.log($('#id_centro_contacto option:selected').val());
    //   if (confirm('¿Desea emitir bonos para esta atención?')) {
    //     var codEstado = "<?= $resVerResulEmi['CodEstado'] ?>";
    //     if ($("input[name=NroAuditoria]").val() == "" || codEstado == 5) { // CodEstado 5 = Anulado
    //       console.log("post");
    //       $.post('soap.php', {
    //         emitirBonos: 1,
    //         id_atencion: "<?= $idate ?>",
    //         id_prevision: "<?= $idemp ?>",
    //         cod_financiador_imed: "<?= $codFinanciadorImedEmpresa ?>",
    //         rut_paciente: "<?= $ate_rutPaciente ?>",
    //         id_centro_contacto: $('#id_centro_contacto option:selected').val()
    //       }, function(data) {
    //         if (data.exito) {
    //           // exito(data.mensaje);
    //           // location.reload();
    //           $("input[name=NumTransac]").val(data.NumTransac);
    //           $("input[name=NroAuditoria]").val(data.CodAuditoria);
    //           $("#FormEmitirBonoParte2").submit();
    //         } else {
    //           error(data.mensaje);
    //         }
    //       }, 'json');
    //     } else {
    //       console.log("submit");
    //       $("#FormEmitirBonoParte2").submit();
    //     }
    //   }
    // });

    // $('.btn-obtenerBonos').on('click', function() {
    //   if (confirm('¿Desea generar pagos con los bonos generados en I-Med?')) {
    //     $.post('soap.php', {
    //       obtenerBonos: 1,
    //       id_atencion: "<?= $idate ?>",
    //       id_prevision: "<?= $idemp ?>",
    //       num_transaccion: "<?= $ate_numTransacImed ?>",
    //       cod_financiador_imed: "<?= $codFinanciadorImedEmpresa ?>",
    //       id_centro_contacto: "<?= $ate_idCentroContacto ?>",
    //       forma_pago: $('#forma_pago option:selected').val()
    //     }, function(data) {
    //       if (data.exito) {
    //         exito(data.mensaje);
    //         window.open("<?= $urlPagosAtencion ?>", '_blank');
    //         $('#md_examenesAtencion .modal-content').load("<?= $urlModal ?>");
    //         $('#md_examenesAtencion').on('hidden.bs.modal', function() {
    //           location.reload()
    //         });
    //       } else {
    //         error(data.mensaje);
    //       }
    //     }, 'json');
    //   }
    // });

    // $('.btn-anularBonos').on('click', function() {
    //   if (confirm('¿Desea anular los bonos generados en I-MED? Esto también eliminará los pagos asociados a los bonos')) {
    //     $.post('soap.php', {
    //       anularBonos: 1,
    //       id_atencion: "<?= $idate ?>",
    //       cod_financiador_imed: "<?= $codFinanciadorImedEmpresa ?>",
    //       id_centro_contacto: $('#id_centro_contacto_anular option:selected').val()
    //     }, function(data) {
    //       if (data.exito) {
    //         exito(data.mensaje);
    //         window.open("<?= $urlPagosAtencion ?>", '_blank');
    //         $('#md_examenesAtencion .modal-content').load("<?= $urlModal ?>");
    //         $('#md_examenesAtencion').on('hidden.bs.modal', function() {
    //           location.reload()
    //         });
    //       } else {
    //         error(data.mensaje);
    //       }
    //     }, 'json');
    //   }
    // });

    // $('.btn-reloadModal').on('click', function() {
    //   $('#md_examenesAtencion .modal-content').load("<?= $urlModal ?>");
    //   $('#md_examenesAtencion').on('hidden.bs.modal', function() {
    //     location.reload()
    //   });
    // });
    /////////////////////////////////////////// I-MED ////////////////////////////////////////////////////////////////
    /////////////////////////////////////////// I-MED ////////////////////////////////////////////////////////////////
    /////////////////////////////////////////// I-MED ////////////////////////////////////////////////////////////////
  });
</script>