<?php
define('PERMITIDO', true);
require('../lib/valido.php');
require_once('../lib/util.php');
require_once("../lib/func.global.php");
require_once('../lib/connection.php');
require_once("../lib/config.php");


?>
 <div class="modal-header">
     <button type="button" class="close" data-dismiss="modal" aria-hidden="true">
         &times;
     </button>
     <h4 class="modal-title" id="myModalLabel">Recuperar contraseña</h4>
 </div>


<div class="modal-body">
    <form action="recuperar.php" name="formRecuperar" id="formRecuperar" method="post" class="smart-form">
        <fieldset style="padding-top: 0px;">
             <div class="row">
                 <section class="col col-4">
                     <label class="label">
                         Ingrese su Correo Electrónico
                     </label>
                </section>
                <section class="col col-8">
                     <label class="input">
                         <input type="text" name="mail" class="input-sm"/>
                     </label>
                 </section>
             </div>
             <div class="row">
                 <section class="col col-4">
                     <label class="label">
                         Ingrese su Rut
                     </label>
                </section>
                <section class="col col-8">
                     <label class="input">
                         <input type="text" name="rut" class="input-sm"/>
                     </label>
                     <div class="note" style="margin:0">
                         Sin puntos ni guión
                     </div>
                 </section>
             </div>
        </fieldset>
        <input type="hidden" name="recuperarPass" value="1">
    </form>
</div>
<div class="modal-footer">
    <a id="enviar" class="btn btn-success btn-sm pull-right">
        <i class="fa fa-hand-o-right"></i> Solicitar
    </a>
</div>

 <?php
 	#include("../inc/scripts.php");
 ?>
 <script>
     $(document).ready(function(e) {
         $('#enviar').on('click',function(){
             $("#formRecuperar").submit();
         })

         $("#formRecuperar").validate({
             rules : {
                 mail : {
                     required : true,
                     email: true
                 },
                 rut : {
                     required : true,
                     number: true
                 }

             },
             messages : {
                 mail : {
                     required : 'Debe asignar un email válido',
                     email: 'Ingrese un eMail valido'
                 },
                 rut : {
                     required : 'Ingrese su rut',
                     number: 'Rut sin puntos ni guión'
                 }
             },
             onfocusout: false,
             onsubmit: true,
             // Do not change code below
             errorPlacement : function(error, element) {
                 error.insertAfter(element.parent());
             }
         });

         $('#formRecuperar').on('submit', function(e){
             var form = $("#formRecuperar");
             if(form.valid()){
                 $.post(form.attr('action'), form.serialize(), function(data){
                     if(data.exito){
                         alert(data.mensaje);
                         location.reload();
                     }else{
                         alert(data.mensaje);
                         //error(data.mensaje);
                     }
                 }, 'json');
             }
             e.preventDefault();
             return false;
         });
     });
 </script>
