<?php
define('PERMITIDO', true);
$pagina = 28;
require_once("../inc/init.php");
require('../lib/valido.php');
require_once('../lib/util.php');
require_once("../lib/func.global.php");
require_once('../lib/connection.php');
require_once("../lib/config.php");

error_reporting(E_ALL);
ini_set('display_errors', TRUE);
ini_set('display_startup_errors', TRUE);

if (PHP_SAPI == 'cli') die('This file should only be run from a Web Browser');

function httpGet($url) {
  $ch = curl_init();

  curl_setopt($ch, CURLOPT_URL, $url);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  //  curl_setopt($ch,CURLOPT_HEADER, false); 

  $output = curl_exec($ch);
  curl_close($ch);
  return $output;
}

$id_conv = isset($_GET['id_conv']) ? $_GET['id_conv'] : -1;
$f_de = (isset($_GET['f_de']) && $_GET['f_de'] != "") ? $_GET['f_de'] : date('Y-m-d', strtotime('-1 week'));
$f_ha = (isset($_GET['f_ha']) && $_GET['f_ha'] != "") ? $_GET['f_ha'] : date('Y-m-d');
$filtro = (isset($_GET['idcc']) && $_GET['idcc'] != "") ? " AND a.ID_CENTRO_CONTACTO  = {$_GET['idcc']}" : "";

$files = [];
$qInformes = $mysqli->prepare("SELECT aa.URL, aa.id_atencion, aa.FLAG_HISTORICO 
FROM atenciones a
INNER JOIN archivos_atenciones aa ON aa.ID_ATENCION = a.ID_ATENCION AND aa.ID_ARCHIVO = (SELECT MAX(z.ID_ARCHIVO) FROM archivos_atenciones z WHERE z.ID_ATENCION = a.ID_ATENCION AND z.TIPO = 'INFORME')
INNER JOIN empresas conv ON a.ID_CONVENIO = conv.ID_EMPRESA AND conv.ID_EMPRESA = ?
WHERE (a.FECHA BETWEEN ? AND ?) AND FECHA_R IS NOT NULL AND a.FLAG_ELIMINADO = 0 $filtro
ORDER BY ID_ATENCION DESC");
$qInformes->bind_param("iss", $id_conv, $f_de, $f_ha);
$qInformes->execute();
$qInformes->bind_result($urlInforme, $idAtencion, $flagHistorico);
$qInformes->store_result();
while ($qInformes->fetch()) {
  $files[$idAtencion] = $flagHistorico == 1 ? $urlArchivosHistoricos . $urlInforme : $urlArchivos . $urlInforme;
}
$qInformes->close();

if (count($files) > 1000) {
  echo "La cantidad de archivos es muy grande(superior a 1000), intente con un periodo de tiempo mas pequeño";
  exit();
}

// $files = array(
//   'https://www.google.com/images/logo.png'
// );

# create new zip object
$zip = new ZipArchive();

# create a temp file & open it
$tmp_file = tempnam('.', '');
$zip->open($tmp_file, ZipArchive::CREATE);

# loop through each file
foreach ($files as $file) {
  # download file
  $download_file = httpGet($file);

  #add it to the zip
  $zip->addFromString(basename($file), $download_file);
}

# close zip
$zip->close();
$f_de = join("-", array_reverse(explode("-", $f_de)));
$f_ha = join("-", array_reverse(explode("-", $f_ha)));
# send the file to the browser as a download
header("Content-disposition: attachment; filename=Informes de resultado $f_de a $f_ha.zip");
header('Content-type: application/zip');
readfile($tmp_file);
unlink($tmp_file);
exit();
