<?php

error_reporting(E_ALL);
ini_set("display_errors", 1);
require_once('../lib/valido.php');
require_once('../lib/util.php');
require_once("../lib/func.global.php");
require_once('../lib/connection.php');
require_once("../lib/config.php");
require_once("../lib/variables_entorno/variables_entorno.php");
require_once('../lib/datos_pantallas.php');

//initialize the session
if (!isset($_SESSION)) session_start();
$ruta_logout = logout();
define('LOGOUT', $ruta_logout);

if (!defined('LOGIN') ) {
    if (isset($_SESSION['MM_Username'])) {
		if (isset($pantalla_actual) && isset($datos_pantallas[$pantalla_actual]['code'])) $pagina = $datos_pantallas[$pantalla_actual]['code'];
        if (!isAuthorized($_SESSION['MM_Username'], $pagina)) error401();
    } else {
        header('Location: ../home/login.php');
    }

    $usuario = isset($_SESSION['MM_Username']) ? $_SESSION['MM_Username'] : "-1";
    $userQuery = $mysqli->prepare("SELECT ID_USUARIO, u.PERFIL, u.USUARIO, CONCAT_WS('-', u.NRO_RUT, u.DV_RUT), ID_CENTRO_COSTOS, FLAG_DIALISIS,
    CONCAT_WS(' ', u.NOMBRES, u.APELLIDO_PATERNO, left(IFNULL(u.APELLIDO_MATERNO,''), 1)), cc.NOMBRE
    FROM usuarios u
    LEFT JOIN centros_contacto cc ON u.ID_CENTRO_COSTOS = cc.ID_CENTRO_CONTACTO
    WHERE USUARIO = ?
    LIMIT 1");
    $userQuery->bind_param('s', $usuario);
    $userQuery->execute();
    $userQuery->bind_result($usuario_id, $usuario_perfil, $usuario_name, $usuario_rut, $usuario_centro, $usuario_centro_flag_dialisis,
    $usuario_nombre, $usuario_centroContacto);
    $userQuery->fetch();
    $userQuery->close();

    $qUrlSitioWebComercial = $mysqli->prepare("SELECT VALOR FROM parametros_sistema WHERE DESCRIPCION_PS = 'URL SITIO WEB' LIMIT 1");
    # $userQuery->bind_param('s', $usuario);
    $qUrlSitioWebComercial->execute();
    $qUrlSitioWebComercial->bind_result($cliente_urlSitioWebComercial);
    $qUrlSitioWebComercial->fetch();
    $qUrlSitioWebComercial->close();

    # este row_user se usa en algunas páginas pero es innecesario, deberian usarse las variables de la consulta de arriba
    $row_user = [
        'id_usuario' => $usuario_id, 
        'usuario' => $usuario_name, 
        'perfil' => $usuario_perfil, 
        'nombre' => $usuario_nombre, 
        'centro'=> $usuario_centro, 
        'flag_dialisis'=> $usuario_centro_flag_dialisis
    ];

    $qTipoSistema=$mysqli->prepare("SELECT NOMBRE, TIPO, URL, N_USERS FROM parametros WHERE ID_PARAMETRO = 1");
    $qTipoSistema->execute();
    $qTipoSistema->bind_result($ps_nombreLab, $ps_tipoSistema, $ps_url, $ps_nUsers);
    $qTipoSistema->fetch();
    $qTipoSistema->close();
} else {
    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        if (array_key_exists('userName', $_POST)) {
            login($_POST['userName'], $_POST['password']);
        }
    }
}

date_default_timezone_set("America/Santiago");
$hoy = new DateTime('now');

?>
