<?php
define('PERMITIDO', true);

$pagina = 34;

require_once '../lib/valido.php';
require_once '../lib/util.php';
require_once '../lib/func.global.php';
require_once '../lib/connection.php';
require_once '../lib/config.php';
require_once '../assets/php/PHPExcel.php';

error_reporting(E_ALL);
ini_set('display_errors', true);
ini_set('display_startup_errors', true);

if (PHP_SAPI == 'cli') die('This file should only be run from a Web Browser');

$objPHPExcel = new PHPExcel();
$objPHPExcel->getProperties()->setCreator('RIPIT')->setTitle('Reporte');

$fi = date('Y-m-d', strtotime('-1 week'));
if (isset($_GET['f_inicio'])) $fi = $_GET['f_inicio'];

$ft = date('Y-m-d');
if (isset($_GET['f_termino'])) $ft = $_GET['f_termino'];

$filtro = "";
if (isset($_GET['cod_examen_critico']) && $_GET['cod_examen_critico'] != "") $filtro = " AND ea.COD_EXAMEN = '{$_GET['cod_examen_critico']}'";
else                                                                         $filtro = " AND (e.FLAG_CRITICO = 1)";

$sql_atenciones_criticas = "SELECT a.ID_ATENCION, a.FECHA, p.APELLIDO_PATERNO, p.APELLIDO_MATERNO, p.NOMBRES, p.NRO_RUT, p.DV_RUT, cc.NOMBRE, ea.RESULTADO, ea.COD_EXAMEN, IFNULL(e.NOMBRE_INF, e.NOMBRE),
IFNULL(rv.RC_MIN, 'NO APLICA'), IFNULL(rv.RR_MIN, 'NO APLICA'), IFNULL(rv.RR_MAX, 'NO APLICA'), IFNULL(rv.RC_MAX, 'NO APLICA')
FROM atenciones a
INNER JOIN examenes_atenciones ea ON ea.ID_ATENCION = a.ID_ATENCION
INNER JOIN examenes e ON e.COD_INTERNO = ea.COD_EXAMEN
INNER JOIN personas p ON p.ID_PERSONA = a.ID_CLIENTE
LEFT JOIN centros_contacto cc ON cc.ID_CENTRO_CONTACTO = a.ID_CENTRO_CONTACTO
LEFT JOIN rangos_variables rv ON rv.COD_INTERNO = ea.COD_EXAMEN AND rv.GENERO = p.GENERO AND TIMESTAMPDIFF(MONTH, p.FECHA_NACIMIENTO, NOW()) BETWEEN rv.EDAD_MIN AND rv.EDAD_MAX
WHERE a.FECHA BETWEEN ? AND ?
AND a.FLAG_ELIMINADO = 0 AND ea.FECHA_VAL IS NOT NULL $filtro";
$resultado_atenciones_criticas = $mysqli->prepare($sql_atenciones_criticas);
$resultado_atenciones_criticas->bind_param('ss', $fi, $ft);
$resultado_atenciones_criticas->execute();
$resultado_atenciones_criticas->bind_result($at_id, $at_fecha, $at_apellido_p, $at_apellido_m, $at_nombres, $at_nro_rut, $at_dv_rut, $at_local, $at_resultado, $at_cod_examen, $at_examen,
$at_rc_min, $at_rr_min, $at_rr_max, $at_rc_max);
$resultado_atenciones_criticas->store_result();

$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);

$objPHPExcel->setActiveSheetIndex(0)
	->setCellValue('A1', 'NRO. ATENCIÓN')
	->setCellValue('B1', 'FECHA')
	->setCellValue('C1', 'PACIENTE')
	->setCellValue('D1', 'RUT')
	->setCellValue('E1', 'PROCEDENCIA')
	->setCellValue('F1', 'RESULTADO')
	->setCellValue('G1', 'RANGO CRÍTICO')
	->setCellValue('H1', 'CÓDIGO EXAMEN')
	->setCellValue('I1', 'EXAMEN')
	->setCellValue('J1', 'A/R');

$f = 2;
while ($resultado_atenciones_criticas->fetch()) {
	$fch = explode('-', $at_fecha);
	$fch = $fch[2] . '-' . $fch[1] . '-' . $fch[0];

  if ($at_rc_min == "NO APLICA") {
    $a_r = "NO APLICA";
    $rango_critico = "NO APLICA";
  } else {
    $a_r = ($at_resultado < $at_rc_min || $at_resultado > $at_rc_max) ? 'R' : 'A';
    $rango_critico = "<$at_rc_min | >$at_rc_max";
  }

	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('A' . $f, $at_id);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('B' . $f, $fch);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('C' . $f, "{$at_nombres} {$at_apellido_p} {$at_apellido_m}");
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('D' . $f, number_format($at_nro_rut, 0, ',', '.') . '-' . strtoupper($at_dv_rut));
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('E' . $f, $at_local);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('F' . $f, $at_resultado);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('G' . $f, $rango_critico);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('H' . $f, $at_cod_examen);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('I' . $f, $at_examen);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('J' . $f, $a_r);
	$f++;
}
$resultado_atenciones_criticas->close();

$objPHPExcel->getActiveSheet()->setTitle('Reporte');
$objPHPExcel->setActiveSheetIndex(0);

header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="xls_criticos.xls"');
header('Cache-Control: max-age=0');

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter->save('php://output');

die();
?>
