<?php
define('PERMITIDO', true);

$pagina = 34;

require_once '../lib/valido.php';
require_once '../lib/util.php';
require_once '../lib/func.global.php';
require_once '../lib/connection.php';
require_once '../lib/config.php';
require_once '../assets/php/PHPExcel.php';

error_reporting(E_ALL);
ini_set('display_errors', true);
ini_set('display_startup_errors', true);

if (PHP_SAPI == 'cli')
	die('This file should only be run from a Web Browser');

$objPHPExcel = new PHPExcel();
$objPHPExcel->getProperties()->setCreator('RIPIT')->setTitle('Reporte');

$fi = date('Y-m-d', strtotime('-1 week'));
if (isset($_GET['f_inicio'])) {
	$fi = $_GET['f_inicio'];
}

$ft = date('Y-m-d');
if (isset($_GET['f_termino'])) {
	$ft = $_GET['f_termino'];
}

$f_tipo_tubo = "";
if (isset($_GET['cod_tipo_tubo']) && $_GET['cod_tipo_tubo'] != '') {
	$f_tipo_tubo = " AND ea.TIPO_TUBO = {$_GET['cod_tipo_tubo']}";
}

$sql_atenciones_rechazadas = "SELECT a.ID_ATENCION, a.FECHA, p.APELLIDO_PATERNO, p.APELLIDO_MATERNO, p.NOMBRES, p.NRO_RUT, p.DV_RUT, cc.NOMBRE, cg.DESCRIPCION_CG, rt.OBS_RECHAZO, cg_2.DESCRIPCION_CG 
FROM atenciones a
JOIN examenes_atenciones ea ON ea.ID_ATENCION = a.ID_ATENCION
LEFT JOIN rechazos_tubos rt ON rt.TUBO_RECHAZO = ea.TIPO_TUBO AND rt.ID_ATENCION = a.ID_ATENCION
LEFT JOIN codigos_generales cg ON rt.MOTIVO_RECHAZO = cg.CODIGO AND cg.COD_TABLA = 'SIS_MOTREC'
LEFT JOIN codigos_generales cg_2 ON rt.TUBO_RECHAZO = cg_2.CODIGO AND cg_2.COD_TABLA = 'SIS_TIPTUB'
JOIN personas p ON p.ID_PERSONA = a.ID_CLIENTE
JOIN centros_contacto cc ON cc.ID_CENTRO_CONTACTO = a.ID_CENTRO_CONTACTO
WHERE a.FECHA BETWEEN ? AND ?
AND a.FLAG_ELIMINADO = 0 $f_tipo_tubo
GROUP BY a.ID_ATENCION, rt.TUBO_RECHAZO
ORDER BY a.ID_ATENCION ASC, rt.ID_RECHAZO_TUBO DESC";
$resultado_atenciones_rechazadas = $mysqli->prepare($sql_atenciones_rechazadas);
$resultado_atenciones_rechazadas->bind_param('ss', $fi, $ft);

$resultado_atenciones_rechazadas->execute();
$resultado_atenciones_rechazadas->bind_result($at_id, $at_fecha, $at_apellido_p, $at_apellido_m, $at_nombres, $at_nro_rut, $at_dv_rut, $at_local, $at_motivo_rechazo, $at_obs_rechazo, $at_tubo_rechazo);
$resultado_atenciones_rechazadas->store_result();

$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);

$objPHPExcel->setActiveSheetIndex(0)
	->setCellValue('A1', 'NRO. ATENCIÓN')
	->setCellValue('B1', 'FECHA')
	->setCellValue('C1', 'PACIENTE')
	->setCellValue('D1', 'RUT')
	->setCellValue('E1', 'PROCEDENCIA')
	->setCellValue('F1', 'MOTIVO RECHAZO')
	->setCellValue('G1', 'OBS. RECHAZO')
	->setCellValue('H1', 'TIPO TUBO');

$f = 2; $idat="";
while ($resultado_atenciones_rechazadas->fetch()) {
	if($idat!=$at_id){//este if para poder saltar la linea que se repite cuando hay un null y uno no null
		$idat=$at_id;
	}elseif($at_tubo_rechazo==''){
		continue;
	}
	$fch = explode('-', $at_fecha);
	$fch = $fch[2] . '-' . $fch[1] . '-' . $fch[0];

	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('A' . $f, $at_id);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('B' . $f, $fch);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('C' . $f, "{$at_nombres} {$at_apellido_p} {$at_apellido_m}");
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('D' . $f, number_format($at_nro_rut, 0, ',', '.') . '-' . strtoupper($at_dv_rut));
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('E' . $f, $at_local);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('F' . $f, $at_motivo_rechazo);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('G' . $f, $at_obs_rechazo);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('H' . $f, $at_tubo_rechazo);
	$f++;
}
$resultado_atenciones_rechazadas->close();

$objPHPExcel->getActiveSheet()->setTitle('Reporte');
$objPHPExcel->setActiveSheetIndex(0);

header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="xls_rechazos.xls"');
header('Cache-Control: max-age=0');

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter->save('php://output');

die();
?>