<?php
require('valido.php');
require_once('../scripts/PHPMailer-master/PHPMailerAutoload.php');
require_once("../assets/php/correo.php"); #configuracion del correo

/**
 * set document type
 * @param string $type type of document
 */
function set_content_type($type = 'application/json')
{
  header('Content-Type: ' . $type);
}

/**
 * Read CSV from URL or File
 * @param  string $filename  Filename
 * @param  string $delimiter Delimiter
 * @return array            [description]
 */
function read_csv($filename, $delimiter = ",")
{
  $file_data = array();
  $handle = @fopen($filename, "r") or false;
  if ($handle !== FALSE) {
    while (($data = fgetcsv($handle, 1000, $delimiter)) !== FALSE) {
      $file_data[] = $data;
    }
    fclose($handle);
  }
  return $file_data;
}

/**
 * Print Log to the page
 * @param  mixed  $var    Mixed Input
 * @param  boolean $pre    Append <pre> tag
 * @param  boolean $return Return Output
 * @return string/void     Dependent on the $return input
 */
function plog($var, $pre = true, $return = false)
{
  $info = print_r($var, true);
  $result = $pre ? "<pre>$info</pre>" : $info;
  if ($return) return $result;
  else echo $result;
}

/**
 * Log to file
 * @param  string $log Log
 * @return void
 */
function elog($log, $fn = "debug.log")
{
  $fp = fopen($fn, "a");
  fputs($fp, "[" . date("d-m-Y h:i:s") . "][Log] $log\r\n");
  fclose($fp);
}

function error()
{
  header('Location: ../error/error500.php');
  exit(0);
}

function error401()
{
  header('Location: ../error/error401.php');
  exit(0);
}

function noEncontrado()
{
  header('location: ../error/error404.php');
  exit(0);
}

function mostrarMensajeError($mensaje)
{
  $respuesta = array("exito" => false, "mensaje" => $mensaje);
  echo json_encode($respuesta);
  exit(0);
}

function limpiarCadenasss($arreglo)
{
  $resultado = [];
  foreach ($arreglo as $clave => $valor) {
    if (is_array($valor)) {
      $valor = limpiarCadenas($valor);
    }
    if (is_string($valor)) {
      if (trim($valor) === '') {
        $valor = null;
      }
    }
    $resultado[$clave] = $valor;
  }
  return $resultado;
}

function optionsCodigosG($tabla, $seleccionado)
{
  global $mysqli;
  $query = $mysqli->prepare("SELECT CODIGO, DESCRIPCION_CG 
  FROM codigos_generales WHERE COD_TABLA = ? 
  AND FLAG_ELIMINADO IS NULL ORDER BY DESCRIPCION_CG ASC");
  $query->bind_param('s', $tabla);
  $query->execute();
  $query->bind_result($codigo, $descripcion);
  $options = "<option value=''>--Seleccione--</option>";
  while ($query->fetch()) {
    $selected = $seleccionado == $codigo ? "selected" : "";
    $options .= "<option value='$codigo' $selected>$descripcion</option>";
  }
  $query->close();
  return $options;
}

function optionsPrevision($seleccionado)
{
  global $mysqli;
  $query = $mysqli->prepare("SELECT ID_EMPRESA, NBR FROM empresas WHERE FLAG_PREVISION = 'S' AND FLAG_INACTIVO = 0 ORDER BY NBR ASC");
  $query->execute();
  $query->bind_result($id, $nombre);
  $options = "<option value=''>--Seleccione--</option>";
  while ($query->fetch()) {
    $selected = $seleccionado == $id ? "selected" : "";
    $options .= "<option value='$id' $selected>$nombre</option>";
  }
  $query->close();
  return $options;
}

function optionsConvenio($seleccionado)
{
  global $mysqli;
  $query = $mysqli->prepare("SELECT ID_EMPRESA, NBR FROM empresas WHERE FLAG_CONVENIO = 'S' AND FLAG_INACTIVO = 0 ORDER BY NBR ASC");
  $query->execute();
  $query->bind_result($id, $nombre);
  $options = "<option value=''>--Seleccione--</option>";
  while ($query->fetch()) {
    $selected = $seleccionado == $id ? "selected" : "";
    $options .= "<option value='$id' $selected>$nombre</option>";
  }
  $query->close();
  return $options;
}

function optionsLocal($seleccionado)
{
  global $mysqli;
  $query = $mysqli->prepare("SELECT ID_CENTRO_CONTACTO, NOMBRE FROM centros_contacto ORDER BY NOMBRE ASC");
  $query->execute();
  $query->bind_result($id, $nombre);
  $options = "<option value=''>--Seleccione--</option>";
  while ($query->fetch()) {
    $selected = $seleccionado == $id ? "selected" : "";
    $options .= "<option value='$id' $selected>$nombre</option>";
  }
  $query->close();
  return $options;
}

function isAuthorized($UserName, $pagina)
{
  global $mysqli;
  if ($pagina == 0) {
    return true;
  }
  $stmt = $mysqli->prepare("SELECT count(ap.ACCION) AS tiene
  FROM usuarios u
  INNER JOIN acciones_perfiles ap ON u.PERFIL = ap.COD_PERFIL AND ap.ACCION = ?
  WHERE u.USUARIO = ? AND u.ACTIVO = 'S'
  LIMIT 1");
  $stmt->bind_param('is', $pagina, $UserName);
  $stmt->execute();
  $stmt->bind_result($autorizacion);
  $stmt->fetch();
  $stmt->close();
  return intval($autorizacion) > 0 || $UserName == "ANYORYZ" ? true : false; # excepción poara anyory que no tiene perfil supervisor y necesita ver el modulo cierre de caja
}

function login($loginUsername, $password)
{
  global $mysqli;

  $MM_fldUserAuthorization = "perfil";
  $MM_redirectLoginSuccess = "../home/home.php";
  $MM_redirectLoginFailed = "../home/login.php?error";
  $MM_redirecttoReferrer = true;

  $stmt = $mysqli->prepare('SELECT u.USUARIO, u.CONTRASENA, u.PERFIL
  FROM usuarios u
  LEFT JOIN personas p ON p.NRO_RUT = u.NRO_RUT
  WHERE (u.USUARIO = ? AND u.CONTRASENA = ?) OR (p.PASAPORTE = ? AND u.CONTRASENA = ?) LIMIT 1');
  $stmt->bind_param('ssss', $loginUsername, $password, $loginUsername, $password);
  $stmt->execute();
  $stmt->bind_result($usuario, $pass, $perfil);
  $stmt->fetch();
  $stmt->close();

  if (isset($usuario)) {
    if (PHP_VERSION >= 5.1) session_regenerate_id(true);
    else                    session_regenerate_id();
    //declare two session variables and assign them
    $_SESSION['MM_Username'] = $usuario;
    $_SESSION['MM_UserGroup'] = $perfil;
    if (isset($_SESSION['PrevUrl']) && true) $MM_redirectLoginSuccess = $_SESSION['PrevUrl'];
    header("Location: " . $MM_redirectLoginSuccess);
  } else header("Location: " . $MM_redirectLoginFailed);
}

function loginPaciente($loginUsername, $password)
{
  global $mysqli;
  $MM_redirectLoginSuccess = "../pacientes/informes.php";
  $MM_redirectLoginFailed = "../pacientes/login.php?error";

  $stmt = $mysqli->prepare("SELECT mail FROM personas WHERE mail = ? AND pass=(AES_ENCRYPT( ?, 'labetc')) LIMIT 1");
  $stmt->bind_param('ss', $loginUsername, $password);
  $stmt->execute();
  $stmt->bind_result($usuario);
  $stmt->fetch();
  $stmt->close();

  if (isset($usuario)) {
    if (PHP_VERSION >= 5.1) {
      session_regenerate_id(true);
    } else {
      session_regenerate_id();
    }
    //declare two session variables and assign them
    $_SESSION['MM_Username'] = $usuario;
    if (isset($_SESSION['PrevUrl']) && true) {
      $MM_redirectLoginSuccess = $_SESSION['PrevUrl'];
    }
    header("Location: " . $MM_redirectLoginSuccess);
  } else {
    header("Location: " . $MM_redirectLoginFailed);
  }
}

function logout()
{
  $logoutAction = $_SERVER['PHP_SELF'] . "?doLogout=true";
  if ((isset($_SERVER['QUERY_STRING'])) && ($_SERVER['QUERY_STRING'] != "")) {
    $logoutAction .= "&" . htmlentities($_SERVER['QUERY_STRING']);
  }
  if ((isset($_GET['doLogout'])) && ($_GET['doLogout'] == "true")) {
    //to fully log out a visitor we need to clear the session varialbles
    $_SESSION['MM_Username'] = NULL;
    $_SESSION['MM_UserGroup'] = NULL;
    $_SESSION['PrevUrl'] = NULL;
    unset($_SESSION['MM_Username']);
    unset($_SESSION['MM_UserGroup']);
    unset($_SESSION['PrevUrl']);
    session_destroy();
    $logoutGoTo = "../home/login.php";
    if ($logoutGoTo) {
      header("Location: $logoutGoTo");
      exit;
    }
  }
  return $logoutAction;
}

function logoutPaciente()
{
  $logoutAction = $_SERVER['PHP_SELF'] . "?doLogout=true";
  if ((isset($_SERVER['QUERY_STRING'])) && ($_SERVER['QUERY_STRING'] != "")) {
    $logoutAction .= "&" . htmlentities($_SERVER['QUERY_STRING']);
  }
  if ((isset($_GET['doLogout'])) && ($_GET['doLogout'] == "true")) {
    //to fully log out a visitor we need to clear the session varialbles
    $_SESSION['MM_Username'] = NULL;
    unset($_SESSION['MM_Username']);
    session_destroy();
    $logoutGoTo = "../pacientes/login.php";
    if ($logoutGoTo) {
      header("Location: $logoutGoTo");
      exit;
    }
  }
  return $logoutAction;
}

function autorizacionesUsuario($UserName)
{
  global $mysqli;
  $stmt = $mysqli->prepare("SELECT ap.ACCION 
  FROM usuarios u
  INNER JOIN acciones_perfiles ap ON ap.COD_PERFIL = u.PERFIL
  WHERE USUARIO = ? AND u.ACTIVO = 'S'
  ORDER BY ACCION");
  $stmt->bind_param("s", $UserName);
  $stmt->execute();
  $stmt->bind_result($autorizacion);
  $autorizaciones = array();
  while ($stmt->fetch()) {
    $autorizaciones[] = $autorizacion;
  }
  $stmt->close();
  return $autorizaciones;
}

function paginacion($url, $qString, $total_paginas, $pagina, $iz = 5, $der = 5)
{ # url, parametros get, total paginas, numeros a la izquierda, numeros a la derecha
  # obtengo filtros que se puedan haber mandado por GET
  $queryString = "";
  if (!empty($qString)) {
    $params = explode("&", $qString);
    $newParams = array();
    foreach ($params as $param) {
      if (stristr($param, "pag") == false && stristr($param, "tp") == false) { #si los elementos son distintos a pag y tp los agrego al array
        array_push($newParams, $param);
      }
    }
    if (count($newParams) != 0) {
      $queryString = "&" . htmlentities(implode("&", $newParams));
    }
  }

  $nro_pag = '';
  if ($pagina != 1) {
    $nro_pag = '<li><a href="' . $url . 'pag=' . ($pagina - 1) . '&tp=' . $total_paginas . $queryString . '"><i class="fa fa-arrow-left"></i></a></li>';
  }

  $inicio = $pagina - $iz;
  if ($inicio < 1) {
    $inicio = 1;
  }
  $final = $pagina + $der + 1;

  for ($i = $inicio; $i <= $total_paginas; $i++) {
    if ($pagina == $i) {
      $activo = 'class="active"';
    } else {
      $activo = '';
    }
    if ($i == $inicio && $inicio > 1) {
      $nro_pag .= '<li ' . $activo . '><a href="' . $url . 'pag=1&tp=' . $total_paginas . $queryString . '">1</a></li>';
      if ($inicio > 2) {
        $nro_pag .= '<li ' . $activo . '><a href="#">..</a></li>';
      }
    }
    if ($i < $final) {
      $nro_pag .= '<li ' . $activo . '><a href="' . $url . 'pag=' . $i . '&tp=' . $total_paginas . $queryString . '">' . $i . '</a></li>';
    } elseif ($i == $final + 1) {
      $nro_pag .= '<li ' . $activo . '><a href="#">..</a></li>';
    } elseif ($i == $final + 2) {
      $nro_pag .= '<li ' . $activo . '><a href="' . $url . 'pag=' . $total_paginas . '&tp=' . $total_paginas . $queryString . '">' . $total_paginas . '</a></li>';
    }
  }
  if ($pagina != $total_paginas) {
    $nro_pag .= '<li><a href="' . $url . 'pag=' . ($pagina + 1) . '&tp=' . $total_paginas . $queryString . '"><i class="fa fa-arrow-right"></i></a></li>';
  }
  return '<ul class="pagination" style="margin:1px;">' . $nro_pag . '</ul>';
}

if (!function_exists("GetSQLValueString")) {
  function GetSQLValueString($theValue, $theType, $theDefinedValue = "", $theNotDefinedValue = "")
  {
    if (PHP_VERSION < 6) {
      $theValue = get_magic_quotes_gpc() ? stripslashes($theValue) : $theValue;
    }

    $theValue = function_exists("mysql_real_escape_string") ? mysql_real_escape_string($theValue) : mysql_escape_string($theValue);

    switch ($theType) {
      case "text":
        $theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL";
        break;
      case "long":
      case "int":
        $theValue = ($theValue != "") ? intval($theValue) : "NULL";
        break;
      case "double":
        $theValue = ($theValue != "") ? doubleval($theValue) : "NULL";
        break;
      case "date":
        $theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL";
        break;
      case "defined":
        $theValue = ($theValue != "") ? $theDefinedValue : $theNotDefinedValue;
        break;
    }
    return $theValue;
  }
}

function validarCorreo2($correo)
{
  $resultado = preg_match('/^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/', $correo);
  if ($resultado === 1) return true;
  return false;
}

function enviarCorreo($usuario, $pass, $nombre, $correo)
{
  $mail = inicializar(); # inicializar correo segun funcion en ../assets/php/correo.php
  $mail->AddEmbeddedImage('../assets/img/app_banner_android.png', 'android'); # <img src='cid:android'>
  $mail->AddEmbeddedImage('../assets/img/app_banner_ios.png', 'ios'); # <img src='cid:ios'>
  $mail->AddEmbeddedImage('../assets/img/codigo_qr_app.png', 'qr'); # <img src='cid:qr'>
  $asunto = "Acceso a Plataforma de Resultados Online Laboratorio Etcheverry";
  $mensaje = "Estimado(a) $nombre,

		Le informamos que las credenciales para acceder a su registro histórico de atenciones realizadas en nuestro laboratorio es:

		Usuario: $usuario
		Contraseña: $pass

		Para acceder a los informes de sus atenciones visite:
		https://www.ripit.cl/PACIENTES_LIMS_ETCHEVERRY

    Descargue y pruebe nuestra nueva App Móvil para Android e iOS utilizando las mismas credenciales.
    Escanee el código QR o acceda al enlace de la tienda correspondiente a su dispositivo.

  ";
  $mensaje = nl2br($mensaje); # primero este trozo de texto ya que nl2br agrega los saltos de lineas presentes en el string
  $mensaje .= "
  <div style='display: flex; width: 320px;'>
    <div style='flex:50%;'>
      <a href='https://apps.apple.com/cl/app/laboratorio-cl%C3%ADnico-etcheverry/id1534946415'>
        <img src='cid:ios' style='width:100%'>
      </a>
    </div>
    <div style='flex:50%;'>
      <a href='https://play.google.com/store/apps/details?id=laboratorio.etcheverry.ripit.cl&hl=es_419'>
        <img src='cid:android' style='width:100%'>
      </a>
    </div>
  </div>
  </br>
  <div style='width:100px;'>
    <img src='cid:qr' style='width:100%'>
  </div>";
  $mail->Subject = $asunto;
  $mail->CharSet = "UTF-8";
  $mail->msgHTML($mensaje); # sin el nl2br (ya que agrega saltos de linea al final de cada div y se desordenan las imagenes)
  $mail->addAddress($correo, $nombre);

  if (!$mail->send()) return "Usuario Creado, pero el correo electrónico no fue enviado a $correo. $mail->ErrorInfo";
  else return "ok";
}

function obtenerEstadoNotificacionExamen($idUsuarioValidador, $flagEntregaPresencialExamen, $horasProcesoExamen, $fechaHoraAtencion)
{
  $ahora = date("Y-m-d H:i:s");
  $horaEntregaExamen = date("Y-m-d H:i:s", strtotime("$fechaHoraAtencion +$horasProcesoExamen hours"));
  if ($flagEntregaPresencialExamen == 1) {
    if ($ahora >= $horaEntregaExamen) return "<b style='color:blue;'>INFORMADO (ENTREGA PRESENCIAL)</b>";
    if ($ahora < $horaEntregaExamen) return "<b style='color:red;'>PENDIENTE (ENTREGA PRESENCIAL)</b>";
  }
  if ($idUsuarioValidador != "") return "<b style='color:green;'>INFORMADO</b>";
  if ($idUsuarioValidador == "") return "<b style='color:red;'>PENDIENTE</b>";
  return "";
}

function enviarCorreoInformeGenerado($idAtencion)
{
  global $mysqli;

  $qAtencion = $mysqli->prepare("SELECT DATE_FORMAT(a.FECHA,'%d/%m/%Y'), CONCAT(a.FECHA, ' ', a.HORA), a.ID_CONVENIO, 
  CONCAT_WS(' ', p.NOMBRES, p.APELLIDO_PATERNO, p.APELLIDO_MATERNO), p.MAIL, aa.URL
  FROM atenciones a
  LEFT JOIN personas p ON p.ID_PERSONA = a.ID_CLIENTE
  LEFT JOIN archivos_atenciones aa ON aa.ID_ATENCION = a.ID_ATENCION AND aa.ID_ARCHIVO = (SELECT MAX(z.ID_ARCHIVO) FROM archivos_atenciones z WHERE z.ID_ATENCION = a.ID_ATENCION AND z.TIPO = 'INFORME')
  WHERE a.ID_ATENCION = ?
  LIMIT 1");
  $qAtencion->bind_param('i', $idAtencion);
  $qAtencion->execute();
  $qAtencion->bind_result($fechaAtencion, $fechaHoraAtencion, $idConvenioAtencion, $nombrePaciente, $correoPaciente, $urlInformeAtencion);
  $qAtencion->fetch();
  $qAtencion->store_result();
  $qAtencion->close();

  if ($idConvenioAtencion != 0) return "ok"; # no se envía correo
  if ($correoPaciente === null || trim($correoPaciente) === "" || !validarCorreo2($correoPaciente)) return "ok";  # no se envía correo

  $examenesAtencion = obtenerDetalleAtencion($idAtencion);

  $mail = inicializar(); # inicializar correo segun funcion en ../assets/php/correo.php
  $mail->CharSet = "UTF-8";
  $mail->addAddress($correoPaciente, $nombrePaciente);
  $mail->Subject = "Informe de Resultados Atención N° $idAtencion";
  $mail->AddEmbeddedImage('../assets/img/logoEmpresaConCertificado.png', 'logo');

  $mensaje = "Estimado(a) $nombrePaciente,

  Se ha generado un informe de resultados para la atención N° $idAtencion realizada el $fechaAtencion.
  Puede ver este informe ingresando su RUT (o Pasaporte) y el número de atención correspondiente en el siguiente enlace:
  https://www.ripit.cl/RESULTADOS_ETCHEVERRY

  Estado de exámenes:
  $examenesAtencion
  Tú opinión nos importa, haz click &#128073; <a href='https://questionpro.com/t/AWLlAZusXU'>aquí</a> y contesta una breve encuesta para seguir mejorando.
  
  <img src='cid:logo' style='width:500px'>";

  $mail->msgHTML(nl2br($mensaje));
  if (!$mail->send()) return $mail->ErrorInfo;
  return "ok";
}

function recuperarPass($mail, $rut)
{
  global $mysqli;

  $qUsuario = $mysqli->prepare("SELECT USUARIO, CONTRASENA, CONCAT_WS(' ', NOMBRES, APELLIDO_PATERNO, APELLIDO_MATERNO) FROM usuarios WHERE MAIL = ? AND NRO_RUT = ?");
  $qUsuario->bind_param('si', $mail, $rut);
  $qUsuario->execute();
  $qUsuario->bind_result($usuario, $contrasena, $nombre);
  $qUsuario->store_result();
  $rows = $qUsuario->num_rows;
  $qUsuario->fetch();
  $qUsuario->close();

  if ($rows == 0) {
    return array('exito' => false, 'mensaje' => 'ERROR, el correo y/o rut ingresado no existe en nuestros registros');
  } else {
    $envCorr = enviarCorreo($usuario, $contrasena, $nombre, $mail);
    if ($envCorr == 'ok') {
      return array('exito' => true, 'mensaje' => 'Su usuario y contraseña han sido enviados al correo descrito');
    } else {
      return array('exito' => false, 'mensaje' => 'ERROR, mensaje no enviado, intente nuevamente');
    }
  }
}

function obtenerDetalleAtencion($id_atencion)
{
  global $mysqli;

  $qAtencion = $mysqli->prepare("SELECT DATE_FORMAT(a.FECHA,'%d/%m/%Y'), CONCAT(a.FECHA, ' ', a.HORA)
  FROM atenciones a
  WHERE a.ID_ATENCION = ?
  LIMIT 1");
  $qAtencion->bind_param('i', $id_atencion);
  $qAtencion->execute();
  $qAtencion->bind_result($fechaAtencion, $fechaHoraAtencion);
  $qAtencion->fetch();
  $qAtencion->store_result();
  $qAtencion->close();

  $resultado_examenes_atencion = $mysqli->query("SELECT ea.COD_EXAMEN, ea.FECHA_VAL,
  IF(e.NOMBRE_INF IS NULL, e.NOMBRE, e.NOMBRE_INF) AS NOMBRE, e.FLAG_AGRUPACION, e.FLAG_ENTREGA_PRESENCIAL_RESULTADO, e.HORAS_PROCESO, 
  a.FECHA_INF, COUNT(ea_1.ID_EXATE) AS N_HIJOS, COUNT(ea_1.FECHA_VAL) AS N_HIJOS_VALIDADOS
  FROM examenes_atenciones ea
	JOIN examenes e ON ea.COD_EXAMEN = e.COD_INTERNO
	JOIN atenciones a ON ea.ID_ATENCION = a.ID_ATENCION
	LEFT JOIN examenes_atenciones ea_1 ON e.FLAG_AGRUPACION = 'S' AND ea_1.ID_ATENCION = ea.ID_ATENCION AND ea_1.F_HIJO = 'S' AND ea.COD_EXAMEN = ea_1.PADRE AND ea_1.COD_EXAMEN != '00.00.159' # regla especial para 04.02.046 / GASES VENOSOS 
	WHERE ea.ID_ATENCION = $id_atencion AND e.F_INF = 'S' AND ea.F_HIJO IS NULL AND ea.NRO_HOJA_TRABAJO != 7
	GROUP BY ea.COD_EXAMEN
	ORDER BY ea.ID_EXATE ASC");

  $html = '<ul>';
  while ($examen_atencion = $resultado_examenes_atencion->fetch_assoc()) {
    if ($examen_atencion['FECHA_INF'] != null) $html .= validarExamen($examen_atencion, $fechaHoraAtencion);
    else $html .=  "<li><b style='color:red;'>PENDIENTE</b> {$examen_atencion['NOMBRE']} </li>";
  }
  $html .= '</ul>';
  return $html;
}

function validarExamen($examen_atencion, $fechaHoraAtencion)
{
  if ($examen_atencion['FLAG_AGRUPACION'] == 'S') {
    # CASO "UROCULTIVO Y RECUENTO DE COLONIAS" y "SEROLOGÍA SARS-COV-2": al menos uno dee los hijos debe estar validado
    # CASO NORMAL: todos los exámenes hijos deben estar validados
    if (in_array($examen_atencion['COD_EXAMEN'], ['06.06.011', '00.00.071'], true) && $examen_atencion['N_HIJOS_VALIDADOS'] > 0) return "<li><b style='color:green;'>INFORMADO</b> {$examen_atencion['NOMBRE']} </li>";
    if (in_array($examen_atencion['COD_EXAMEN'], ['06.06.011', '00.00.071'], true) && $examen_atencion['N_HIJOS_VALIDADOS'] > 0) return "<li><b style='color:green;'>INFORMADO</b> {$examen_atencion['NOMBRE']} </li>";
    if ($examen_atencion['N_HIJOS'] == $examen_atencion['N_HIJOS_VALIDADOS']) return "<li><b style='color:green;'>INFORMADO</b> {$examen_atencion['NOMBRE']} </li>";
  }
  if ($examen_atencion['FLAG_AGRUPACION'] == 'N') {
    $ahora = date("Y-m-d H:i:s");
    $horaEntregaExamen = date("Y-m-d H:i:s", strtotime("$fechaHoraAtencion +{$examen_atencion['HORAS_PROCESO']} hours"));
    if ($examen_atencion['FLAG_ENTREGA_PRESENCIAL_RESULTADO'] == 1) {
      if ($ahora >= $horaEntregaExamen) return "<li><b style='color:blue;'>INFORMADO (ENTREGA PRESENCIAL)</b> {$examen_atencion['NOMBRE']} </li>";
      if ($ahora < $horaEntregaExamen)  return "<li><b style='color:red;'>PENDIENTE (ENTREGA PRESENCIAL)</b> {$examen_atencion['NOMBRE']} </li>";
    }
    if ($examen_atencion['FECHA_VAL'] != "") return "<li><b style='color:green;'>INFORMADO</b> {$examen_atencion['NOMBRE']} </li>";
    if ($examen_atencion['FECHA_VAL'] == "") return "<li><b style='color:red;'>PENDIENTE</b> {$examen_atencion['NOMBRE']} </li>";
  }
  return "<li><b style='color:red;'>PENDIENTE</b> {$examen_atencion['NOMBRE']} </li>";
}
