<?php
$pantalla_actual = 'LIS_PERSO';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

function sino($valor)
{
	if ($valor == 'S') return '<i class="fa fa-check-circle fa-lg txt-color-green"></i>';
	return '<i class="fa fa-times-circle fa-lg txt-color-red"></i>';
}

$qPersonas = $mysqli->prepare("SELECT p.ID_PERSONA, p.NRO_RUT, p.DV_RUT, p.NOMBRES, p.APELLIDO_PATERNO, p.APELLIDO_MATERNO, p.GENERO, p.FLAG_PACIENTE, p.MAIL, p.FONO_1, p.FONO_2,
p.FLAG_MEDICO, DATE_FORMAT(p.FECHA_NACIMIENTO,'%d/%m/%Y') AS FECHANAC, p.FLAG_ELIMINADO,
e.NOMBRE_E AS PREV
FROM personas p
LEFT JOIN empresas e ON p.ID_PREVISION = e.ID_EMPRESA
GROUP BY p.ID_PERSONA
ORDER BY APELLIDO_PATERNO, APELLIDO_MATERNO, NOMBRES");
$qPersonas->execute();
$qPersonas->bind_result(
	$p_idPersona,
	$p_nroRut,
	$p_dvRut,
	$p_nombre,
	$p_apaterno,
	$p_amaterno,
	$p_genero,
	$p_flagPaciente,
	$p_mail,
	$p_fono_1,
	$p_fono_2,
	$p_flagMedico,
	$p_fechaNac,
	$p_flagEliminado,
	$p_prevision
);
$qPersonas->store_result();
$totalRows_personas = $qPersonas->num_rows;

ob_start();
?>

<table id="dataTable" class="table table-hover table-bordered">
	<thead>
		<tr>
			<th>RUT</th>
			<th>Nombre</th>
			<th>Fecha nacimiento</th>
			<th>E-mail</th>
			<th>Teléfono</th>
			<th>Paciente</th>
			<th>Médico</th>
			<th>Previsión</th>
			<th>Estado</th>
			<th>Acciones</th>
		</tr>
	</thead>
	<tbody>
		<?php while ($qPersonas->fetch()) { ?>
			<tr>
				<td><?= number_format($p_nroRut, 0, ',', '.') ?>-<?= $p_dvRut ?></td>
				<td><?= $p_nombre . ' ' . $p_apaterno . ' ' . $p_amaterno ?></td>
				<td><?= $p_fechaNac ?></td>
				<td><?= $p_mail ?></td>
				<td><?= "$p_fono_1<br>$p_fono_2" ?></td>
				<td style="text-align:center"><?= sino($p_flagPaciente) ?></td>
				<td style="text-align:center"><?= sino($p_flagMedico) ?></td>
				<td><?= $p_prevision ?></td>
				<td><?= $p_flagEliminado != 1 ? "<span class='badge bg-color-green'>Activo</span>" : "<span class='badge bg-color-yellow'>Eliminado</span>" ?></td>
				<td>
					<div class="btn-group" role="group">
						<a class="btn btn-link" data-toggle="modal" href="e_persona.php?id=<?= $p_idPersona ?>" data-target="#myModalEdit" title="Modificar"><i class="fa fa-edit fa-lg"></i></a>
						<?php
						if (in_array($usuario_perfil, ["ADMINISTRADOR", "SUPERVISOR"])) {
							if ($p_flagEliminado != 1) echo "<a class='btn btn-link btn-eliminarPersona txt-color-yellow' data-id='$p_idPersona' title='Eliminar'><i class='fa fa-trash-o fa-lg'></i></a>";
							else echo "<a class='btn btn-link btn-restaurarPersona txt-color-green' data-id='$p_idPersona' title='Restaurar'><i class='fa fa-arrow-circle-up fa-lg'></i></a>";
						}
						?>
					</div>
				</td>
			</tr>
		<?php }
		$qPersonas->close() ?>
	</tbody>
</table>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
	"title" => $datos_pantallas[$pantalla_actual]['body_title'],
	"icon" => 'fa fa-cog',
	'toolbar' => array(
		array(
			"id" => "toolbar-id",
			"content" => '<a class="btn btn-success"  href="n_persona.php"  data-toggle="modal" data-target="#myModalNew"><i class="fa fa-plus"></i> Agregar </a>',
			"class" => 'smart-form'
		)
	)
);
$widget->body('content', $contenido);
?>
<div id="main" role="main">
	<?php

	include("../inc/ribbon.php");
	?>
	<div id="content">
		<?php
		$widget->print_html();
		?>
	</div>
</div>

<div class="modal fade Edit" id="myModalEdit" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content" style="width:120%">
		</div>
	</div>
</div>

<div class="modal fade New" id="myModalNew" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content" style="width:120%">
		</div>
	</div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<script src="<?= ASSETS_URL ?>/js/plugin/rut/jquery.Rut.min.js"></script>

<script>
	$(document).ready(function() {
		var order = [0, "asc"];
    var columnasNoOrdenables = [1];
    inicializarDataTables('dataTable', order, columnasNoOrdenables);

		$('#buscar').click(function() {
			$('#formBuscar').submit();
		});

		$('.btn-eliminarPersona').on('click', function() {
			if (confirm('¿Desea eliminar esta persona?')) {
				$.post("sql_cod.php", {
					eliminarPersona: true,
					idPersona: $(this).data('id'),
				}, function(data) {
					if (data.exito) {
						exito();
						location.reload();
					} else {
						error("Error: " + data.mensaje);
					}
				}, 'json');
			}
		});

		$('.btn-restaurarPersona').on('click', function() {
			if (confirm('¿Desea restaurar esta persona?')) {
				$.post("sql_cod.php", {
					restaurarPersona: true,
					idPersona: $(this).data('id')
				}, function(data) {
					if (data.exito) {
						exito();
						location.reload();
					} else {
						error("Error: " + data.mensaje);
					}
				}, 'json');
			}
		});
	});
</script>

<?php
include("../inc/google-analytics.php");
?>