<?php
define('PERMITIDO', true);
$pantalla_actual = 'LIS_PLA';

require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
$style= "<style>.select2-hidden-accessible{display:none;}	</style>";
include("../inc/header.php");
include("../inc/nav.php");

//===================================================================================================================

$qplantillas=$mysqli->prepare("SELECT id_plantilla, p.nombre, IFNULL(c.NOMBRE_E, '-'), cc.NOMBRE, CONCAT_WS(' ', m.NOMBRES, m.APELLIDO_PATERNO, m.APELLIDO_MATERNO), cg.DESCRIPCION_CG
FROM plantillas p
LEFT JOIN empresas c ON c.ID_EMPRESA = p.id_convenio
INNER JOIN centros_contacto cc ON cc.ID_CENTRO_CONTACTO = p.id_local
INNER JOIN personas m ON m.ID_PERSONA = p.id_medico
INNER JOIN codigos_generales cg ON cg.CODIGO=p.cod_urgencia AND cg.COD_TABLA = 'SIS_NIVURG'
ORDER BY id_plantilla DESC");
$qplantillas->execute();
$qplantillas->bind_result($p_id, $p_nombre, $p_convenio, $p_local, $p_medico, $p_urgencia);
$qplantillas->store_result();

$qconvenios=$mysqli->prepare("SELECT ID_EMPRESA, NOMBRE_E FROM empresas WHERE FLAG_CONVENIO='S' ORDER BY NOMBRE_E");
$qconvenios->execute();
$qconvenios->bind_result($c_id, $c_nombre);
$options_convenios='<option value="0">-</option>';
while($qconvenios->fetch()) {
  $options_convenios.='<option value="'.$c_id.'">'.$c_nombre.'</option>';
}
$qconvenios->close();

$qlocales=$mysqli->prepare("SELECT ID_CENTRO_CONTACTO, NOMBRE, FLAG_DIALISIS FROM centros_contacto ORDER BY NOMBRE");
$qlocales->execute();
$qlocales->bind_result($l_id, $l_nombre, $l_dialisis);
$options_locales='';
while($qlocales->fetch()) {
  $options_locales.='<option value="'.$l_id.'" data-dialisis="'.$l_dialisis.'">'.$l_nombre.'</option>';
}
$qlocales->close();

$qturnos_dialisis=$mysqli->prepare("SELECT CODIGO, DESCRIPCION_CG FROM codigos_generales WHERE COD_TABLA='SIS_TURDIA'");
$qturnos_dialisis->execute();
$qturnos_dialisis->bind_result($turno_cod, $turno_desc);
$options_turnos_dialisis='<option value="0">-</option>';
while($qturnos_dialisis->fetch()) {
  $options_turnos_dialisis.='<option value="'.$turno_cod.'">'.$turno_desc.'</option>';
}
$qturnos_dialisis->close();

$qmedicos=$mysqli->prepare("SELECT ID_PERSONA, NOMBRES, APELLIDO_PATERNO, APELLIDO_MATERNO FROM personas WHERE FLAG_MEDICO='S' AND FLAG_ELIMINADO IS NULL ORDER BY APELLIDO_PATERNO");
$qmedicos->execute();
$qmedicos->bind_result($m_id, $m_nombre, $m_apellidoPaterno, $m_apellidoMaterno);
$options_medicos='';
while($qmedicos->fetch()) {
  $options_medicos.='<option value="'.$m_id.'">'.$m_apellidoPaterno.' '.$m_apellidoMaterno.', '.$m_nombre.'</option>';
}
$qmedicos->close();

$qurgencia=$mysqli->prepare("SELECT CODIGO, DESCRIPCION_CG FROM codigos_generales WHERE COD_TABLA='SIS_NIVURG'");
$qurgencia->execute();
$qurgencia->bind_result($u_id, $u_nombre);
$options_urgencia='';
while($qurgencia->fetch()) {
  $options_urgencia.='<option value="'.$u_id.'">'.$u_nombre.'</option>';
}
$qurgencia->close();

ob_start();
?>

<table class="table table-hover table-bordered" id="DTPlantilla">
  <thead>
    <tr>
      <th>ID Plantilla</th>
      <th>Nombre Plantilla</th>
      <th>Convenio</th>
      <th>Procedencia</th>
      <th>Médico</th>
      <th>Nivel Urgencia</th>
      <!-- <th style="text-align:center">Cargar</th> -->
      <th style="text-align:center">Acciones</th>
    </tr>
  </thead>
  <tbody>
    <?php while($qplantillas->fetch()) { ?>
      <tr>
        <td><?=$p_id?></td>
        <td><?=$p_nombre?></td>
        <td><?=$p_convenio?></td>
        <td><?=$p_local?></td>
        <td><?=$p_medico?></td>
        <td><?=$p_urgencia?></td>
        <td style="text-align:center">
          <a style="padding:1px;" href="e_plantilla.php?idp=<?=$p_id?>" class="btn btn-link" title="Modificar Plantilla"><i class="fa fa-edit fa-lg"></i></a>
          <a style="padding:1px;" class="btn btn-link btn-eliminar" data-eliminar="plantilla" title="Eliminar Plantilla" data-id="<?=$p_id?>"><i  class="fa fa-trash-o fa-lg"></i></a>
        </td>
      </tr>
    <?php } $qplantillas->close(); ?>
  </tbody>
</table>
<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
    "title" => $datos_pantallas[$pantalla_actual]['body_title'],
    "icon" => 'fa fa-file-text-o',
	'toolbar' => array(
		array(
			"id" => "toolbar-id",
			"content" => '<a class="btn btn-success"  href="#"  data-toggle="modal" data-target="#myModalNew"><i class="fa fa-plus"></i> Agregar</a>',
			"class" => 'smart-form'
		)
	)
);
$widget->body('content', $contenido);
?>

<!-- ==========================CONTENT STARTS HERE ========================== -->
<!-- MAIN PANEL -->
<div id="main" role="main">
	<?php include("../inc/ribbon.php");	?>

	<!-- MAIN CONTENT -->
	<div id="content">

		<?php
      $widget->print_html();
    ?>

	</div>
	<!-- END MAIN CONTENT -->

</div>
<!-- END MAIN PANEL -->
<!-- ==========================CONTENT ENDS HERE ========================== -->

<!-- PAGE FOOTER -->
<?php
	// include page footer
	include("../inc/footer.php");
?>
<!-- END PAGE FOOTER -->

<?php
	//include required scripts
	include("../inc/scripts.php");
?>

<!-- PAGE RELATED PLUGIN(S)
<script src="<?=ASSETS_URL?>/js/plugin/YOURJS.js"></script>-->

<!-- Modal -->
<div class="modal fade New" id="myModalNew" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">
          &times;
        </button>
        <h4 class="modal-title" id="myModalLabel">Ingreso de Plantilla</h4>
      </div>
      <div class="modal-body">
        <form name="formPlantilla" id="formPlantilla" class="smart-form" action="sql_cod.php" method="post">
          <div class="row" style="margin:0; padding-bottom:0.6em;">
            <div class="col-md-3">Nombre</div>
            <div class="col-md-9">
              <label class="input">
                <input type="text" class="input-sm" name="nombre" placeholder="Nombre Plantilla" title="Nombre Plantilla">
              </label>
            </div>
          </div>
          <div class="row" style="margin:0; padding-bottom:0.6em;">
            <div class="col-md-3">Convenio</div>
            <div class="col-md-9">
              <label class="select">
                <select class="input-sm" name="id_convenio">
                  <?=$options_convenios?>
                </select>
                <i></i>
              </label>
            </div>
          </div>
          <div class="row" style="margin:0; padding-bottom:0.6em;">
            <div class="col-md-3">Centro de Toma de Muestras</div>
            <div class="col-md-9">
              <label class="select">
                <select class="input-sm" name="id_local" id="id_local">
                  <?=$options_locales?>
                </select>
                <i></i>
              </label>
            </div>
          </div>
          <div class="row" style="margin:0; padding-bottom:0.6em;">
            <div class="col-md-3">Turno de Diálisis</div>
            <div class="col-md-9">
              <label class="select">
                <select class="input-sm" name="id_turdia" id="id_turdia" disabled>
                  <?=$options_turnos_dialisis?>
                </select>
                <i></i>
              </label>
            </div>
          </div>
          <div class="row"  style="margin:0; padding-bottom:0.6em;">
            <div class="col-md-3">Medico</div>
            <div class="col-md-9">
              <label class="select">
                <select class="select2" name="id_medico">
                  <?=$options_medicos?>
                </select>
              </label>
            </div>
          </div>
          <div class="row" style="margin:0; padding-bottom:0.6em;">
            <div class="col-md-3">Nivel Urgencia</div>
            <div class="col-md-9">
              <label class="select">
                <select class="input-sm" name="cod_urgencia">
                  <?=$options_urgencia?>
                </select>
                <i></i>
              </label>
            </div>
          </div>
          <input type="hidden" name="insertPlantilla" value="formPlantilla">
        </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal"> Cancelar </button>
        <a class="btn btn-primary btn-sm pull-right btn-grabar"> <i class="fa fa-save"></i> Grabar </a>
      </div>
    </div><!-- /.modal-content -->
  </div><!-- /.modal-dialog -->
</div>

<script>
var DTPlantilla = null;

$(document).ready(function() {
  DTPlantilla = $('#DTPlantilla').DataTable({
    'lengthMenu': [[50, 100, 200], [50, 100, 200]],
    'language': {
      "sProcessing":   "Procesando...",
      "sZeroRecords":  "No se encontraron resultados",
      "sInfoPostFix":  "",
      "sUrl":          "",
      "oPaginate": {
        "sFirst":    "Primero",
        "sPrevious": "Anterior",
        "sNext":     "Siguiente",
        "sLast":     "Último"
      },
      "sInfo": "_START_ a _END_ de _TOTAL_ Registros",
      "sInfoEmpty":    "0 Registros",
      "sInfoFiltered": "(de _MAX_ Registros en total)",
      "sLengthMenu":"Mostrar _MENU_ Registros",
      "sSearch":"Buscar: "
    },
    'pageLength' : 50,
    'order' : [ 5, 'desc' ],
    'columns': [
      null,
      null,
      null,
      null,
      null,
      null,
      {"orderable": false}
    ],
    'destroy': true
  }); //DataTables

  $('.btn-grabar').on('click', function() {
    $.post('sql_cod.php', $('#formPlantilla').serialize(), function(data) {
      if (data.exito){
        exito();
        location.reload();
      } else {
        error("Error: "+data.mensaje);
      }
    }, 'json');
  });

  $('.btn-CargarP').on('click', function() {
    load();
    $.post('sql_cod.php', {cargarPlantilla:$(this).data('id')}, function(data) {
      if (data.exito) {
        exito();
      } else {
        error("Error: "+data.mensaje);
      }
    }, 'json');
  });

  $('#content').on('click', '.btn-eliminar', function(){
    if(confirm("¿Desea eliminar esta plantilla?")) {
      $.post('sql_cod.php', {eliminar:$(this).data('eliminar'), id:$(this).data('id')}, function(data) {
        if (data.exito) {
          exito();
          location.reload();
        } else {
          error("Error: "+data.mensaje);
        }
      }, 'json');
    }
  });

	$('#id_local').on('change', function() {
		var dialisis = $('#id_local option:selected').attr('data-dialisis');
		$('#id_turdia').val('0');
		if (dialisis == 'S') {
			$('#id_turdia').removeAttr('disabled');
		} else {
			$('#id_turdia').attr('disabled', 'disabled');
		}
	});
});

$(window).load(function() {
  var searchInputValue = $('.dataTables_filter input').val();
  DTPlantilla.search(searchInputValue).draw();
});

</script>

<?php
	//include footer
	include("../inc/google-analytics.php");
?>