<?php
define('PERMITIDO', true);
$pagina = 50;
require_once("../inc/init.php");


if (isset($_POST['insertPlantilla'])) {
	$qinsert = $mysqli->prepare('INSERT INTO plantillas (nombre, id_convenio, id_local, id_medico, cod_urgencia, turno_dialisis) VALUES (?, ?, ?, ?, ?, ?)');
	$qinsert->bind_param('siiiii', $_POST['nombre'], $_POST['id_convenio'], $_POST['id_local'], $_POST['id_medico'], $_POST['cod_urgencia'], $_POST['id_turdia']);
	$qinsert->execute();
	$qinsert->close();

	$respuesta = array('exito' => true);
	echo json_encode($respuesta);
	exit(0);
}

if (isset($_POST['updatePlantilla'])) {
	$qupdate = $mysqli->prepare('UPDATE plantillas SET nombre=?, id_convenio=?, id_local=?, id_medico=?, cod_urgencia=?, turno_dialisis=?, obs=? WHERE id_plantilla=?');
	$qupdate->bind_param('siiiissi', $_POST['nombre'], $_POST['id_convenio'], $_POST['id_local'], $_POST['id_medico'], $_POST['cod_urgencia'], $_POST['id_turdia'], $_POST['obs'], $_POST['id_plantilla']);
	$qupdate->execute();
	$qupdate->close();

	$respuesta = array('exito' => true);
	echo json_encode($respuesta);
	exit(0);
}

if (isset($_POST['insertPaciente'])) {

	if (!isset($_POST['id_paciente']) || $_POST['id_paciente'] == "") mostrarMensajeError("Seleccione un paciente");

	$qplantilla = $mysqli->prepare('SELECT id_plantilla_p	FROM plantilla_pacientes WHERE id_plantilla = ? and id_paciente = ?');
	$qplantilla->bind_param('ii', $_POST['id_plantilla'], $_POST['id_paciente']);
	$qplantilla->execute();
	$qplantilla->bind_result($idPlantillaPaciente);
	$qplantilla->store_result();
	$qplantilla->fetch();
	$qplantilla->close();

	if ($idPlantillaPaciente != "") mostrarMensajeError("Paciente ya presente en la planilla");

	$qinsert = $mysqli->prepare('INSERT INTO plantilla_pacientes (id_plantilla, id_paciente) VALUES (?, ?)');
	$qinsert->bind_param('ii', $_POST['id_plantilla'], $_POST['id_paciente']);
	$qinsert->execute();
	$qinsert->close();

	$respuesta = array('exito' => true);
	echo json_encode($respuesta);
	exit(0);
}

if (isset($_POST['insertExamen'])) {
	$qinsert = $mysqli->prepare('INSERT INTO plantilla_examenes (id_plantilla, cod_interno) VALUES (?, ?)');
	$qinsert->bind_param('is', $_POST['id_plantilla'], $_POST['cod_interno']);
	$qinsert->execute();
	$qinsert->close();
  # EXAMENES ADICIONALES
  if (in_array($_POST['cod_interno'], ["02.02.057", "02.02.576", "02.02.023", "00.00.288", "00.00.286", "00.00.291", "00.00.289", "00.00.290"])) {
		if ($_POST['cod_interno'] == "02.02.057") $codExamenAdicional = "02.02.157"; # UREMIA | nitrogeno ureico
		if ($_POST['cod_interno'] == "02.02.576") $codExamenAdicional = "02.02.557"; # UREMIA POST | nitrogeno ureico post
		if ($_POST['cod_interno'] == "02.02.023") $codExamenAdicional = "00.00.042"; # C. CREATININEMIA | velocidad de filtracion glomerular
		if ($_POST['cod_interno'] == "00.00.288") $codExamenAdicional = "04.05.046"; # LINFOCITOS T CD3, RECUENTO ABSOLUTO | LINFOCITOS T CD3, RECUENTO RELATIVO
		if ($_POST['cod_interno'] == "00.00.286") $codExamenAdicional = "04.05.043"; # LINFOCITOS B CD19, RECUENTO ABSOLUTO | LINFOCITOS B CD19, RECUENTO RELATIVO
		if ($_POST['cod_interno'] == "00.00.291") $codExamenAdicional = "00.00.152"; # LINFOCITOS NK CELLS, NATURAL KILLER (CD16/CD56), RECUENTO ABSOLUTO | LINFOCITOS NK CELLS, NATURAL KILLER (CD16/CD56), RECUENTO RELATIVO 
		if ($_POST['cod_interno'] == "00.00.289") $codExamenAdicional = "04.05.145"; # LINFOCITOS T CD4, RECUENTO ABSOLUTO | LINFOCITOS T CD4, RECUENTO RELATIVO
		if ($_POST['cod_interno'] == "00.00.290") $codExamenAdicional = "04.05.245"; # LINFOCITOS T CD8, RECUENTO ABSOLUTO | LINFOCITOS T CD8, RECUENTO RELATIVO - RELACION CD4/CD8
		$qInserAdicional = $mysqli->prepare("INSERT INTO plantilla_examenes (id_plantilla, cod_interno) VALUES (?, ?)");
		$qInserAdicional->bind_param("is", $_POST['id_plantilla'], $codExamenAdicional);
		$qInserAdicional->execute();
		$qInserAdicional->close();
		if ($_POST['cod_interno'] == "00.00.290") {
			$qInserAdicional = $mysqli->prepare("INSERT INTO plantilla_examenes (id_plantilla, cod_interno) VALUES (?, '00.00.285')");
			$qInserAdicional->bind_param("i", $_POST['id_plantilla']);
			$qInserAdicional->execute();
			$qInserAdicional->close();
    }
	}

	$respuesta = array('exito' => true);
	echo json_encode($respuesta);
	exit(0);
}

if (isset($_POST['eliminar'])) {
	if ($_POST['eliminar'] == 'plantilla') {
		$consulta = 'DELETE FROM plantilla_examenes WHERE id_plantilla=?';
		$qinsert = $mysqli->prepare($consulta);
		$qinsert->bind_param('i', $_POST['id']);
		$qinsert->execute();
		$qinsert->close();

		$consulta = 'DELETE FROM plantilla_pacientes WHERE id_plantilla=?';
		$qinsert = $mysqli->prepare($consulta);
		$qinsert->bind_param('i', $_POST['id']);
		$qinsert->execute();
		$qinsert->close();

		$consulta = 'DELETE FROM plantillas WHERE id_plantilla=?';
		$qinsert = $mysqli->prepare($consulta);
		$qinsert->bind_param('i', $_POST['id']);
		$qinsert->execute();
		$qinsert->close();
	} else {
		if ($_POST['eliminar'] == 'paciente') {
			$consulta = 'DELETE FROM plantilla_pacientes WHERE id_plantilla_p=?';
		}
		if ($_POST['eliminar'] == 'examen') {
			$consulta = 'DELETE FROM plantilla_examenes WHERE id_plantilla_e=?';
		}
		$qinsert = $mysqli->prepare($consulta);
		$qinsert->bind_param('i', $_POST['id']);
		$qinsert->execute();
		$qinsert->close();
	}

	$respuesta = array('exito' => true);
	echo json_encode($respuesta);
	exit(0);
}


# CARGAR PLANTILLA  
if (isset($_POST['cargarPlantilla'])) {

	if ($_POST['fecha'] == '') mostrarMensajeError("Debe ingresar fecha");

	$idp = $_POST['cargarPlantilla'];
	$qplantilla = $mysqli->prepare('SELECT id_convenio, id_local, id_medico, cod_urgencia, turno_dialisis, obs 
	FROM plantillas WHERE id_plantilla = ?');
	$qplantilla->bind_param('i', $idp);
	$qplantilla->execute();
	$qplantilla->bind_result($pl_idConvenio, $pl_idLocal, $pl_idMedico, $pl_codUrgencia, $pl_turno_dialisis, $pl_obs);
	$qplantilla->store_result();
	$qplantilla->fetch();
	$qplantilla->close();

	$qexamenes = $mysqli->prepare('SELECT pl_ex.cod_interno, pr_ex.PRECIO, ex.TIPO_TUBO, ex.NRO_HOJA_TRABAJO, ex.FLAG_AGRUPACION 
	FROM plantilla_examenes pl_ex
	INNER JOIN examenes ex ON ex.COD_INTERNO = pl_ex.cod_interno
	LEFT JOIN precios_examenes pr_ex ON pr_ex.COD_EXAMEN = pl_ex.cod_interno AND pr_ex.ID_EMPRESA = ?
	WHERE pl_ex.id_plantilla = ?');
	$qexamenes->bind_param('ii', $pl_idConvenio, $idp);
	$qexamenes->execute();
	$qexamenes->bind_result($ex_codInterno, $ex_precio, $ex_tipoTubo, $ex_hojaTrabajo, $ex_flagAgrupacion);
	$qexamenes->store_result();

	$qpacientes = $mysqli->prepare('SELECT pp.id_paciente, pp.id_muestra, pp.fecha_tm, pp.hora_tm, p.ID_PREVISION 
	FROM plantilla_pacientes pp
	INNER JOIN personas p ON  p.ID_PERSONA = pp.id_paciente
	WHERE id_plantilla = ?');
	$qpacientes->bind_param('i', $idp);
	$qpacientes->execute();
	$qpacientes->bind_result($pa_id, $pa_idMuestra, $pa_fechaTm, $pa_horaTm, $pa_idPrevision); # $pa_fechaTm, $pa_horaTm,
	$qpacientes->store_result();

	$dt_ahora = new DateTime;
	$hora_ahora = $dt_ahora->format('H:i:s');
	$fecha_hora_ahora = $dt_ahora->format('Y-m-d H:i:s');

	while ($qpacientes->fetch()) {
		# Insert Atencion
		$qinsertAt = $mysqli->prepare("INSERT INTO atenciones (ID_USUARIO, TIPO_CLIENTE, ID_CLIENTE, FECHA, HORA, FECHA_TM, HORA_TM, ID_CENTRO_CONTACTO, 
		ID_MEDICO, ID_CONVENIO, PCTJE_DESCUENTO, ID_PREVISION, NIVEL_URGENCIA, MONTO_DESCUENTO, FLAG_ACEPTA_C, CIERRE_ATE, COD_DIAGNOSTICO, TURNO_DIALISIS, OBS, ID_PLANTILLA)
		VALUES (?, 'P', ?, ?, ?, ?, ?, ?, ?, ?, 0, ?, ?, 0, 1, 'N', 0, ?, ?, ?)");
		$qinsertAt->bind_param('iissssiiiiiisi', $usuario_id, $pa_id, $_POST['fecha'], $hora_ahora, $pa_fechaTm, $pa_horaTm, $pl_idLocal, 
		$pl_idMedico, $pl_idConvenio, $pa_idPrevision, $pl_codUrgencia, $pl_turno_dialisis, $pl_obs, $idp);
		$qinsertAt->execute();
		# echo $mysqli->error;
		$idate = $qinsertAt->insert_id;
		$qinsertAt->close();

		$montoAtencion = 0;
		while ($qexamenes->fetch()) {
			$monto_examen = $ex_precio;
			if ($monto_examen == null) {
				$sql_precio_examen_prevision = "SELECT PRECIO FROM precios_examenes WHERE COD_EXAMEN = '{$ex_codInterno}' AND ID_EMPRESA = {$pa_idPrevision}";
				$resultado_precio_examen_prevision = $mysqli->query($sql_precio_examen_prevision);
				$precio_examen_prevision = $resultado_precio_examen_prevision->fetch_assoc();
				$monto_examen = $precio_examen_prevision['PRECIO'];
			}

			# Insert Examenes
			$qinsertEx = $mysqli->prepare("INSERT INTO examenes_atenciones (ID_ATENCION, COD_EXAMEN, TIPO_TUBO, NRO_HOJA_TRABAJO, PRECIO_EXAMEN, COBRADO, PREV)
			VALUES (?, ?, ?, ?, ?, 'N', ?)");
			$qinsertEx->bind_param("isiiii", $idate, $ex_codInterno, $ex_tipoTubo, $ex_hojaTrabajo, $monto_examen, $pa_idPrevision);
			$qinsertEx->execute();
			$qinsertEx->close();
			# Si es agrupacion, inserto hijos
			if ($ex_flagAgrupacion == "S") {
				$qexhijos = $mysqli->prepare("SELECT COD_EXAMEN_AGRUPADO, e.TIPO_TUBO, e.NRO_HOJA_TRABAJO
				FROM agrupaciones_examenes ae
				INNER JOIN examenes e ON e.COD_INTERNO = ae.COD_EXAMEN_AGRUPADO
				WHERE ae.COD_INTERNO = ?");
				$qexhijos->bind_param("s", $ex_codInterno);
				$qexhijos->execute();
				$qexhijos->bind_result($h_codInterno, $h_tipoTubo, $h_nroHojaTrabajo);
				$qexhijos->store_result();
				while ($qexhijos->fetch()) {
					# Insert Examenes Hijos
					$qinsertEx = $mysqli->prepare("INSERT INTO examenes_atenciones (ID_ATENCION, COD_EXAMEN, F_HIJO, PADRE, TIPO_TUBO, NRO_HOJA_TRABAJO, COBRADO)
					VALUES (?, ?, 'S', ?, ?, ?, 'N')");
					$qinsertEx->bind_param('issii', $idate, $h_codInterno, $ex_codInterno, $h_tipoTubo, $h_nroHojaTrabajo);
					$qinsertEx->execute();
					$qinsertEx->close();
				}
				$qexhijos->close();
			}
			$montoAtencion = $montoAtencion + $monto_examen;
		}
		$qexamenes->data_seek(0);

		# Actualizo monto atencion
		$qupdateMonto = $mysqli->prepare("UPDATE atenciones SET MONTO_ATENCION = ? WHERE ID_ATENCION = ?");
		$qupdateMonto->bind_param("ii", $montoAtencion, $idate);
		$qupdateMonto->execute();
		$qupdateMonto->close();
		# Si viene id de muestra minsal en la planilla, se crea el registro asoaciado a la atención recien creada
		if ($pa_idMuestra !== null) {
			$qMuestraMinsal = $mysqli->prepare("INSERT INTO toma_de_muestras_minsal (ID_EXAMEN_ATENCION, ID_ATENCION, FOLIO_EPIVIGILA, BUSQUEDA_ACTIVA, ID_MUESTRA_MINSAL, ID_USUARIO_CREACION_MUESTRA, FECHA_HORA_CREACION_MUESTRA)
			VALUES (NULL, ?, 0, NULL, ?, ?, ?)");
			$qMuestraMinsal->bind_param("iiis", $idate, $pa_idMuestra, $usuario_id, $fecha_hora_ahora);
			$qMuestraMinsal->execute();
			$qMuestraMinsal->close();
		}
	}
	$qpacientes->close();
	$qexamenes->close();
	$respuesta = array("exito" => true);

	echo json_encode($respuesta);
	exit(0);
}
