<?php
# $pagina = 7; # no es necesario definiar la pagina en modals o sql_cods
define('PERMITIDO', true);
require_once("../inc/init.php");

if (isset($_POST['nombre_medico'])) {
	$busqueda = "%{$_POST['nombre_medico']}%";

	$query = $mysqli->prepare("SELECT p.ID_PERSONA, CONCAT(p.NRO_RUT,'-', p.DV_RUT), CONCAT(p.NOMBRES, ' ', p.APELLIDO_PATERNO, ' ', IFNULL(p.APELLIDO_MATERNO, '')),
	cg.DESCRIPCION_CG 
	FROM personas p
	LEFT JOIN codigos_generales cg ON p.ESPECIALIDAD = cg.CODIGO AND cg.COD_TABLA = 'SIS_ESPECI'
	WHERE p.FLAG_MEDICO = 'S' 
	AND CONCAT(p.NOMBRES, ' ', p.APELLIDO_PATERNO, ' ', IFNULL(p.APELLIDO_MATERNO, '')) LIKE ? 
	AND p.FLAG_ELIMINADO IS NULL
	LIMIT 20");
	$query->bind_param('s', $busqueda);
	$query->execute();
	$query->bind_result($idMedico, $rutMedico, $nombreMedico, $especialidadMedico);

	$options = array();
	while ($query->fetch()) {
		$options[] = array(
			'id_medico' => $idMedico,
			'rut_medico' => $rutMedico,
			'nombre_medico' => $nombreMedico,
			'especialidad' => $especialidadMedico
		);
	}
	$query->close();


	echo json_encode($options);
	return;
}
