<?php
# $pagina = 7; # no es necesario definiar la pagina en modals o sql_cods
define('PERMITIDO', true);
require_once("../inc/init.php");

if (isset($_POST['nombre'])) {
	$busqueda = "%{$_POST['nombre']}%";

	$query = $mysqli->prepare("SELECT p.ID_PERSONA, CONCAT(p.NRO_RUT,'-', p.DV_RUT), CONCAT(p.NOMBRES,' ', p.APELLIDO_PATERNO, ' ', IFNULL(p.APELLIDO_MATERNO, '')),
	DATE_FORMAT(p.FECHA_NACIMIENTO, '%d/%m/%Y'), p.FONO_1, p.DIRECCION, p.ID_PREVISION, e.NBR
	FROM personas p
	LEFT JOIN empresas e ON p.ID_PREVISION = e.ID_EMPRESA 
	WHERE (
		CONCAT(p.NRO_RUT, '-', p.DV_RUT) LIKE ? 
		OR CONCAT(p.NOMBRES,' ', p.APELLIDO_PATERNO, ' ', IFNULL(p.APELLIDO_MATERNO, '')) LIKE ?
	) 
	AND p.FLAG_ELIMINADO IS NULL
	LIMIT 20");
	$query->bind_param('ss', $busqueda, $busqueda);
	$query->execute();
	$query->bind_result($idPaciente, $rutPaciente, $nombrePaciente, $fechaNacimientoPaciente, $fonoPaciente, $direccionPaciente, $idPrevisionPaciente, $nbrPrevisionPaciente);

	$options = array();
	while ($query->fetch()) {
		$options[] = array(
			'id' => $idPaciente,
			'rut' => $rutPaciente,
			'nombre' => $nombrePaciente,
			'fechan' => $fechaNacimientoPaciente,
			'fono' => $fonoPaciente,
			'direccion' => $direccionPaciente,
			'id_prevision' => $idPrevisionPaciente,
			'prevision' => $nbrPrevisionPaciente
		);
	}
	$query->close();
	echo json_encode($options);
	return;
}
