<?php
define('PERMITIDO', true);
$pagina = 0;
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
require_once("../lib/datos_mysql.php");
require_once('../assets/php/ssp.php');
header('Content-Type: text/html; charset=UTF-8');

$dbDetails = array(
  'host' => $hostname_conexionlab,
  'user' => $username_conexionlab,
  'pass' => $password_conexionlab,
  'db'   => $database_conexionlab,
  'charset' => 'utf8'
);

$table = <<<EOT
(
  SELECT a.ID_ATENCION, a.FECHA, DATE_FORMAT(a.FECHA, '%d/%m/%Y') AS FECHA_FORMATEADA,  a.ID_CLIENTE, a.CIERRE_ATE, a.FECHA_R, a.FECHA_TM, a.PARCIAL_R, a.FLAG_ELIMINADO,
  p.ID_PERSONA, p.NRO_RUT, CONCAT_WS('-', p.NRO_RUT, p.DV_RUT) AS RUT_PACIENTE, CONCAT_WS(' ', p.NOMBRES, p.APELLIDO_PATERNO, p.APELLIDO_MATERNO) AS NOMBRE_PACIENTE,
  cc.ID_CENTRO_CONTACTO, cc.NOMBRE, c.ID_EMPRESA, c.NBR, u.ID_USUARIO
  FROM atenciones a
  INNER JOIN personas p ON a.ID_CLIENTE = p.ID_PERSONA
  INNER JOIN centros_contacto cc ON a.ID_CENTRO_CONTACTO = cc.ID_CENTRO_CONTACTO
  LEFT JOIN empresas c ON a.ID_CONVENIO = c.ID_EMPRESA
  LEFT JOIN usuarios u ON u.ID_USUARIO = a.ID_USUARIO
  WHERE a.CIERRE_ATE = 'N' AND a.FLAG_ELIMINADO = 0 AND a.ID_CLIENTE != 61 
) temp
EOT;

// Table's primary key 
$primaryKey = 'ID_ATENCION';

// Array of database columns which should be read and sent back to DataTables. 
// The `db` parameter represents the column name in the database.  
// The `dt` parameter represents the DataTables column identifier. 
$columns = array(
  array('db' => 'ID_ATENCION', 'dt' => 0),
  array('db' => 'FECHA_FORMATEADA', 'dt' => 1),
  array('db' => 'NOMBRE', 'dt' => 2),
  array('db' => 'NBR', 'dt' => 3),
  array('db' => 'FECHA_TM', 'dt' => 4),
  array('db' => 'FECHA_R', 'dt' => 5),
  array(
    'db' => 'FECHA_TM',
    'dt' => 4,
    'formatter' => function ($d, $row) {
      $muestra_tomada = $d ? "<i class='fa-fw fa fa-check text-success'></i>" : "<span class='text-danger'><strong>No</strong></span>";
      return $muestra_tomada;
    }
  ),
  array(
    'db' => 'FECHA_R',
    'dt' => 5,
    'formatter' => function ($d, $row) {
      $recepcionado = $d ? "<i class='fa-fw fa fa-check text-success'></i>" : "<span class='text-danger'><strong>No</strong></span>";
      $recepcionado .= $row["PARCIAL_R"] == "S" ? "<a href='../o_tmrm/tm_rm_cod_barras.php?id_ate={$row["ID_ATENCION"]}' target='_blank'> <span class='label label-warning'>Parcial</span></a>" : "";
      return $recepcionado;
    }
  ),
  array('db' => 'RUT_PACIENTE', 'dt' => 6),
  array('db' => 'NOMBRE_PACIENTE', 'dt' => 7),
  array(
    'db' => 'ID_ATENCION',
    'dt' => 8,
    'formatter' => function ($d, $row) {
      return "<a class='btn btn-link' target='_blank' href='codigosBarraAtencion.php?idate=$d'><i class='fa fa-barcode fa-lg'></i></a>";
    }
  ),
  array(
    'db' => 'ID_ATENCION',
    'dt' => 9,
    'formatter' => function ($d, $row) {
      return "<a class='btn btn-link' href='e_atencion.php?idate=$d'><i class='fa fa-edit fa-lg'></i></a>";
    }
  ),
  array(
    'db' => 'PARCIAL_R',
    'dt' => 10,
    'formatter' => function ($d, $row) {
      return $d;
    }
  )
);

$filtros = "";
$f_desde = isset($_POST["f_desde"]) && $_POST["f_desde"] != "" ? " AND FECHA >= '{$_POST["f_desde"]}'"         : "";
$f_hasta = isset($_POST['f_hasta']) && $_POST['f_hasta'] != "" ? " AND FECHA <= '{$_POST['f_hasta']}'"         : "";
$id_ate  = isset($_POST['id_ate'])  && $_POST['id_ate']  != "" ? " AND ID_ATENCION = {$_POST['id_ate']}"       : "";
$id_cc   = isset($_POST['id_cc'])   && $_POST['id_cc']   != "" ? " AND ID_CENTRO_CONTACTO = {$_POST['id_cc']}" : "";
$id_con  = isset($_POST['id_con'])  && $_POST['id_con']  != "" ? " AND ID_EMPRESA = {$_POST['id_con']}"        : "";
$id_cli  = isset($_POST['id_cli'])  && $_POST['id_cli']  != "" ? " AND ID_CLIENTE = {$_POST['id_cli']}"        : "";
$id_usu  = isset($_POST['id_usu'])  && $_POST['id_usu']  != "" ? " AND ID_USUARIO = {$_POST['id_usu']}"        : "";
$rut  = isset($_POST['rut'])  && $_POST['rut']  != "" ? " AND NRO_RUT LIKE '%{$_POST['rut']}%'"        : "";

# Output data as json format 
// $a = SSP::simple(
//   $_POST,
//   $dbDetails,
//   $table,
//   $primaryKey,
//   $columns,
//   null,
//   "1 $f_desde
//   $f_hasta
//   $id_ate
//   $id_cc
//   $id_con
//   $id_cli
//   $id_usu"
// );

echo json_encode(
  SSP::simple(
    $_POST,
    $dbDetails,
    $table,
    $primaryKey,
    $columns,
    null,
    "1 $f_desde
    $f_hasta
    $id_ate
    $id_cc
    $id_con
    $id_cli
    $id_usu
    $rut"
  ),
  JSON_UNESCAPED_UNICODE
);
