<?php
$pagina = 7;
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
ob_start();
?>

<div class="modal-header">
  <button type="button" class="close" data-dismiss="modal" aria-hidden="true">
    &times;
  </button>
  <h4 class="modal-title" id="myModalLabel">Cambiar Médico</h4>
</div>

<div class="modal-body">
  <form id="cambiarMedico" class="smart-form" action="sql_cod.php" method="post">
    <section>
      <input class="select2" id="busquedaMED" name="id_medico" style="width: -webkit-fill-available;">
    </section>
    <input type="hidden" name="cambiarMedico" value="cambiarMedico">
    <input type="hidden" name="id_atencion" value="<?= $_GET['idat']; ?>">
  </form>
</div>

<div class="modal-footer">
  <button type="button" class="btn btn-default" data-dismiss="modal">
    Cancelar
  </button>
  <a class="btn btn-primary btn-sm pull-right btn-grabar">
    <i class="fa fa-save"></i> Grabar
  </a>
</div>

<script src="<?= ASSETS_URL ?>/js/plugin/rut/jquery.Rut.min.js"></script>

<script>
  $(document).ready(function() {
    $('.btn-grabar').on('click', function() {	
      $.post('sql_cod.php', $('#cambiarMedico').serialize(), function(data) {
        if (data.exito) {
          exito();
          location.reload();
        } else {
          error("Error: " + data.mensaje);
        }
      }, 'json');
    });

    $('#busquedaMED').select2({
      placeholder: "Buscar nombre o RUT de médico",
      minimumInputLength: 1,
      formatSearching: "Buscando...",
      formatNoMatches: "No se encontraron resultados",
      formatInputTooShort: function() {
        return 'Ingrese uno o mas caracteres';
      },
      ajax: { // instead of writing the function to execute the request we use Select2's convenient helper
        type: "POST",
        url: "../o_atenciones/ajax_MED.php",
        dataType: 'json',
        quietMillis: 100,
        data: function(term, page) {
          return {
            nombre_medico: term, // search term
          };
        },
        results: function(data) {
          return {
            results: $.map(data, function(item) {
              return {
                text: item.nombre_medico + " - " + item.especialidad,
                id: item.id_medico,
                especialidad: item.especialidad
              }
            })
          };
        },
        cache: true
      },
      escapeMarkup: function(m) {
        return m;
      } // we do not want to escape markup since we are displaying html in results
    });
  });
</script>