<?php 
define('PERMITIDO', true);
$pagina = 1;
include('../pdfClasses/class.ezpdf.php');
require_once("../inc/init.php");
require_once('../lib/valido.php');
require_once('../lib/util.php');
require_once('../lib/connection.php');
require_once("../lib/config.php");
require_once('../Connections/conexionlab.php'); 

$pdf = new Cezpdf('LETTER');
$pdf->selectFont('../pdfClasses/fonts/Helvetica.afm');
$pdf->ezSetCmMargins(2, 1, 1, 1);
#fecha en formato español soportada por servidor
date_default_timezone_set('America/Santiago');
$dias = array("Domingo", "Lunes", "Martes", "Miercoles", "Jueves", "Viernes", "Sábado");
$meses = array("Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre");
$fecha = $dias[date('w')] . " " . date('d') . " de " . $meses[date('n') - 1] . " del " . date('Y');

$qNombreLab = $mysqli->prepare("SELECT VALOR FROM parametros_sistema WHERE DESCRIPCION_PS = 'NOMBRE LABORATORIO'");
$qNombreLab->execute();
$qNombreLab->bind_result($nombre_laboratorio);
$qNombreLab->store_result();
$qNombreLab->fetch();
$qNombreLab->close();

$id_atencion = $_GET['idate'];
$qAtencion = $mysqli->prepare("SELECT CONCAT_WS(' ', p.NOMBRES, p.APELLIDO_PATERNO, p.APELLIDO_MATERNO), p.NRO_RUT, p.DV_RUT,
CONCAT_WS(' ', m.NOMBRES, m.APELLIDO_PATERNO, m.APELLIDO_MATERNO)
FROM atenciones a
LEFT JOIN personas p ON a.ID_CLIENTE = p.ID_PERSONA  
LEFT JOIN personas m ON a.ID_MEDICO = m.ID_PERSONA   
LEFT JOIN empresas ON a.ID_PREVISION = empresas.ID_EMPRESA
LEFT JOIN centros_contacto ON a.ID_CENTRO_CONTACTO = centros_contacto.ID_CENTRO_CONTACTO 
LEFT JOIN codigos_generales ON a.COD_DIAGNOSTICO = codigos_generales.CODIGO 
WHERE a.ID_ATENCION = ? AND codigos_generales.COD_TABLA = 'SIS_DIAGNO'");
$qAtencion->bind_param("i", $id_atencion);
$qAtencion->execute();
$qAtencion->bind_result($nombre_paciente, $nro_rut, $dv_rut, $nombre_medico);
$qAtencion->store_result();
$qAtencion->fetch();
$qAtencion->close();

$txttit2 = "\nConsentimiento";
$txttit3 = "\nQuien suscribe, ";
$txttit4 = " autoriza al $nombre_laboratorio para que ponga a disposición del DR(a): ";
$txttit5 = " los resultados de los exámenes solicitados a través de medios electrónicos tal como el envío de correo electrónico o a través de la página web. El Laboratorio Clínico se compromete a disponer de los mecanismos de seguridad para mantener la confidencialidad de la información de manera que sólo sea conocida por el médico tratante.";

$paciente = $nombre_paciente;
$medico = $nombre_medico;
$rut = number_format($nro_rut, 0, ',', '.');
$RUTDV = $rut . "-" . $dv_rut;

$pdf->ezText("\nAtención n°: " . $id_atencion, 10, array('justification' => 'right'));
$pdf->ezText($nombre_laboratorio, 14);
$pdf->ezText($txttit2, 13, array('justification' => 'centre'));
$pdf->ezText($txttit3 . $paciente . " Rut: " . $RUTDV . $txttit4 . $medico . $txttit5, 11, array('justification' => 'full'));
$pdf->ezText("\n\nViña del Mar, " . $fecha . "\n\n\n\n\n", 10, array('justification' => 'left'));
$pdf->ezText($paciente, 12, array('justification' => 'centre'));
$pdf->ezText($RUTDV, 12, array('justification' => 'centre'));

$pdf->ezStream();