<?php
define('PERMITIDO', true);
$pantalla_actual = 'MOD_ATE';
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

function httpPost($url, $data)
{
  $curl = curl_init($url);
  curl_setopt($curl, CURLOPT_POST, true);
  curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($data));
  curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
  $response = curl_exec($curl);
  curl_close($curl);
  return $response;
}

$idAtencion = isset($_GET['idate']) ? $_GET['idate'] : "-1";
$qAtencion = $mysqli->prepare("SELECT a.FECHA, a.HORA, a.FECHA_ULT_REGLA, a.MONTO_ATENCION, a.MONTO_DESCUENTO, a.PCTJE_DESCUENTO, a.MONTO_CONVENIO, a.ID_CLIENTE, a.ID_MEDICO,
a.ID_PREVISION, a.ID_CONVENIO, a.NIVEL_URGENCIA, a.MOTIVO_PRIORIZACION, a.TURNO_DIALISIS, a.OBS, a.FECHA_INF, a.FLAG_ACEPTA_C, a.ID_CENTRO_CONTACTO, a.COD_DIAGNOSTICO,
p.NRO_RUT, CONCAT_WS('-', p.NRO_RUT, p.DV_RUT), CONCAT_WS(' ', p.NOMBRES, p.APELLIDO_PATERNO, p.APELLIDO_MATERNO), DATE_FORMAT(p.FECHA_NACIMIENTO, '%d-%m-%Y'), p.DIRECCION, p.FONO_1, p.GENERO, p.PASAPORTE,
ep.NOMBRE_E, CONCAT_WS(' ', m.NOMBRES, m.APELLIDO_PATERNO, m.APELLIDO_MATERNO), cg.DESCRIPCION_CG,
ea.NOMBRE_E, CONCAT_WS(' ', u.NOMBRES, u.APELLIDO_PATERNO, u.APELLIDO_MATERNO), a.FLAG_ELIMINADO
FROM atenciones a
INNER JOIN personas p ON p.ID_PERSONA = a.ID_CLIENTE
LEFT JOIN personas m ON m.ID_PERSONA = a.ID_MEDICO
LEFT JOIN empresas ep ON ep.ID_EMPRESA = p.ID_PREVISION
LEFT JOIN empresas ea ON ea.ID_EMPRESA = a.ID_PREVISION
LEFT JOIN usuarios u ON u.ID_USUARIO = a.ID_USUARIO
LEFT JOIN codigos_generales cg ON cg.CODIGO = m.ESPECIALIDAD AND cg.COD_TABLA = 'SIS_ESPECI'
WHERE a.ID_ATENCION = ?");
$qAtencion->bind_param('i', $idAtencion);
$qAtencion->execute();
$qAtencion->bind_result(
  $ate_fecha,
  $ate_hora,
  $ate_fechaUltimaRegla,
  $ate_montoAtencion,
  $ate_montoDescuento,
  $ate_porcentajeDescuento,
  $ate_montoConvenio,
  $ate_idPacienteAtencion,
  $ate_idMedicoAtencion,
  $ate_idPrevisionAtencion,
  $ate_idConvenioAtencion,
  $ate_nivelUrgenciaAtencion,
  $ate_motivoPriorizacionAtencion,
  $ate_turnoDialisisAtencion,
  $ate_obs,
  $ate_fechaInf,
  $ate_flagAceptaC,
  $ate_idCentroContacto,
  $ate_codDiagnostico,
  $ate_nroRut,
  $ate_rut,
  $ate_nombrePaciente,
  $ate_fechaNacimiento,
  $ate_direccionPaciente,
  $ate_fonoPaciente,
  $ate_generoPaciente,
  $ate_pasaportePaciente,
  $ate_nombrePrevisionPaciente,
  $ate_nombreMedico,
  $ate_especialidadMedico,
  $ate_nombrePrevisionAtencion,
  $ate_usuarioCreadorAtencion,
  $ate_flagEliminado
);
$qAtencion->store_result();
$totalRows = $qAtencion->num_rows;
$qAtencion->fetch();
$qAtencion->close();

$options_ccto = "";
$qOptionsCentroContacto = $mysqli->prepare("SELECT ID_CENTRO_CONTACTO, NOMBRE, FLAG_DIALISIS FROM centros_contacto");
$qOptionsCentroContacto->execute();
$qOptionsCentroContacto->bind_result($idCentroContacto, $nombreCentroContacto, $flagDialisis);
$qOptionsCentroContacto->store_result();
while ($qOptionsCentroContacto->fetch()) {
  $selected = $ate_idCentroContacto == $idCentroContacto ? "selected" : "";
  $options_ccto .= "<option value='$idCentroContacto' data-dialisis='$flagDialisis' $selected> $nombreCentroContacto </option>";
}
$qOptionsCentroContacto->close();

$options_diagnostico = "";
$qOptionsDiagnostico = $mysqli->prepare("SELECT CODIGO, DESCRIPCION_CG FROM codigos_generales WHERE COD_TABLA = 'SIS_DIAGNO'");
$qOptionsDiagnostico->execute();
$qOptionsDiagnostico->bind_result($codigoDiagnostico, $descripcionDiagnostico);
$qOptionsDiagnostico->store_result();
while ($qOptionsDiagnostico->fetch()) {
  $selected = $ate_codDiagnostico == $codigoDiagnostico ? "selected" : "";
  $options_diagnostico .= "<option value='$codigoDiagnostico' $selected> $descripcionDiagnostico </option>";
}
$qOptionsDiagnostico->close();

$options_convenio = "";
$qOptionsConvenio = $mysqli->prepare("SELECT ID_EMPRESA, NBR FROM empresas WHERE FLAG_CONVENIO = 'S'");
$qOptionsConvenio->execute();
$qOptionsConvenio->bind_result($idConvenio, $nbrConvenio);
$qOptionsConvenio->store_result();
while ($qOptionsConvenio->fetch()) {
  $selected = $ate_idConvenioAtencion == $idConvenio ? "selected" : "";
  $options_convenio .= "<option value='$idConvenio' $selected> $nbrConvenio </option>";
}
$qOptionsConvenio->close();

// $options_convenio = optionsConvenio($ate_idConvenioAtencion);
$options_prevision = optionsPrevision(null);

$options_motivosPriorizacion = optionsCodigosG("SIS_MOTPRIO", $ate_motivoPriorizacionAtencion);

$options_nivelUrgencia = "";
$qOptionsNivelUrgencia = $mysqli->prepare("SELECT CODIGO, DESCRIPCION_CG FROM codigos_generales WHERE COD_TABLA = 'SIS_NIVURG'");
$qOptionsNivelUrgencia->execute();
$qOptionsNivelUrgencia->bind_result($codigoNivelUrgencia, $descripcionNivelUrgencia);
$qOptionsNivelUrgencia->store_result();
while ($qOptionsNivelUrgencia->fetch()) {
  $selected = $ate_nivelUrgenciaAtencion == $codigoNivelUrgencia ? "selected" : "";
  $options_nivelUrgencia .= "<option value='$codigoNivelUrgencia' $selected> $descripcionNivelUrgencia </option>";
}
$qOptionsNivelUrgencia->close();

$options_turnosDialisis = "";
$qOptionsTurnosDialisis = $mysqli->prepare("SELECT CODIGO, DESCRIPCION_CG FROM codigos_generales WHERE COD_TABLA = 'SIS_TURDIA'");
$qOptionsTurnosDialisis->execute();
$qOptionsTurnosDialisis->bind_result($codigoTurnoDialisis, $descripcionTurnoDialisis);
$qOptionsTurnosDialisis->store_result();
while ($qOptionsTurnosDialisis->fetch()) {
  $selected = $ate_turnoDialisisAtencion == $codigoTurnoDialisis ? "selected" : "";
  $options_turnosDialisis .= "<option value='$codigoTurnoDialisis' $selected> $descripcionTurnoDialisis </option>";
}
$qOptionsTurnosDialisis->close();

# suma de precios de los examenes de la atención (monto total)
$montoTotal = 0;
$qMontoAtencion = $mysqli->prepare("SELECT SUM(PRECIO_EXAMEN)
FROM examenes_atenciones
WHERE ID_ATENCION = ?");
$qMontoAtencion->bind_param('i', $idAtencion);
$qMontoAtencion->execute();
$qMontoAtencion->bind_result($sum_precioExamen);
$qMontoAtencion->fetch();
$montoTotal = $sum_precioExamen;
$qMontoAtencion->close();

$buscar = array(chr(13) . chr(10), "\r\n", "\n", "\r");
$reemplazar = array("", "", "", "");
$ate_direccionPaciente = str_ireplace($buscar, $reemplazar, $ate_direccionPaciente);

# boletas de la atenciones
$qAtencionesDTE = $mysqli->prepare("SELECT ad.FOLIO, ad.TIPO_DTE, ad.RUT_EMISOR, CONCAT_WS(' ', u.NOMBRES, u.APELLIDO_PATERNO, u.APELLIDO_MATERNO), DATE_FORMAT(ad.FECHA_EMISION, '%d-%m-%Y %H:%i')
FROM atenciones_dte ad
LEFT JOIN usuarios u ON u.ID_USUARIO = ad.ID_USUARIO_EMISOR
WHERE ad.ID_ATENCION = ? ORDER BY ad.FOLIO");
$qAtencionesDTE->bind_param('i', $idAtencion);
$qAtencionesDTE->execute();
$qAtencionesDTE->bind_result($ad_folio, $ad_tipoDte, $ad_rutEmisor, $ad_nombreEmisor, $ad_fechaEmision);
$boletas = '';
while ($qAtencionesDTE->fetch()) {
  $respuesta = json_decode(httpPost("https://fe.ripit.cl/ventas/api/api_lims.php", array("folio_anulado" => "true", "folio" => "$ad_folio", "cod_empresa" => $codEmpresaSistemaVentas)));
  $ad_nombreEmisor = $ad_nombreEmisor ? $ad_nombreEmisor : "No hay registro";
  $ad_fechaEmision = $ad_fechaEmision ? $ad_fechaEmision : "No hay registro";
  $estado = $respuesta->exito ? "Anulado" : "Vigente";
  $color = $respuesta->exito ? "red" : "green";
  $boletas .= "
  <a style='padding:5px;' target='_blank' class='btn btn-link' href='$urlDescargarDte&folio=$ad_folio&tipo_dte=$ad_tipoDte&rut_emisor=$ad_rutEmisor'>
    <i class='fa fa-lg fa-file-pdf-o txt-color-$color' title='Folio: $ad_folio\nEmitida por: $ad_nombreEmisor\nFecha: $ad_fechaEmision\nEstado: $estado'></i>
  </a>";
}
$qAtencionesDTE->close();

# orden médica
$qOrdenMedicaAtencion = $mysqli->prepare("SELECT
CASE
  WHEN FLAG_HISTORICO = 1 THEN CONCAT('$urlArchivosHistoricos', URL)
  ELSE 												 CONCAT('$urlArchivos', URL)
END
FROM archivos_atenciones
WHERE ID_ATENCION = ? AND TIPO = 'ORDEN_MEDICA' ORDER BY FECHA DESC LIMIT 1");
$qOrdenMedicaAtencion->bind_param('s', $_GET['idate']);
$qOrdenMedicaAtencion->execute();
$qOrdenMedicaAtencion->bind_result($ordenMedica);
$qOrdenMedicaAtencion->store_result();
$qOrdenMedicaAtencion->fetch();
$qOrdenMedicaAtencion->close();

# consulta de exámenes de la atención
$qExamenesAtencion = $mysqli->prepare("SELECT IFNULL(ex.COD_FONASA, ea.COD_EXAMEN), ea.PRECIO_EXAMEN, ex.NOMBRE
FROM examenes_atenciones ea
INNER JOIN examenes ex ON ea.COD_EXAMEN=ex.COD_INTERNO
WHERE ea.ID_ATENCION = ? AND ea.F_HIJO IS NULL AND (ea.PREV = 0 OR ea.PREV = 37)");
$qExamenesAtencion->bind_param('i', $idAtencion);
$qExamenesAtencion->execute();
$qExamenesAtencion->bind_result($ea_codExamen, $ea_precio, $ea_nombre);
$arrayExAt = [];
while ($qExamenesAtencion->fetch()) {
  $arrayExAt[] = array(
    'nombre' => $ea_codExamen,
    'descripcion' => $ea_nombre,
    'cantidad' => '1',
    'precio_unitario' => $ea_precio,
    'porc_descuento' => '0',
    'monto_descuento' => '0',
    'monto' => $ea_precio,
    'id_detalle_venta' => ''
  );
}
$qExamenesAtencion->close();

# codigos de barra
$qCodBarra = $mysqli->prepare("SELECT ea.TIPO_TUBO, cg.DESCRIPCION_CG AS TIPTUB
FROM examenes_atenciones ea
INNER JOIN examenes e ON ea.COD_EXAMEN = e.COD_INTERNO
LEFT JOIN codigos_generales cg ON ea.TIPO_TUBO = cg.CODIGO
WHERE ID_ATENCION = ? AND cg.COD_TABLA='SIS_TIPTUB' AND ea.TIPO_TUBO != '17'
GROUP BY ea.TIPO_TUBO");
$qCodBarra->bind_param('i', $idAtencion);
$qCodBarra->execute();
$qCodBarra->bind_result($cb_codTipoTubo, $cb_tipoTubo);
$MenuImpresion = '<div class="btn-group">
					<a class="btn btn-default btn-sm" href="javascript:void(0);">Códigos de Barra</a>
					<a class="btn btn-default dropdown-toggle btn-sm" data-toggle="dropdown" href="javascript:void(0);" aria-expanded="false"><span class="caret"></span></a>
					<ul class="dropdown-menu">
					<li>
						<a href="codigosBarraAtencion.php?idate=' . $idAtencion . '" title="Imprimir Todos" target="_blank">Todos</a>
					</li>';
while ($qCodBarra->fetch()) {
  $MenuImpresion .= '
  <li>
    <a href="codigosBarraAtencion.php?idate=' . $idAtencion . '&idtb=' . $cb_codTipoTubo . '" title="Imprimir ' . $cb_tipoTubo . '" target="_blank">' . $cb_tipoTubo . '</a>
  </li>';
}
$qCodBarra->close();
$MenuImpresion .= '
  </ul>
</div>';

$idemp = $ate_idConvenioAtencion != 0 ? $ate_idConvenioAtencion : $ate_idPrevisionAtencion; # el convenio (de la atención) tiene mayor prioridad que la previsión (de la atención)

$pacienteExtranjero = ($ate_pasaportePaciente != "" && (substr($ate_nroRut, 0, 2) == "99" && strlen($ate_nroRut) == 8)) ? "S" : "N";
$datos_venta = "c_razon_social: " . json_encode($ate_nombrePaciente) . ", c_direccion: '" . addslashes($ate_direccionPaciente) . "', c_rut: '$ate_rut'";
$url_asociar_dte = urlencode("https://" . $_SERVER['SERVER_NAME'] . "/$carpetaProyecto/api_fact/asociar_dte.php?idat=$idAtencion");
ob_start();
?>

<h4><b>Atención Número: <?= $idAtencion ?></b></h4>
<div class="well well-sm bg-color-blue txt-color-white text-left" style="margin-top:5px">
  <div class="row">
    <div class="col-md-3">
      Paciente:<br />
      <?= $ate_nombrePaciente ?>
    </div>
    <div class="col-md-2">
      Previsión del Paciente: <br />
      <?= $ate_nombrePrevisionPaciente; ?>
    </div>
    <div class="col-md-1">
      F. Nacimiento:<br />
      <?= $ate_fechaNacimiento; ?>
    </div>
    <div class="col-md-1">
      Fono:<br />
      <?= $ate_fonoPaciente; ?>
    </div>
    <div class="col-md-3">
      Dirección: <br />
      <?= $ate_direccionPaciente; ?>
    </div>
    <div class="col-md-1">
      <a data-toggle="modal" href="c_paciente.php?id=<?= $ate_idPacienteAtencion . '&idat=' . $idAtencion; ?>" class="btn btn-default btn-sm" data-target="#myModalCambiarP" title="Cambiar Paciente"><i class="fa fa-list"></i>Cambiar</a>
    </div>
    <div class="col-md-1">
      <a data-toggle="modal" href="../m_personas/e_persona.php?id=<?= $ate_idPacienteAtencion . '&idat=' . $idAtencion; ?>" class="btn btn-default btn-sm" data-target="#myModalEditP" title="Modificar registro"><i class="fa fa-edit"></i>Editar</a>
    </div>
  </div>
</div>

<div class="well well-sm bg-color-blueLight txt-color-white text-left" style="margin-top:10px">
  <div class="row">
    <div class="col-md-3">
      Nombre Médico: <br />
      <?= $ate_nombreMedico ?>
    </div>
    <div class="col-md-4">
      Especialidad: <br />
      <?= $ate_especialidadMedico ?>
    </div>
    <div class="col-md-3">
    </div>
    <div class="col-md-1">
      <?php if ($ate_idMedicoAtencion != '') { ?>
        <a data-toggle="modal" href="c_medico.php?id=<?= $ate_idMedicoAtencion . '&idat=' . $idAtencion; ?>" class="btn btn-default btn-sm" data-target="#myModalCambiarM" title="Cambiar Médico"><i class="fa fa-list"></i>Cambiar</a>
      <?php } ?>
    </div>
    <div class="col-md-1">
      <a data-toggle="modal" href="../m_personas/e_persona.php?id=<?= $ate_idMedicoAtencion . '&idat=' . $idAtencion; ?>" class="btn btn-default btn-sm" data-target="#myModalEditM" title="Modificar registro"><i class="fa fa-edit"></i>Editar</a>
    </div>
  </div>
</div>

<?php if ($totalRows > 0) { ?>
  <?php if (in_array($usuario_perfil, ["ADMINISTRADOR", "SUPERVISOR"])) { ?>
    <div class="row">
      <br>
      <div class="col-md-4">
        <select id="ID_NUEVA_PREVISION" name="ID_NUEVA_PREVISION" class="select2" style="width:100%">
          <?= $options_prevision ?>
        </select>
      </div>
      <div class="col-md-3">
        <a class="btn btn-sm btn-warning btn-cambiarPrevisionAtencion" data-id="<?= $idAtencion ?>"><i class="fa fa-edit"></i> Cambiar Previsión de Atención </a>
      </div>
    </div>
  <?php } ?>
  <form action="sql_cod.php" method="post" id="formModificarAtencion" name="formModificarAtencion" class="smart-form" style="margin-top:10px">
    <table class="table table-bordered">
      <tbody>
        <tr>
          <td>Previsión de la Atención:</td>
          <td>  
            <?= $ate_nombrePrevisionAtencion ?>
          </td>
          <td colspan="2">
            <?= $boletas ?>
            <a class="btn btn-sm btn-success btn-generarBoleta" target="_blank"><i class="fa fa-plus"></i> Boleta electrónica </a>
            <!-- <a class="btn btn-sm btn-success <?= $usuario_id != 0 ? "hidden" : "" ?>" data-toggle="modal" href="md_generarBoleta.php?idAtencion=<?= $idAtencion ?>" data-target="#md_generarBoleta"> <i class="fa fa-plus"></i> Generar boleta electrónica </a> -->
            <a href="../c_pagos/d_pagos.php?idate=<?= $idAtencion ?>" class="btn btn-sm btn-success pull-right" style="margin-left:15px;"><i class="fa fa-money"></i> Detalle de pagos</a>
          </td>
        </tr>
        <tr>
          <td width="130">Fecha:</td>
          <td width="250">
            <label class="input">
              <input type="date" class="input-sm" name="FECHA" value="<?= $ate_fecha ?>" />
            </label>
          </td>
          <td width="130">Pre Diagnóstico:</td>
          <td width="250">
            <label class="select">
              <select name="COD_DIAGNOSTICO" class="input-sm">
                <?= $options_diagnostico ?>
              </select> <i></i>
            </label>
          </td>
        </tr>
        <tr>
          <td>Toma de Muestra:</td>
          <td>
            <label class="select">
              <select id="ID_CENTRO_CONTACTO" name="ID_CENTRO_CONTACTO" class="input-sm">
                <?= $options_ccto; ?>
              </select> <i></i>
            </label>
          </td>
          <td>Turno Diálisis: </td>
          <td>
            <label class="select">
              <select id="ID_TURDIA" name="ID_TURDIA" class="input-sm" disabled>
                <option value="0" <?php if ($ate_turnoDialisisAtencion == 0) echo "selected" ?>>-</option>
                <?= $options_turnosDialisis ?>
              </select> <i></i>
            </label>
          </td>
        </tr>
        <tr>
          <td>Motivo de Priorización de Atención:</td>
          <td>
            <label class="select">
              <select name="MOTIVO_PRIORIZACION" class="input-sm">
                <?= $options_motivosPriorizacion ?>
              </select> <i></i>
            </label>
          </td>
          <td>Urgencia:</td>
          <td>
            <label class="select">
              <select name="NIVEL_URGENCIA" class="input-sm">
                <?= $options_nivelUrgencia ?>
              </select> <i></i>
            </label>
          </td>
        </tr>
        <tr>
          <td>Consentimiento Revisión Médico: </td>
          <td>
            <label class="checkbox">
              <input name="FLAG_ACEPTA_C" type="checkbox" id="FLAG_ACEPTA_C" value="1" <?php if ($ate_flagAceptaC == 1) echo "checked"; ?> />
              <i></i>
            </label>
            <?php if ($ate_flagAceptaC == 1) echo "<a href='consent_pac_med_PDF.php?idate=$idAtencion' target='_blank' title='Ver Consentimiento' class='btn btn-link pull-right'><i class='fa fa-file-pdf-o fa-lg txt-color-red'></i> Consentimiento</a>"; ?>
          </td>
          <td>Última Regla:</td>
          <td>
            <label class="input">
              <input name="FECHA_ULT_REGLA" type="date" class="input-sm" value="<?= $ate_fechaUltimaRegla ?>" />
            </label>
          </td>
        </tr>
        <tr>
          <td>Convenio:</td>
          <td>
            <label class="select">
              <select id="ID_CONVENIO" name="ID_CONVENIO" class="input-sm">
                <option value="0" <?php if ($ate_idConvenioAtencion == 0) echo "selected" ?>>-</option>
                <?= $options_convenio ?>
              </select> <i></i>
            </label>
          </td>
          <td>Monto a cobrar a Convenio ($): </td>
          <td>
            <label class="input">
              <input type="text" id="MONTO_CONVENIO" name="MONTO_CONVENIO" value="<?= $ate_montoConvenio ?>" class="input-sm" required="required" min="0" />
            </label>
          </td>
        </tr>
        <tr>
          <td>Descuento/Copago ($): </td>
          <td>
            <label class="input">
              <input type="text" name="MONTO_DESCUENTO" class="input-sm" value="<?= $ate_montoDescuento ?>" size="20" required="required" min="0" />
            </label>
          </td>
          <td>Descuento (%): </td>
          <td>
            <label class="input">
              <input type="text" name="PCTJE_DESCUENTO" class="input-sm" value="<?= $ate_porcentajeDescuento ?>" required min="0" />
            </label>
          </td>
        </tr>
        <tr>
          <td>Monto Atención ($): </td>
          <td>
            <label class="input">
              <input name="MONTO_ATENCION" type="text" class="input-sm" value="<?= $montoTotal ?>" readonly required />
            </label>
          </td>
          <td>Orden Médica:</td>
          <td>
            <?php if ($ordenMedica != null) echo "<a href='$ordenMedica' target='_blank' title='Ver Orden Médica' class='btn btn-link'><i class='fa fa-file-pdf-o fa-lg txt-color-green'></i> Orden Médica</a>"; ?>
          </td>
        </tr>
        <tr>
          <td>Observaciones:</td>
          <td colspan="3">
            <label class="textarea textarea-resizable">
              <textarea name="OBS" class="custom-scroll" cols="40" rows="2"><?= $ate_obs ?></textarea>
            </label>
          </td>
        </tr>
        <input type="hidden" name="MM_update" value="formModificarAtencion" />
        <input type="hidden" name="ID_ATENCION" value="<?= $idAtencion; ?>" />
      </tbody>
    </table>
  </form>

  <div class="row" style="margin-top:10px">
    <div class="col-md-6">
      <?php if (in_array($usuario_perfil, ["ADMINISTRADOR", "SUPERVISOR"])) { ?>
        <a class="btn btn-sm btn-danger <?php if ($ate_flagEliminado == 1) echo "hidden" ?>" data-toggle="modal" href="md_eliminarAtencion.php?idAtencion=<?= $idAtencion ?>" data-target="#md_eliminarAtencion">
          <i class="fa fa-lg fa-trash-o"></i> Eliminar Atención
        </a>
        <a class="btn btn-sm btn-success btn-restaurarAtencion <?php if ($ate_flagEliminado == 0 || 1 == 1) echo "hidden" ?>" data-id="<?= $idAtencion ?>">
          Restaurar Atención
        </a>
      <?php } ?>
    </div>
    <div class="col-md-6  ">
      <a class="btn btn-sm btn-primary btn-grabarAtencion pull-right" data-form="#formModificarAtencion"><i class="fa fa-save"></i> Grabar Cambios</a>
    </div>
  </div>
  <div class="row">
    <div class="col-md-12">
      <div class="note pull-right"> ATENCIÓN CREADA POR: <?= $ate_usuarioCreadorAtencion ?> </div>
    </div>
  </div>
<?php } ?>

<!-- para md_comprobantes -->
<input type="hidden" id="idAtencion" value="<?= $idAtencion ?>" />
<input type="hidden" id="idemp" value="<?= $idemp ?>" />
<input type="hidden" id="ate_porcentajeDescuento" value="<?= $ate_porcentajeDescuento ?>" />

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title'],
  "icon" => 'fa fa-cog',
  'toolbar' => array(
    array(
      "id" => "toolbar-id",
      "content" => $MenuImpresion,
      "class" => 'smart-form'
    ), array(
      "id" => "toolbar-id",
      "content" => '<a onclick="popup(\'../Diagnosticos/mostrar_diag.php?idpa=' . $ate_idPacienteAtencion . '&idate=' . $idAtencion . '\')">Diagnósticos</a>',
      "class" => 'smart-form'
    ),
    array(
      "id" => "toolbar-id",
      "content" => '<a onclick="popup(\'../medicamentos_atencion/medica.php?idate=' . $idAtencion . '\')">Medicamentos</a>',
      "class" => 'smart-form'
    ),
    array(
      "id" => "toolbar-id",
      "content" => "<a data-toggle='modal' href='md_comprobantes.php?idate='$idAtencion' data-target='#md_comprobantes'>Comprobantes e Instructivos</a>",
      "class" => 'smart-form'
    ),
    array(
      "id" => "toolbar-id",
      "content" => '<a onclick="popup(\'toma_muestra.php?idate=' . $idAtencion . '\')">Toma de Muestras</a>',
      "class" => 'smart-form'
    ),
    array(
      "id" => "toolbar-id",
      "content" => "<a data-toggle='modal' href='md_examenesAtencion.php?idate=$idAtencion&idemp=$idemp&g=$ate_generoPaciente&idcc=$ate_idCentroContacto' data-target='#md_examenesAtencion'>Exámenes</a>",
      "class" => 'smart-form'
    )
  )
);

$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php
  include("../inc/ribbon.php");
  ?>

  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>

  <!-- MODALS  -->
  <div class="modal fade Edit" id="myModalEditP" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content" style="width:120%">
      </div>
    </div>
  </div>

  <div class="modal fade Edit" id="myModalCambiarP" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content" style="width:120%">
      </div>
    </div>
  </div>

  <div class="modal fade Edit" id="myModalEditM" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content" style="width:120%">
      </div>
    </div>
  </div>

  <div class="modal fade Edit" id="myModalCambiarM" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content" style="width:120%">
      </div>
    </div>
  </div>

  <div class="modal fade Edit" id="md_examenesAtencion" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content" style="width:140%">
      </div>
    </div>
  </div>

  <div class="modal fade Edit" id="md_comprobantes" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content" style="width:120%">
      </div>
    </div>
  </div>

  <div class="modal fade Edit" id="md_generarBoleta" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
      </div>
    </div>
  </div>

  <div class="modal fade Edit" id="md_eliminarAtencion" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
      </div>
    </div>
  </div>
</div>

<?php include("../inc/footer.php"); ?>
<?php include("../inc/scripts.php"); ?>

<script>
  $(document).ready(function() {
    $(".btn-grabarAtencion").on("click", function() {
      $(this).attr('disabled', 'disabled'); // $(this).prop('disabled', true);
      var form = $(this).data('form');
      var generoPaciente = "<?= $ate_generoPaciente ?>";
      if (generoPaciente == "WARD") {
        if (confirm("¿Seguro desea grabar la atención sin ingresar la fecha de la última regla?")) {
          $.post($(form).attr('action'), $(form).serialize(), function(data) {
            if (data.exito) {
              exito();
              location.reload();
            } else {
              $(this).removeAttr('disabled'); // $(this)("disabled", false);
              error(data.mensaje);
            }
          }, 'json');
        }
      } else {
        $.post($(form).attr('action'), $(form).serialize(), function(data) {
          if (data.exito) {
            exito();
            location.reload();
          } else {
            $(this).removeAttr('disabled'); // $(this)("disabled", false);
            error(data.mensaje);
          }
        }, 'json');

      }
    });

    $(".btn-restaurarAtencion").on("click", function() {
      if (confirm("¿Desea restaurar la atención?")) {
        var id = $(this).data("id");
        $.post("sql_cod.php", {
          restaurarAtencion: 1,
          idAtencion: id,
        }, function(data) {
          if (data.exito) {
            exito();
            location.reload();
          } else {
            error(data.mensaje);
          }
        }, 'json');
      }
    });

    $(".btn-cambiarPrevisionAtencion").on("click", function() {
      if (confirm("¿Desea cambiar la previsión la atención?\nEsto cambiará el precio de todos los exámenes y el monto total de la atención")) {
        var id = $(this).data("id");
        $.post("sql_cod.php", {
          modificarPrevisionAtencion: 1,
          id_atencion: id,
          id_prevision: $('select[name="ID_NUEVA_PREVISION"]').val()
        }, function(data) {
          if (data.exito) {
            exito();
            location.reload();
          } else {
            error(data.mensaje);
          }
        }, 'json');
      }
    });

    var dialisis = $('#ID_CENTRO_CONTACTO option:selected').attr('data-dialisis');
    if (dialisis == 'S') {
      $('#ID_TURDIA').removeAttr('disabled');
    } else {
      $('#ID_TURDIA').attr('disabled', 'disabled');
    }

    $('#ID_CENTRO_CONTACTO').on('change', function() {
      var dialisis = $('#ID_CENTRO_CONTACTO option:selected').attr('data-dialisis');
      if (dialisis == 'S') {
        $('#ID_TURDIA').removeAttr('disabled');
      } else {
        $('#ID_TURDIA').attr('disabled', 'disabled');
      }
      $('#ID_TURDIA').val('0');
    });

    if ($('#ID_CONVENIO').val() != 0) $('#MONTO_CONVENIO').removeAttr('disabled');
    else $('#MONTO_CONVENIO').attr('disabled', 'disabled');

    $('#ID_CONVENIO').on('change', function() {
      if ($(this).val() != 0)
        $('#MONTO_CONVENIO').removeAttr('disabled');
      else {
        $('#MONTO_CONVENIO').attr('disabled', 'disabled');
        $('#MONTO_CONVENIO').val(0);
      }
    });

    $('.btn-generarBoleta').on('click', function() {
      var detalle = <?= json_encode($arrayExAt) ?>;
      // console.log(detalle);
      rut = '<?= $ate_rut ?>';
      // if(!validarRut(rut)) {
      //   alert('El rut del paciente no es válido, debe ser modificado.');
      //   return false;
      // }
      if (confirm("¿Desea generar boleta para esta atención?")) {
        $(this).addClass('disabled');
        var id = $(this).data('id');
        var ext = '<?= $pacienteExtranjero ?>';
        var urlVentasSqlCod = '<?= $urlVentasSqlCod ?>'; // ventas/sql_cod.php
        $.post(urlVentasSqlCod, {
          formUpdateVenta: 1,
          cod_empresa: '<?= $codEmpresaSistemaVentas ?>',
          monto_neto: 0,
          tasa_iva: 19,
          monto_exento: 0,
          detalle: detalle,
          <?= $datos_venta ?>,
          tipo_dte: '<?= $cliente_dtePorDefecto ?>'
        }, function(data) {
          if (data.exito) {
            exito();
            var idv = data.idv;
            var ide = data.ide;
            var idu = '<?= $usuario_id ?>';
            var url = '<?= $url_asociar_dte ?>';
            var urlDetalleVenta = '<?= $urlDetalleVenta ?>?id_venta=' + idv + '&id_empresa=' + ide + '&id_usuario_lims=' + idu + '&ext=' + ext + '&url=' + url; // ventas/n_detalles_venta.php
            popup(urlDetalleVenta);
          } else {
            error(data.mensaje);
          }
        }, 'json');
        $(this).removeClass('disabled');
      }
    });
  });

  function validarRut(rut) {
    var valor = rut.replace('.', ''); // Despejar Puntos
    valor = valor.replace('-', ''); // Despejar Guión
    cuerpo = valor.slice(0, -1); // Aislar Cuerpo y Dígito Verificador
    dv = valor.slice(-1).toUpperCase(); // Se guarda solo el DV
    rut = cuerpo + '-' + dv // Formatear RUN
    if (cuerpo.length < 7) return false; // Si no cumple con el mínimo ej. (n.nnn.nnn)
    // Calcular Dígito Verificador
    suma = 0;
    multiplo = 2;
    for (i = 1; i <= cuerpo.length; i++) { // Para cada dígito del Cuerpo
      index = multiplo * valor.charAt(cuerpo.length - i); // Obtener su Producto con el Múltiplo Correspondiente
      suma = suma + index; // Sumar al Contador General
      if (multiplo < 7) multiplo = multiplo + 1; // Consolidar Múltiplo dentro del rango [2,7]
      else multiplo = 2;
    }
    dvEsperado = 11 - (suma % 11); // Calcular Dígito Verificador en base al Módulo 11
    dv = (dv == 'K') ? 10 : dv; // Caso Especial 0
    dv = (dv == 0) ? 11 : dv; // Caso Especial K
    if (dvEsperado != dv) return false; // Validar que el Cuerpo coincide con su Dígito Verificador
    return true; // Si todo sale bien, se retorna true;
  }

  function popup(theURL) {
    window.open(theURL, 'Popup', 'status=yes, scrollbars=yes, resizable=yes, width=1050, height=600');
  }
</script>

<?php
include("../inc/google-analytics.php");
?>