<?php

/* Esta función comprueba todos los datos obligatorios de la atención, en el contexto de la notificación al Ministerio de Salud. */
function validarDatosAtenciónPcr($id_atención) {
	global $mysqli;

	$sql_datos_atención = "SELECT a.ID_ATENCION,
	a.ID_MEDICO, med.NRO_RUT as NRO_RUT_MED, med.DV_RUT as DV_RUT_MED, 
	pac.NRO_RUT as NRO_RUT_PAC, pac.DV_RUT as DV_RUT_PAC, pac.NOMBRES, pac.APELLIDO_PATERNO, pac.APELLIDO_MATERNO, pac.FECHA_NACIMIENTO, pac.DIRECCION, cod.ATRIBUTO1 AS COD_COMUNA, pac.FONO_1, pac.GENERO
	FROM atenciones a
	INNER JOIN personas pac ON a.ID_CLIENTE = pac.ID_PERSONA
	LEFT JOIN personas med ON a.ID_MEDICO = med.ID_PERSONA
	LEFT JOIN codigos_generales cod ON pac.COMUNA = cod.CODIGO AND cod.COD_TABLA = 'SIS_COMUN'
	WHERE a.ID_ATENCION = $id_atención";
	$resultado_datos_atención = $mysqli->query($sql_datos_atención);
	$datos_atención = $resultado_datos_atención->fetch_assoc();
		
	$error = '';
	
	if ($datos_atención['ID_MEDICO'] === null) {
		$error .= '<br />La atención no posee médico.';
	}
	if ($datos_atención['NRO_RUT_MED'] === null || $datos_atención['DV_RUT_MED'] === null) {
		$error .= '<br />El RUT del médico no está configurado correctamente.';
	}
	
	if ($datos_atención['NRO_RUT_PAC'] === null || $datos_atención['DV_RUT_PAC'] === null) {
		$error .= '<br />El RUT del paciente no está configurado correctamente.';
	}
	
	if ($datos_atención['NOMBRES'] === null || $datos_atención['APELLIDO_PATERNO'] === null) {
		$error .= '<br />El nombre del paciente está incompleto.';
	}
	
	if ($datos_atención['FECHA_NACIMIENTO'] === null) {
		$error .= '<br />Falta la fecha de nacimiento del paciente.';
	}
	
	if ($datos_atención['DIRECCION'] === null) {
		$error .= '<br />Falta la dirección del paciente.';
	}
	
	if ($datos_atención['COD_COMUNA'] === null) {
		$error .= '<br />Falta la comuna del paciente.';
	}
	
	if ($datos_atención['FONO_1'] === null) {
		$error .= '<br />Falta el teléfono del paciente.';
	}
	
	if ($datos_atención['GENERO'] === null || !in_array($datos_atención['GENERO'], ['F', 'M'])) {
		$error .= '<br />Falta el género del paciente o está mal especificado';
	}
	
	return ($error != '') ? $error : false;
}

?>
