<?php
$pantalla_actual = 'LIS_ATE';

$hora = time();
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

// $current_date = date("Y-m-d");
// $date = strtotime($current_date . ' -6 months');
// $final = date('Y-m-d', $date);
// if (!isset($_GET['f_desde'])) echo "<script>location.href='l_atenciones_ajax.php?f_desde=$final';</script>";

$opciones_local = '<option value="">-</option>';
$qLocales = $mysqli->prepare("SELECT ID_CENTRO_CONTACTO, NOMBRE
FROM centros_contacto 
ORDER BY NOMBRE ASC");
$qLocales->execute();
$qLocales->bind_result($l_idLocal, $l_nombre);
while ($qLocales->fetch()) {
  $selected = $l_idLocal == $_GET['id_cc'] ? 'selected' : '';
  $opciones_local .= "<option value='$l_idLocal' $selected> $l_nombre </option>";
}
$qLocales->close();

$opciones_convenio = '<option value="">-</option>';
$qConvenios = $mysqli->prepare("SELECT ID_EMPRESA, NBR
FROM empresas 
WHERE FLAG_CONVENIO = 'S'
ORDER BY NBR ASC");
$qConvenios->execute();
$qConvenios->bind_result($e_idEmpresa, $e_nbr);
while ($qConvenios->fetch()) {
  $selected = $e_idEmpresa == $_GET['id_con'] ? 'selected' : '';
  $opciones_convenio .= "<option value='$e_idEmpresa' $selected> $e_nbr </option>";
}
$qConvenios->close();

$opciones_usuarioCreador = '<option value="">-</option>';
$qUsuarioCreador = $mysqli->prepare("SELECT ID_USUARIO, CONCAT_WS(' ', NOMBRES, APELLIDO_PATERNO, APELLIDO_MATERNO) as nombre_usuario
FROM usuarios
WHERE ACTIVO = 'S' AND PERFIL IN ('SECRETARIA', 'PROFESIONAL', 'SUPERVISOR', 'ADMINISTRADOR') AND ID_USUARIO != 0
ORDER BY nombre_usuario");
$qUsuarioCreador->execute();
$qUsuarioCreador->bind_result($u_idUsuario, $u_nombreUsuario);
while ($qUsuarioCreador->fetch()) {
  $selected = $u_idUsuario == $_GET['id_usu'] ? 'selected' : '';
  $opciones_usuarioCreador .= "<option value='$u_idUsuario' $selected> $u_nombreUsuario </option>";
}
$qUsuarioCreador->close();

$f_desde  = isset($_GET['f_desde']) && $_GET['f_desde'] != '' ? $_GET['f_desde'] : "";
$f_hasta  = isset($_GET['f_hasta']) && $_GET['f_hasta'] != '' ? $_GET['f_hasta'] : "";
$id_ate   = isset($_GET['id_ate'])  && $_GET['id_ate']  != '' ? $_GET['id_ate']  : "";
$id_cc    = isset($_GET['id_cc'])   && $_GET['id_cc']   != '' ? $_GET['id_cc']   : "";
$id_con   = isset($_GET['id_con'])  && $_GET['id_con']  != '' ? $_GET['id_con']  : "";
$id_cli   = isset($_GET['id_cli'])  && $_GET['id_cli']  != '' ? $_GET['id_cli']  : "";
$rut   = isset($_GET['rut'])  && $_GET['rut']  != '' ? $_GET['rut']  : "";
$id_usu   = isset($_GET['id_usu'])  && $_GET['id_usu']  != '' ? $_GET['id_usu']  : "";

if ($id_cli) {
  $qPacienteSelected = $mysqli->prepare("SELECT CONCAT(CONCAT_WS(' ', NOMBRES, APELLIDO_PATERNO, APELLIDO_MATERNO), ' - ', CONCAT_WS('-', NRO_RUT, DV_RUT))
  FROM personas p
  WHERE ID_PERSONA = ?");
  $qPacienteSelected->bind_param("i", $id_cli);
  $qPacienteSelected->execute();
  $qPacienteSelected->bind_result($pacienteSeleccionado);
  $qPacienteSelected->store_result();
  $qPacienteSelected->fetch();
  $qPacienteSelected->close();
}

ob_start();
?>
<!-- ==========================CONTENT STARTS HERE ========================== -->
<!-- MAIN PANEL -->

<!-- MAIN CONTENT -->
<form action="" method="get" class="smart-form">
    <div class="row">
      <section class="col col-2">
        <label class="input">
          <input name="f_desde" class="input-sm" type="date" value="<?php if (isset($_GET['f_desde'])) echo $_GET['f_desde'] ?>" />
          <div class="note">Fecha Desde</div>
        </label>
      </section>
      <section class="col col-2">
        <label class="input">
          <input name="f_hasta" class="input-sm" type="date" value="<?php if (isset($_GET['f_hasta'])) echo $_GET['f_hasta'] ?>" />
          <div class="note">Fecha Hasta</div>
        </label>
      </section>
      <section class="col col-2">
        <label class="input">
          <input type="text" class="input-sm" name="id_ate" value="<?php if (isset($_GET['id_ate'])) echo $_GET['id_ate'] ?>" />
        </label>
        <div class="note">N° Atención</div>
      </section>
      <section class="col col-2">
        <select name="id_cc" class="select2">
          <?= $opciones_local ?>
        </select>
        <div class="note">Local</div>
      </section>
      <section class="col col-2">
        <select name="id_con" class="select2">
          <?= $opciones_convenio ?>
        </select>
        <div class="note">Convenio</div>
      </section>
      <section class="col-md-2">
        <div class="btn-group">
          <button class="btn btn-sm btn-success" type="submit"> <i class="fa fa-search"> </i> Filtrar </button>
          <a class="btn btn-sm btn-info" href="l_atenciones.php" style="margin-left: 5px">Ver todo</a>
        </div>
      </section>
    </div>
    <div class="row">
      <!-- <section class="col col-4">
        <label class="input">
          <input style="width: -webkit-fill-available;" id="busquedaPAC" name="id_cli">
          <div class="note">Paciente</div>
        </label>
      </section> -->
      <section class="col col-2">
        <label class="input">
          <input type="text" class="input-sm" name="rut" value="<?php if (isset($_GET['rut'])) echo $_GET['rut'] ?>" />
        </label>
        <div class="note">RUT Paciente (sin DV)</div>
      </section>
      <section class="col col-2">
        <select name="id_usu" class="select2">
          <?= $opciones_usuarioCreador ?>
        </select>
        <div class="note">Usuario creador</div>
      </section>
    </div>
</form>

<div class="table-responsive">
  <table class="table table-hover table-bordered display" id="dataTable-atenciones" style="width:100%">
    <thead>
      <tr>
        <th>N° Atención</th>
        <th>Fecha</th>
        <th>Local</th>
        <th>Convenio</th>
        <th>Muestra Tomada</th>
        <th>Recepcionado</th>
        <th>RUT Paciente</th>
        <th>Nombre Paciente</th>
        <th>Código Barras</th>
        <th>Modificar</th>
      </tr>
    </thead>
  </table>
</div>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title'],
  "icon" => 'fa fa-cog',
  'toolbar' => array(
    array(
      "id" => "toolbar-id",
      "content" => '<a href="#"  data-toggle="modal" data-target="#myModalNew"></a>',
      "class" => 'smart-form'
    )
  )
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php
  include("../inc/ribbon.php");
  ?>

  <!-- MAIN CONTENT -->
  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>
  <!-- END MAIN PANEL -->
</div>
<!-- END MAIN PANEL -->
<!-- ==========================CONTENT ENDS HERE ========================== -->

<!-- PAGE FOOTER -->
<?php
// include page footer
include("../inc/footer.php");
?>
<!-- END PAGE FOOTER -->

<?php
//include required scripts
include("../inc/scripts.php");
?>

<script>
  $(document).ready(function() {
    var dataTable = $('#dataTable-atenciones').DataTable({
      // searchDelay: 1000,
      'lengthMenu': [
        [50, 100, 200, 500],
        [50, 100, 200, 500]
      ],
      "language": {
        "sProcessing": "Procesando...",
        "sZeroRecords": "No se encontraron resultados",
        "sInfoPostFix": "",
        "sUrl": "",
        "oPaginate": {
          "sFirst": "Primero",
          "sPrevious": "Anterior",
          "sNext": "Siguiente",
          "sLast": "Último"
        },
        "sInfo": "_START_ a _END_ de _TOTAL_ Registros",
        "sInfoEmpty": "0 Registros",
        "sInfoFiltered": "(de _MAX_ Registros en total)",
        "sLengthMenu": "Mostrar _MENU_ Registros",
        "sSearch": "Buscar: "
      },
      "processing": true,
      "serverSide": true,
      "order": [0, 'asc'],
      "ajax": {
        url: "ajax_atenciones.php",
        type: "POST",
        data: {
          'f_desde': "<?= $f_desde ?>",
          'f_hasta': "<?= $f_hasta ?>",
          'id_ate': "<?= $id_ate ?>",
          'id_cc': "<?= $id_cc ?>",
          'id_con': "<?= $id_con ?>",
          'id_cli': "<?= $id_cli ?>",
          'rut': "<?= $rut ?>",
          'id_usu': "<?= $id_usu ?>",
        },
      }
    });

    var searchWait = 0;
    var searchWaitInterval;
    $(".dataTables_filter input").off().on("input", function(e) {
      var item = $(this);
      searchWait = 0;
      if (!searchWaitInterval) searchWaitInterval = setInterval(function() {
          console.log(searchWait);
          if (searchWait >= 3) {
              clearInterval(searchWaitInterval);
              searchWaitInterval = "";
              console.log(item.val());
              dataTable.search(item.val()).draw();
              searchWait = 0;
          }
          searchWait++;
      }, 200);
    });

    // $('#busquedaPAC').select2({
    //   placeholder: "Buscar RUT o nombre de paciente",
    //   minimumInputLength: 1,
    //   formatInputTooShort: function() {
    //     return 'Ingrese uno o mas caracteres';
    //   },
    //   formatSearching: "Buscando...",
    //   formatNoMatches: "No se encontraron resultados",
    //   ajax: {
    //     url: "../o_atenciones/ajax_PAC.php",
    //     type: "POST",
    //     dataType: 'json',
    //     quietMillis: 250,
    //     data: function(term, page) {
    //       return {
    //         nombre: term,
    //       };
    //     },
    //     results: function(data) {
    //       // se utiliza este map en vez de las propiedades formatResult y formatSelection ya que rompen el setteo de la opcion elegida por filtro
    //       return {
    //         results: $.map(data, function(item) {
    //           return {
    //             text: item.nombre + " - " + item.rut,
    //             id: item.id,
    //           }
    //         })
    //       };
    //     },
    //     cache: true
    //   },
    //   escapeMarkup: function(m) {
    //     return m; // we do not want to escape markup since we are displaying html in results
    //   } 
    // });
    // // para settear la opción elegida al principio de la página
    // if ("<?= $id_cli ?>") {
    //   $("#busquedaPAC").select2('data', {
    //     id: "<?= $id_cli ?>",
    //     text: "<?= $pacienteSeleccionado ?>"
    //   });
    // }
  });
</script>
<?php
//include footer
include("../inc/google-analytics.php");
?>