<?php
$pantalla_actual = 'LIS_ATE_NO_RECEP';

$hora = time();
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

// $opciones_local = '<option value="">-</option>';
// $qLocales = $mysqli->prepare("SELECT ID_CENTRO_CONTACTO, NOMBRE
// FROM centros_contacto 
// ORDER BY NOMBRE ASC");
// $qLocales->execute();
// $qLocales->bind_result($l_idLocal, $l_nombre);
// while ($qLocales->fetch()) {
//   $selected = $l_idLocal == $_GET['id_cc'] ? 'selected' : '';
//   $opciones_local .= "<option value='$l_idLocal' $selected> $l_nombre </option>";
// }
// $qLocales->close();

// $opciones_convenio = '<option value="">-</option>';
// $qConvenios = $mysqli->prepare("SELECT ID_EMPRESA, NBR
// FROM empresas 
// WHERE FLAG_CONVENIO = 'S'
// ORDER BY NBR ASC");
// $qConvenios->execute();
// $qConvenios->bind_result($e_idEmpresa, $e_nbr);
// while ($qConvenios->fetch()) {
//   $selected = $e_idEmpresa == $_GET['id_con'] ? 'selected' : '';
//   $opciones_convenio .= "<option value='$e_idEmpresa' $selected> $e_nbr </option>";
// }
// $qConvenios->close();

// $opciones_usuarioCreador = '<option value="">-</option>';
// $qUsuarioCreador = $mysqli->prepare("SELECT ID_USUARIO, CONCAT_WS(' ', NOMBRES, APELLIDO_PATERNO, APELLIDO_MATERNO) as nombre_usuario
// FROM usuarios
// WHERE ACTIVO = 'S' AND PERFIL IN ('SECRETARIA', 'PROFESIONAL', 'SUPERVISOR', 'ADMINISTRADOR') AND ID_USUARIO != 0
// ORDER BY nombre_usuario");
// $qUsuarioCreador->execute();
// $qUsuarioCreador->bind_result($u_idUsuario, $u_nombreUsuario);
// while ($qUsuarioCreador->fetch()) {
//   $selected = $u_idUsuario == $_GET['id_usu'] ? 'selected' : '';
//   $opciones_usuarioCreador .= "<option value='$u_idUsuario' $selected> $u_nombreUsuario </option>";
// }
// $qUsuarioCreador->close();

// $f_desde  = isset($_GET['f_desde']) && $_GET['f_desde'] != '' ? $_GET['f_desde'] : "";
// $f_hasta  = isset($_GET['f_hasta']) && $_GET['f_hasta'] != '' ? $_GET['f_hasta'] : "";
// $id_ate   = isset($_GET['id_ate'])  && $_GET['id_ate']  != '' ? $_GET['id_ate']  : "";
// $id_cc    = isset($_GET['id_cc'])   && $_GET['id_cc']   != '' ? $_GET['id_cc']   : "";
// $id_con   = isset($_GET['id_con'])  && $_GET['id_con']  != '' ? $_GET['id_con']  : "";
// $id_cli   = isset($_GET['id_cli'])  && $_GET['id_cli']  != '' ? $_GET['id_cli']  : "";
// $rut   = isset($_GET['rut'])  && $_GET['rut']  != '' ? $_GET['rut']  : "";
// $id_usu   = isset($_GET['id_usu'])  && $_GET['id_usu']  != '' ? $_GET['id_usu']  : "";

$fechaActual = date('Y-m-d');
$horaActual = date("H:i");
$fechaSesentaDiasAtras = date('Y-m-d H:m:s', strtotime("-60 days"));

$qAtencionesNoRecepcionadas = $mysqli->prepare("SELECT a.ID_ATENCION, DATE_FORMAT(a.FECHA, '%d/%m/%Y'), a.FECHA_TM, a.OBS, cc.NOMBRE, c.NBR,
CONCAT_WS('-', p.NRO_RUT, p.DV_RUT), CONCAT_WS(' ', p.NOMBRES, p.APELLIDO_PATERNO, p.APELLIDO_MATERNO), 
CONCAT_WS(' ', u.NOMBRES, u.APELLIDO_PATERNO, u.APELLIDO_MATERNO), COUNT(pag.ID_PAGOS), COUNT(ea.ID_EXATE)
FROM atenciones a
INNER JOIN personas p ON a.ID_CLIENTE = p.ID_PERSONA
INNER JOIN centros_contacto cc ON a.ID_CENTRO_CONTACTO = cc.ID_CENTRO_CONTACTO
LEFT JOIN empresas c ON a.ID_CONVENIO = c.ID_EMPRESA
LEFT JOIN usuarios u ON u.ID_USUARIO = a.ID_USUARIO
LEFT JOIN pagos pag ON pag.ID_ATENCION = a.ID_ATENCION
LEFT JOIN examenes_atenciones ea ON ea.ID_ATENCION = a.ID_ATENCION
WHERE a.FECHA_R IS NULL AND FECHA_INF IS NULL AND a.FLAG_ELIMINADO = 0 AND a.ID_CLIENTE != 61 AND a.FECHA < ?
GROUP BY a.ID_ATENCION
ORDER BY a.ID_ATENCION DESC");
$qAtencionesNoRecepcionadas->bind_param("s", $fechaSesentaDiasAtras);
$qAtencionesNoRecepcionadas->execute();
$qAtencionesNoRecepcionadas->bind_result($idAtencion, $fechaAtencion, $fechaTomaMuestraAtencion, $observacionAtencion, $nombreLocal, $nombreConvenio, $rutPaciente, $nombrePaciente, $nombreUsuarioCreador, $nroPagos, $nroExamenes);
$qAtencionesNoRecepcionadas->store_result();

ob_start();
?>

<div class="table-responsive">
  <table class="table table-hover table-bordered display" id="dataTable-atenciones" style="width:100%">
    <thead>
      <tr>
        <th>N° atención</th>
        <th>Fecha</th>
        <th>Local</th>
        <th>Convenio</th>
        <th>RUT paciente</th>
        <th>Nombre paciente</th>
        <th>Observación</th>
        <th>Muestra tomada</th>
        <th>Nro. pagos</th>
        <th>Detalle pagos</th>
        <th>Nro. exámenes</th>
        <th>Detalle exámenes</th>
        <th>Eliminar
          <br />
          <label class="checkbox">
            <input type="checkbox" id="id_atencion-todos" style="width: auto !important" />
          </label>
        </th>
      </tr>
    </thead>
    <tbody>
      <form id="eliminarAtencionesNoRecepcionadas" action="">
      <?php while ($qAtencionesNoRecepcionadas->fetch()) { ?>
        <tr>
          <td> <?= $idAtencion ?> </td>
          <td> <?= $fechaAtencion ?> </td>
          <td> <?= $nombreLocal ?> </td>
          <td> <?= $nombreConvenio ? $nombreConvenio : "-" ?> </td>
          <td> <?= $rutPaciente ?> </td>
          <td> <?= $nombrePaciente ?> </td>
          <td> <?= $observacionAtencion ?> </td>
          <td> <?= $fechaTomaMuestraAtencion ? "<i class='fa-fw fa fa-check text-success'></i>" : "<span class='text-danger'><strong>No</strong></span>"; ?> </td>
          <td> <?= $nroPagos ?> </td>
          <td> <a class="btn btn-link" href="../c_pagos/d_pagos.php?idate=<?= $idAtencion ?>" target="_blank"> <i class="fa fa-lg fa-eye"></i> </a> </td>
          <td> <?= $nroExamenes ?> </td>
          <td> <a class="btn btn-link" href="../st_resultados/e_resultados.php?idate=<?= $idAtencion ?>" target="_blank"> <i class="fa fa-lg fa-list"></i> </a> </td>
          <td> <input type="checkbox" name="id_atencion" class="id_atencion" value="<?= $idAtencion ?>"> </td>
        </tr>
      <?php } ?>
      </form>
    </tbody>
  </table>
</div>
<p>
<!-- <div class="pull-right">
  <br />
  <button id="grabar" class="btn btn-primary">
    <i class="fa fa-save"></i> Grabar
  </button>
  <br />
</div> -->
<div style="clear: both"></div>
</p>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title'],
  "icon" => 'fa fa-cog',
  'toolbar' => array(
    array(
      "id" => "toolbar-id",
      "content" => '<a href="#"  data-toggle="modal" data-target="#myModalNew"></a>',
      "class" => 'smart-form'
    )
  )
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php
  include("../inc/ribbon.php");
  ?>

  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<script>
  $(document).ready(function() {

    resultadosAInformar = {};

    var dataTable = $('#dataTable-atenciones').DataTable({
      'lengthMenu': [
        [50, 100, 200, 500],
        [50, 100, 200, 500]
      ],
      "language": {
        "sProcessing": "Procesando...",
        "sZeroRecords": "No se encontraron resultados",
        "sInfoPostFix": "",
        "sUrl": "",
        "oPaginate": {
          "sFirst": "Primero",
          "sPrevious": "Anterior",
          "sNext": "Siguiente",
          "sLast": "Último"
        },
        "sInfo": "_START_ a _END_ de _TOTAL_ Registros",
        "sInfoEmpty": "0 Registros",
        "sInfoFiltered": "(de _MAX_ Registros en total)",
        "sLengthMenu": "Mostrar _MENU_ Registros",
        "sSearch": "Buscar: "
      },
      "order": [0, 'asc']
    });

    $('.id_atencion').change(function() {
      var seleccionado = $(this).prop('checked');
      if (seleccionado) {
        resultadosAInformar[$(this).val()] = $(this).val();
      } else {
        if (resultadosAInformar.hasOwnProperty($(this).val())) {
          delete resultadosAInformar[$(this).val()];
        }
      }
    });

    $('#id_atencion-todos').change(function() {
      var seleccionar = $(this).prop('checked');
      $('input.id_atencion:not([checked]):not([disabled])').each(function() {
        $(this).prop('checked', seleccionar);
        $(this).change();
      });
    });

    $('#grabar').click(function() {
      var form = $("#eliminarAtencionesNoRecepcionadas");
      // var serializedForm = $(form).serializeArray();
      var dtForm = $('#dataTable-atenciones').dataTable().$('input').serializeArray();
      dtForm.push({
        name: 'eliminarAtencionesNoRecepcionadas',
        value: 'eliminarAtencionesNoRecepcionadas'
      }, {
        name: 'id_atencion',
        value: $("#id_atencion").val()
      });
      console.log(dtForm);
      $.post("sql_cod.php", dtForm, function(data) {
        if (data.exito) {
          exito(data.mensaje);
        } else {
          error(data.mensaje);
        }
      }, 'json');
    });

  });
</script>

<?php
include("../inc/google-analytics.php");
?>