<?php
$pagina = 7;
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");

$idAtencion = isset($_GET['idAtencion']) ? $_GET['idAtencion'] : "-1";

$options_formaPagoBoleta = "<option value=''>--Seleccione--</option>";
$qFormaPagoBoleta = $mysqli->prepare("SELECT CODIGO, DESCRIPCION_CG FROM codigos_generales WHERE COD_TABLA = 'SIS_FORPAG' AND CODIGO NOT IN (1, 7, 9, 10, 11, 12) ORDER BY DESCRIPCION_CG ASC"); # 10 
$qFormaPagoBoleta->execute();
$qFormaPagoBoleta->bind_result($codigoFormaPago, $descripcionFormaPago);
$qFormaPagoBoleta->store_result();
while ($qFormaPagoBoleta->fetch()) {
  $options_formaPagoBoleta .= "<option value='$codigoFormaPago'> $descripcionFormaPago </option>";
}
$qFormaPagoBoleta->close();

$qAtencion = $mysqli->prepare("SELECT a.FECHA, a.MONTO_ATENCION, a.ID_CENTRO_CONTACTO, p.NRO_RUT, CONCAT_WS('-', p.NRO_RUT, p.DV_RUT), 
CONCAT_WS(' ', p.NOMBRES, p.APELLIDO_PATERNO, p.APELLIDO_MATERNO), p.DIRECCION, p.PASAPORTE
FROM atenciones a
INNER JOIN personas p ON p.ID_PERSONA = a.ID_CLIENTE
WHERE a.ID_ATENCION = ?");
$qAtencion->bind_param('i', $idAtencion);
$qAtencion->execute();
$qAtencion->bind_result($ate_fecha, $ate_montoAtencion, $ate_idCentroContacto, $ate_nroRut, $ate_rut, $ate_nombrePaciente, $ate_direccionPaciente, $ate_pasaportePaciente);
$qAtencion->store_result();
$qAtencion->fetch();
$qAtencion->close();

$options_local = "<option value=''>--Seleccione--</option>";
$qLocales = $mysqli->prepare("SELECT ID_CENTRO_CONTACTO, NOMBRE FROM centros_contacto WHERE NOMBRE != '' ORDER BY NOMBRE ASC");
$qLocales->execute();
$qLocales->bind_result($cc_idCentroContacto, $cc_nombreCentroContacto);
$qLocales->store_result();
while ($qLocales->fetch()) {
  $selected = "";
  $selected = $ate_idCentroContacto == $cc_idCentroContacto ? "selected" : "";
  $options_local .= "<option value='$cc_idCentroContacto' $selected> $cc_nombreCentroContacto </option>";
}
$qLocales->close();

$pacienteExtranjero = ($ate_pasaportePaciente != "" && (substr($ate_nroRut, 0, 2) == "99" && strlen($ate_nroRut) == 8)) ? "S" : "N";
$datos_venta = "c_razon_social: " . json_encode($ate_nombrePaciente) . ", c_direccion: '" . addslashes($ate_direccionPaciente) . "', c_rut: '$ate_rut'";
$url_asociar_dte = urlencode("https://" . $_SERVER['SERVER_NAME'] . "/$carpetaProyecto/api_fact/asociar_dte.php?idat=$idAtencion");

# consulta de exámenes de la atención
$qExamenesAtencion = $mysqli->prepare("SELECT IFNULL(ex.COD_FONASA, ea.COD_EXAMEN), ea.PRECIO_EXAMEN, ex.NOMBRE
FROM examenes_atenciones ea
INNER JOIN examenes ex ON ea.COD_EXAMEN=ex.COD_INTERNO
WHERE ea.ID_ATENCION = ? AND ea.F_HIJO IS NULL AND (ea.PREV = 0 OR ea.PREV = 37)");
$qExamenesAtencion->bind_param('i', $idAtencion);
$qExamenesAtencion->execute();
$qExamenesAtencion->bind_result($ea_codExamen, $ea_precio, $ea_nombre);
$arrayExAt = [];
while ($qExamenesAtencion->fetch()) {
  $arrayExAt[] = array(
    'nombre' => $ea_codExamen,
    'descripcion' => $ea_nombre,
    'cantidad' => '1',
    'precio_unitario' => $ea_precio,
    'porc_descuento' => '0',
    'monto_descuento' => '0',
    'monto' => $ea_precio,
    'id_detalle_venta' => ''
  );
}
$qExamenesAtencion->close();

ob_start();
?>

<div class="modal-header">
  <button type="button" class="close" data-dismiss="modal" aria-hidden="true">
    &times;
  </button>
  <h4 class="modal-title" id="myModalLabel"> Generar boleta electrónica </h4>
</div>

<div class="modal-body">
  <form action="sql_cod.php" class="smart-form">
    <div class="row">
      <section class="col col-6">
        <label class="label">Forma de pago</label>
        <label class="select">
          <select name="id_forma_pago" class="select2" style="width:100%">
            <?= $options_formaPagoBoleta ?>
          </select> <i></i>
        </label>
      </section>
      <section class="col col-6">
        <label class="label">Local</label>
        <label class="select">
          <select name="id_local" class="select2" style="width:100%">
            <?= $options_local ?>
          </select> <i></i>
        </label>
      </section>
    </div>
  </form>
</div>

<div class="modal-footer">
  <a class="btn btn-sm btn-primary btn-success btn-generarBoleta" target="_blank"><i class="fa fa-plus"></i> Generar </a>
  <button type="button" class="btn btn-default" data-dismiss="modal">
    Cerrar
  </button>
</div>


<script>
  $(document).ready(function() {
    function popup(theURL) {
      window.open(theURL, 'Popup', 'status=yes, scrollbars=yes, resizable=yes, width=1050, height=600');
    }

    $('.btn-generarBoleta').on('click', function() {
      var detalle = <?= json_encode($arrayExAt) ?>;
      var id_forma_pago = $('select[name="id_forma_pago"]').val();
      var id_local = $('select[name="id_local"]').val();
      if (id_forma_pago == "") {
        alert("ERROR: Debe seleccionar un método de pago para la poder generar la boleta electrónica");
        return false;
      }
      if (id_local == "") {
        alert("ERROR: Debe seleccionar un local para la poder generar la boleta electrónica");
        return false;
      }
      rut = '<?= $ate_rut ?>';
      // if (!validarRut(rut)) {
      //   alert('El rut del paciente no es válido, debe ser modificado.');
      //   return false;
      // }
      if (confirm("¿Desea generar una boleta electrónica para la atención?")) {
        $(this).addClass('disabled');
        var id = $(this).data('id');
        var ext = '<?= $pacienteExtranjero ?>';
        var urlVentasSqlCod = '<?= $urlVentasSqlCod ?>'; // ventas/sql_cod.php
        $.post(urlVentasSqlCod, {
          updateVenta: 1,
          cod_empresa: '<?= $codEmpresaSistemaVentas ?>',
          monto_neto: 0,
          tasa_iva: 19,
          monto_exento: 0,
          detalle: detalle,
          <?= $datos_venta ?>,
          tipo_dte: '<?= $cliente_dtePorDefecto ?>'
        }, function(data) {
          if (data.exito) {
            exito();
            var idv = data.idv;
            var ide = data.ide;
            var idu = '<?= $usuario_id ?>';
            var url = '<?= $url_asociar_dte ?>';
            var urlDetalleVenta = '<?= $urlDetalleVenta ?>?id_venta=' + idv + '&id_empresa=' + ide + '&id_usuario_lims=' + idu + '&id_forma_pago=' + id_forma_pago + '&id_local=' + id_local + '&ext=' + ext + '&url=' + url; // ventas/n_detalles_venta.php
            popup(urlDetalleVenta);
          } else {
            error(data.mensaje);
          }
        }, 'json');
        $(this).removeClass('disabled');
      }
    });

    $("#formEliminarAtencion").validate({
      rules: {
        razonEliminacion: {
          required: true
        },
        otraRazonEliminacion: {
          required: true
        }
      },
      messages: {
        razonEliminacion: {
          required: 'Campo Obligatorio'
        },
        otraRazonEliminacion: {
          required: 'Campo Obligatorio'
        }
      },
      onfocusout: false,
      onsubmit: true,
      // Do not change code below
      errorPlacement: function(error, element) {
        error.insertAfter(element.parent());
      }
    });
  });
</script>