<?php
define('PERMITIDO', true);
$pantalla_actual = 'ING_ATE';
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$tiempo = time();
$hoy = date('Y-m-d', $tiempo);

$options_ccto = "";
$qOptionsCentroContacto = $mysqli->prepare("SELECT ID_CENTRO_CONTACTO, NOMBRE, FLAG_DIALISIS FROM centros_contacto");
$qOptionsCentroContacto->execute();
$qOptionsCentroContacto->bind_result($idCentroContacto, $nombreCentroContacto, $flagDialisis);
$qOptionsCentroContacto->store_result();
while ($qOptionsCentroContacto->fetch()) {
  $options_ccto .= "<option value='$idCentroContacto' data-dialisis='$flagDialisis'> $nombreCentroContacto </option>";
}
$qOptionsCentroContacto->close();

$options_convenio = optionsConvenio(null);

$options_diagnostico = optionsCodigosG("SIS_DIAGNO", null);
$options_motivosPriorizacion = optionsCodigosG("SIS_MOTPRIO", null);
$options_turnosDialisis = optionsCodigosG("SIS_TURDIA", null);

$options_nivelUrgencia = "";
$qOptionsNivelUrgencia = $mysqli->prepare("SELECT CODIGO, DESCRIPCION_CG FROM codigos_generales WHERE COD_TABLA = 'SIS_NIVURG'");
$qOptionsNivelUrgencia->execute();
$qOptionsNivelUrgencia->bind_result($codigoNivelUrgencia, $descripcionNivelUrgencia);
$qOptionsNivelUrgencia->store_result();
while ($qOptionsNivelUrgencia->fetch()) {
  $options_nivelUrgencia .= "<option value='$codigoNivelUrgencia'> $descripcionNivelUrgencia </option>";
}
$qOptionsNivelUrgencia->close();

# # $options_nivelUrgencia = optionsCodigosG("SIS_NIVURG", null); falta implementar valor default para campo que no puede ser null (nivel urgencia)

ob_start();
?>

<form action="sql_cod.php" method="post" class="smart-form" name="form1" id="formAtencion">
  <section>
    <div class="well well-sm bg-color-blue txt-color-white text-left">
      <div class="row" style="padding:1em;">
        <div class="col col-4">
          Paciente:
          <input id="busquedaPAC" name="ID_CLIENTE" style="width: -webkit-fill-available;">
          <span id="wrapper-editar-paciente"></span>
        </div>
        <div class="col col-1">
          Previsión: <div id="prevision"></div>
        </div>
        <div class="col col-1">
          F. Nacimiento: <div id="fechan"></div>
        </div>
        <div class="col col-1">
          Fono: <div id="fono"></div>
        </div>
        <div class="col col-3">
          Dirección: <div id="direccion"></div>
        </div>
        <div class="col col-1">
          <a data-toggle="modal" href="../m_personas/n_persona.php?t=p" class="btn btn-success btn-sm" data-target="#modalAgregarPersona"><i class="fa fa-plus"></i> Agregar</a>
        </div>
      </div>
    </div>
  </section>
  <section>
    <div class="well well-sm bg-color-blueLight txt-color-white text-left">
      <div class="row" style="padding:1em;">
        <div class="col col-4">
          Nombre Médico:
          <input id="busquedaMED" name="ID_MEDICO" style="width: -webkit-fill-available;">
        </div>
        <div class="col col-3">
          Especialidad:
          <div id="especialidad"></div>
        </div>
        <div class="col col-3">
        </div>
        <div class="col col-1">
          <a data-toggle="modal" href="../m_personas/n_persona.php?t=m" class="btn btn-success btn-sm" data-target="#modalAgregarPersona"><i class="fa fa-plus"></i> Agregar</a>
        </div>
      </div>
    </div>
  </section>

  <table class="table table-responsive table-bordered">
    <tr>
      <td align="left" nowrap="nowrap">Fecha:</td>
      <td align="left" nowrap="nowrap">
        <label class="input">
          <input type="date" class="input-sm" name="FECHA" value="<?php echo $hoy; ?>" />
        </label>
      </td>
      <td>Pre Diagnóstico:</td>
      <td>
        <label class="select">
          <select name="COD_DIAGNOSTICO" class="input-sm">
            <?= $options_diagnostico ?>
          </select><i></i>
        </label>
      </td>
    </tr>
    <tr>
      <td>Toma de Muestra:</td>
      <td>
        <label class="select">
          <select id="ID_CENTRO_CONTACTO" name="ID_CENTRO_CONTACTO" class="input-sm">
            <?= $options_ccto ?>
          </select> <i></i>
        </label>
      </td>
      <td>Turno Diálisis:</td>
      <td>
        <label class="select">
          <select id="ID_TURDIA" name="ID_TURDIA" class="input-sm" disabled>
            <option value="0">-</option>
            <?= $options_turnosDialisis ?>
          </select> <i></i>
        </label>
      </td>
    </tr>
    <tr>
      <td>Motivo de Priorización de Atención:</td>
      <td>
        <label class="select">
          <select name="MOTIVO_PRIORIZACION" class="input-sm">
            <?= $options_motivosPriorizacion ?>
          </select> <i></i>
        </label>
      </td>
      <td>Urgencia:</td>
      <td>
        <label class="select">
          <select name="NIVEL_URGENCIA" class="input-sm">
            <?= $options_nivelUrgencia ?>
          </select> <i></i>
        </label>
      </td>
    </tr>
    <tr>
      <td align="left">Consentimiento Revisión Médico:</td>
      <td>
        <label class="checkbox">
          <input name="FLAG_ACEPTA_C" type="checkbox" id="FLAG_ACEPTA_C" value="1" checked /><i></i>
        </label>
      </td>
      <td>Última Regla:</td>
      <td>
        <label class="input">
          <input name="FECHA_ULT_REGLA" type="date" class="input-sm" tabindex="7" />
        </label>
      </td>
    </tr>
    <tr>
      <td>Convenio:</td>
      <td>
        <label class="select">
          <select id="ID_CONVENIO" name="ID_CONVENIO" class="input-sm">
            <option value="0">-</option>
            <?= $options_convenio ?>
          </select> <i></i>
        </label>
      </td>
      <td>Monto a cobrar a Convenio ($):</td>
      <td>
        <label class="input">
          <input disabled type="text" id="MONTO_CONVENIO" name="MONTO_CONVENIO" value="0" class="input-sm" required="required" min="0" />
        </label>
      </td>
    </tr>
    <tr>
      <td>Descuento/Copago ($):</td>
      <td>
        <label class="input">
          <input type="text" name="MONTO_DESCUENTO" value="0" class="input-sm" required="required" min="0" />
        </label>
      </td>
      <td>Descuento (%):</td>
      <td>
        <label class="input">
          <input type="text" name="PCTJE_DESCUENTO" value="0" class="input-sm" required="required" min="0" />
        </label>
      </td>
    </tr>
    <tr>
      <td>Observaciones:</td>
      <td colspan="3" align="left" valign="top" nowrap="nowrap">
        <label class="textarea textarea-resizable">
          <textarea name="OBS" class="custom-scroll" rows="2"></textarea>
        </label>
      </td>
    </tr>
  </table>
  <footer>
    <a class="btn btn-primary btn-sm btn-grabarAtencion" data-form="#formAtencion">Grabar</a>
  </footer>
  <input type="hidden" name="GENERO" id="genero" />
  <input type="hidden" name="ID_PREVISION" id="id_prevision" />
  <input type="hidden" name="MM_insert" value="formAtencion" />
</form>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title'],
  "icon" => 'fa fa-cog'
);
$widget->body('content', $contenido);
?>


<div id="main" role="main">
  <?php
  include("../inc/ribbon.php");
  ?>

  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>

  <div class="modal fade New" id="modalAgregarPersona" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content" style="width:120%">
      </div>
    </div>
  </div>

  <div class="modal fade Edit" id="modal-editar-paciente" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content" style="width: 120%">
      </div>
    </div>
  </div>

</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<script>
  $(document).ready(function() {
    $('.btn-grabarAtencion').on('click', function() {
      var form = $(this).data('form');
      if ($("input[name='GENERO']").val() == "WARD") {
        if (confirm("¿Seguro desea grabar la atención sin ingresar la fecha de la última regla?")) {
          $.post($(form).attr('action'), $(form).serialize(), function(data) {
            if (data.exito) {
              exito();
              window.location.href = 'e_atencion.php?&idate=' + data.id;
            } else {
              error(data.mensaje);
            }
          }, 'json');
        }
      } else {
        $.post($(form).attr('action'), $(form).serialize(), function(data) {
          if (data.exito) {
            exito();
            window.location.href = 'e_atencion.php?&idate=' + data.id;
          } else {
            error(data.mensaje);
          }
        }, 'json');

      }
    });

    $('#ID_CENTRO_CONTACTO').on('change', function() {
      var dialisis = $('#ID_CENTRO_CONTACTO option:selected').attr('data-dialisis');
      if (dialisis == 'S') {
        $('#ID_TURDIA').removeAttr('disabled');
      } else {
        $('#ID_TURDIA').attr('disabled', 'disabled');
      }
      $('#ID_TURDIA').val('0');
    });

    $('#ID_CONVENIO').on('change', function() {
      if ($(this).val() != 0)
        $('#MONTO_CONVENIO').removeAttr('disabled');
      else {
        $('#MONTO_CONVENIO').attr('disabled', 'disabled');
        $('#MONTO_CONVENIO').val(0);
      }
    });

    $('#busquedaPAC').select2({
      placeholder: "Buscar nombre o RUT de paciente",
      minimumInputLength: 1,
      formatInputTooShort: function() {
        return 'Ingrese uno o mas caracteres';
      },
      formatSearching: "Buscando...",
      formatNoMatches: "No se encontraron resultados",
      ajax: { // instead of writing the function to execute the request we use Select2's convenient helper
        type: "POST",
        url: "../o_atenciones/ajax_PAC.php",
        dataType: 'json',
        quietMillis: 100,
        data: function(term, page) {
          return {
            nombre: term, // search term
          };
        },
        results: function(data) {
          return {
            results: $.map(data, function(item) {
              return {
                text: item.nombre + " - " + item.rut,
                id: item.id,
              }
            })
          };
        },
        cache: true
      },
      escapeMarkup: function(m) {
        return m;
      } // we do not want to escape markup since we are displaying html in results
    });

    $('#busquedaMED').select2({
      placeholder: "Buscar médico por Nombre",
      minimumInputLength: 1,
      formatSearching: "Buscando...",
      formatNoMatches: "No se encontraron resultados",
      formatInputTooShort: function() {
        return 'Ingrese uno o mas caracteres';
      },
      ajax: { // instead of writing the function to execute the request we use Select2's convenient helper
        type: "POST",
        url: "../o_atenciones/ajax_MED.php",
        dataType: 'json',
        quietMillis: 100,
        data: function(term, page) {
          return {
            nombre_medico: term, // search term
          };
        },
        results: function(data) {
          return {
            results: $.map(data, function(item) {
              return {
                text: item.nombre_medico + " - " + item.especialidad,
                id: item.id_medico,
                especialidad: item.especialidad
              }
            })
          };
        },
        cache: true
      },
      escapeMarkup: function(m) {
        return m;
      } // we do not want to escape markup since we are displaying html in results
    });

    $('#busquedaPAC').on('change', function(e) {
      $('#editar-paciente').remove();
      var id_paciente = e.val;
      var botonModal = $('<a id="editar-paciente" data-toggle="modal" href="../m_personas/e_persona.php?id=' + id_paciente + '&n_atencion=true" class="btn btn-default btn-sm hidden" data-target="#modal-editar-paciente"></a>');
      $('#wrapper-editar-paciente').append(botonModal);
      $(botonModal).click();
    });

    $('#busquedaMED').on('change', function() {
      $("#especialidad").html($('#busquedaMED').select2("data")['especialidad']);
    });

    $(".select2-hidden-accessible").hide();
  });
</script>

<?php
include("../inc/google-analytics.php");
?>