<?php
require_once('../Connections/conexionlab.php');
include('../assets/php/php/php-barcode.php');
require('../assets/php/php/fpdf.php');

class eFPDF extends FPDF
{
  function TextWithRotation($x, $y, $txt, $txt_angle, $font_angle = 0)
  {
    $font_angle += 90 + $txt_angle;
    $txt_angle *= M_PI / 180;
    $font_angle *= M_PI / 180;

    $txt_dx = cos($txt_angle);
    $txt_dy = sin($txt_angle);
    $font_dx = cos($font_angle);
    $font_dy = sin($font_angle);

    $s = sprintf('BT %.2F %.2F %.2F %.2F %.2F %.2F Tm (%s) Tj ET', $txt_dx, $txt_dy, $font_dx, $font_dy, $x * $this->k, ($this->h - $y) * $this->k, $this->_escape($txt));
    if ($this->ColorFlag)
      $s = 'q ' . $this->TextColor . ' ' . $s . ' Q';
    $this->_out($s);
  }
}

$idAtencion = "-1";
if (isset($_GET['idate'])) $idAtencion = $_GET['idate'];

// $idtb = "-1";
// if (isset($_GET['idtb'])) $idtb = $_GET['idtb'];

mysql_select_db($database_conexionlab, $conexionlab);
$query_exate = "SELECT ea.ID_EXATE, ea.ID_ATENCION, ea.COD_EXAMEN, ea.TIPO_TUBO, cg.DESCRIPCION_CG AS TIPTUB, ex.SECUENCIA_CBARRA, ex.FLAG_AGRUPACION,
pa.NOMBRES, pa.APELLIDO_PATERNO, pa.APELLIDO_MATERNO, ct.NOMBRE AS CENTROCTO, DATE_FORMAT(a.FECHA,'%d-%m-%y') AS FECHA, cg2.DESCRIPCION_CG AS TURNO
FROM examenes_atenciones ea
INNER JOIN examenes ex ON ea.COD_EXAMEN = ex.COD_INTERNO
LEFT JOIN codigos_generales cg ON ea.TIPO_TUBO = cg.CODIGO
LEFT JOIN atenciones a ON ea.ID_ATENCION = a.ID_ATENCION
LEFT JOIN centros_contacto ct ON ct.ID_CENTRO_CONTACTO = a.ID_CENTRO_CONTACTO
LEFT JOIN personas pa ON a.ID_CLIENTE = pa.ID_PERSONA
LEFT JOIN codigos_generales cg2 ON cg2.CODIGO = a.TURNO_DIALISIS AND cg2.COD_TABLA = 'SIS_TURDIA'
WHERE ea.ID_ATENCION = $idAtencion AND cg.COD_TABLA='SIS_TIPTUB' AND ea.TIPO_TUBO != '17'
GROUP BY ea.TIPO_TUBO";
$exate = mysql_query($query_exate, $conexionlab) or die(mysql_error());
$totalRows_exate = mysql_num_rows($exate);


// -------------------------------------------------- //
//                  PROPERTIES
// -------------------------------------------------- //

$pdf = new eFPDF('P', 'pt', 'barras');
$pdf->SetFont('Arial', '', $s_letra);
$pdf->SetTextColor(0, 0, 0);

if ($totalRows_exate === 0) {
  $pdf->AddPage(); // Agregar una página para mostrar el mensaje
  $pdf->TextWithRotation(40, 120, "Atencion no tiene", "90");
  $pdf->TextWithRotation(50, 120, "examenes", "90");
}

if ($totalRows_exate > 0) {
  while ($row_exate = mysql_fetch_assoc($exate)) {
    $fontSize = 9;
    $marge = 5;   // between barcode and hri in pixel
    $x = 40;  // barcode center
    $y = 70;  // barcode center
    $height = 30;  // barcode height in 1D ; module size in 2D
    $width = 1;   // barcode height in 1D ; not use in 2D
    $angle = 90;  // rotation in degrees

    $code = $idAtencion . "-" . $row_exate['TIPO_TUBO']; // barcode, of course ;).... con el id de la muestra: atencion-tipotubo
    $type = 'code128';
    $black = '000000'; // color in hexa

    $nombre_c = explode(' ', $row_exate['NOMBRES']);
    $nombre = utf8_decode($nombre_c[0]);
    $paciente = substr(utf8_decode($nombre . " " . $row_exate['APELLIDO_PATERNO'] . " " . $row_exate['APELLIDO_MATERNO']), 0, 25);

    $s_letra = 8;
    $idAtencionYTubo = $idAtencion . " - " . $row_exate['TIPTUB'];
    $procedencia = $row_exate['CENTROCTO'];
    $fechaTurno = $row_exate['FECHA'];
    if ($row_exate['TURNO'] != '') $fechaTurno .= '  ' . $row_exate['TURNO'];

    // -------------------------------------------------- //
    //            ALLOCATE FPDF RESSOURCE
    // -------------------------------------------------- //

    $pdf->AddPage();

    // -------------------------------------------------- //
    //                      BARCODE
    // -------------------------------------------------- //

    $data = Barcode::fpdf($pdf, $black, $x, $y, $angle, $type, array('code' => $code), $width, $height);

    // -------------------------------------------------- //
    //                      HRI
    // -------------------------------------------------- //

    $pdf->SetFont('Arial', '', $s_letra);
    $pdf->SetTextColor(0, 0, 0);

    $len_t = $pdf->GetStringWidth($idAtencionYTubo);
    Barcode::rotate(-$len_t / 2, - ($data['height'] / 2) - $s_letra, $angle, $xt, $yt);
    $pdf->TextWithRotation($x + $xt - 2, $y + $yt, $idAtencionYTubo, $angle);

    $len_st = $pdf->GetStringWidth($procedencia);
    Barcode::rotate(-$len_st / 2, - ($data['height'] / 2) - $s_letra, $angle, $xt, $yt);
    $pdf->TextWithRotation($x + $xt + 6, $y + $yt, $procedencia, $angle);

    $len = $pdf->GetStringWidth($paciente);
    Barcode::rotate(-$len / 2, ($data['height'] / 2) + $s_letra + $marge, $angle, $xt, $yt);
    $pdf->TextWithRotation($x + $xt, $y + $yt, $paciente, $angle);

    $len_f = $pdf->GetStringWidth($fechaTurno);
    Barcode::rotate(-$len_f / 2, ($data['height'] / 2) + $s_letra + $marge, $angle, $xt, $yt);
    $pdf->TextWithRotation($x + $xt + 8, $y + $yt, $fechaTurno, $angle);
  }
}

$pdf->Output();
