<?php
$pagina = 7;
define('PERMITIDO', true);
require_once('../inc/init.php');

# Los distintos métodos de I-MED usualmente retornan listas en forma de arreglos (de bonos, prestaciones, etc).
# Con la excepción de que cuando una "lista" tiene 1 item, en vez de recibir un array (de largo 1), se recibe el elemento por si solo (no en un array). 
# Esto ocasiona un problema con los foreach() que iteran a estas distintas "listas".
# La funcion parsearLista() verifica que $listaRecibida sea un array. En caso de serlo, se retorna normalmente.
# En caso contrario, se agrega el elemento de $listaRecibida en un arreglo auxiliar para luego retornar este último.
function parsearLista ($listaRecibida) {
  $aux = null;
  if (is_array($listaRecibida)) return $listaRecibida;
  else $aux[] = $listaRecibida;
  return $aux;
}

# Los ruts se deben enviar en el formato exigido por I-MED, se deben rellenar con "0" a la izquierda hasta que el largo del campo sea de 12 (incluyendo guión y rut)
function formatearRutImed ($rut) {
  $largoRut = 12;
  $relleno = "0";
  return str_pad($rut, $largoRut, $relleno, STR_PAD_LEFT);
}

print "<pre>";

$params = [
  "CodUsuario" => "78385630-1",
  "CodClave" => "78385630",
  "NumTransac" => $_GET['n']
];

// print_r($params);

try {
  $client = new SoapClient($urlWsdlImed, ['trace' => 1]);
  $res = $client->__soapCall("ObtBonInterMul", $params);

  print_r($res);
  # exit(0);

  $cod_financiador_respuesta = $res["LisVenConv"]->LisVenConvType->CodFinanciador; # Financiador es como I-MED llama a las previsiones

  $total_bonos = 0;
  $total_otras_bonificaciones = 0;
  $total_copago = 0;
  $total_pagos_prorrateados = 0;
  $lista_bonos = parsearLista($res["LisVenConv"]->LisVenConvType->ListaBonosMul->ListaBonosMulType);
  foreach ($lista_bonos as $key_b => $bono) {
    $fecha_pago = date("Y-m-d", time()); # FECHA ACTUAL
    $flag_elec = 1; # FLAG_ELEC
    $folio_bono = $bono->FolioBono; # NRO_DOCTO

    # Lista Prestaciones #
    $monto_bono = 0;
    $monto_copago = 0;
    $monto_otras_bonificaciones = 0;
    $lista_prestaciones = parsearLista($bono->LisPrestVta->LisPrestVtaType);
    foreach ($lista_prestaciones as $key_p => $prestacion) {
      $monto_copago += $prestacion->MontoCopago;
      $monto_bono += $prestacion->MontoBon;
      # Lista Bonificaciones Prestación #
      $lista_otras_bonificaciones_prestacion = parsearLista($prestacion->ListaOtrasBon->ListaOtrasBonType);
      foreach ($lista_otras_bonificaciones_prestacion as $key_ba => $bonificacion_adicional) {
        $monto_otras_bonificaciones += $bonificacion_adicional->MtoBonAdic;
      }
    }

    echo "<br>";
    echo "monto_bono $key_b: $monto_bono<br>";
    echo "monto_otras_bonificaciones $key_b: $monto_otras_bonificaciones<br>";
    echo "monto_copago $key_b: $monto_copago<br><br>";

    # Pagos Prorrateados (Excedente y otros) #
    $lista_pagos_prorrateado = parsearLista($bono->ListaPagPro->ListaPagProType);
    foreach ($lista_pagos_prorrateado as $key_pp => $pago_prorrateado) {
      $total_pagos_prorrateados += $pago_prorrateado->MtoTransacP;
    }
    
    # Actualizar Montos Totales
    $total_bonos += $monto_bono;
    $total_otras_bonificaciones += $monto_otras_bonificaciones;
    $total_copago += $monto_copago;
  }

  echo "total_bonos: $total_bonos<br>";
  echo "total_otras_bonificaciones: $total_otras_bonificaciones<br>";
  echo "total_copago: $total_copago<br>";
  echo "total_pagos_prorrateados: $total_pagos_prorrateados<br>";
  echo "monto_pagado_atencion: $monto_pagado_atencion<br>";

  $respuesta = array("exito" => true);
  echo json_encode($respuesta);
  exit(0);
} catch (SoapFault $sf) {
  mostrarMensajeError($sf->getMessage());
}

print "</pre>";