<?php
$pantalla_actual = 'CIE_ATE';
$hora = time();
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$busqueda = '';
if (isset($_GET['estado']) && ($_GET['estado'] != '')) $busqueda = ' AND a.CIERRE_ATE="' . $_GET['estado'] . '"';

$anio = date('Y');
if (isset($_GET['anio']) && ($_GET['anio'] != '')) {
  $anio = $_GET['anio'];
}

$busqueda .= 'AND DATE_FORMAT(a.FECHA, \'%Y\')=' . $anio;

if (isset($_GET['busq']) && ($_GET['busq'] != '')) {
  $b = $_GET['busq'];
  $busqueda .= '  AND (CONCAT(IFNULL(CONCAT(p1.NOMBRES,\' \'),\'\'),IFNULL(CONCAT(p1.APELLIDO_PATERNO,\' \'),\'\'), IFNULL(p1.APELLIDO_MATERNO,\'\')) LIKE \'%' . $b . '%\' OR p1.NRO_RUT = \'' . $b . '\' OR a.ID_ATENCION = \'' . $b . '\' OR p1.NRO_RUT = \'' . $b . '\' OR cct.NOMBRE LIKE \'%' . $b . '%\')';
} //

$cant_reg = 100;    //Limito la busqueda
$inicio = 0;
$pagina = 1;
if (isset($_GET["pag"])) { //examino la página a mostrar y el inicio del registro a mostrar
  $pagina = $_GET["pag"];
  $inicio = ($pagina - 1) * $cant_reg;
}
/* Consulta para saber total de paginas */
if (isset($_GET['tpag'])) {
  $total_paginas = $_GET['tpag'];
} else {
  $consultaTotal = "SELECT ID_ATENCION 
    FROM atenciones a
    INNER JOIN personas p1 ON a.ID_CLIENTE = p1.ID_PERSONA
    LEFT JOIN centros_contacto cct ON a.ID_CENTRO_CONTACTO = cct.ID_CENTRO_CONTACTO 
    WHERE MONTO_ATENCION > 0 AND a.FLAG_ELIMINADO = 0 $busqueda";
  $qtotal = $mysqli->prepare($consultaTotal);
  echo $mysqli->error;
  $qtotal->execute();
  $qtotal->store_result();
  $totalRows_total = $qtotal->num_rows;
  $qtotal->close();
  $total_paginas = ceil($totalRows_total / $cant_reg);
}

$consulta = "SELECT a.ID_ATENCION, DATE_FORMAT(a.FECHA,'%d/%m/%Y') AS FECHA, a.MONTO_ATENCION, a.MONTO_PAGADO, a.OBS, a.ORDEN_MEDICA,
(MONTO_ATENCION - MONTO_PAGADO - MONTO_DESCUENTO - MONTO_CONDONADO - (MONTO_ATENCION*PCTJE_DESCUENTO / 100) - (CASE WHEN ID_COBRANZA_CONVENIO IS NOT NULL THEN MONTO_CONVENIO ELSE 0 END)),
CONCAT(IFNULL(p1.NOMBRES, ''),' ', IFNULL(p1.APELLIDO_PATERNO, ''),' ', IFNULL(p1.APELLIDO_MATERNO, '')), p1.NRO_RUT, p1.DV_RUT, p2.APELLIDO_PATERNO AS DR, em.NBR, cct.NOMBRE, a.CIERRE_ATE
FROM atenciones a
INNER JOIN personas p1 ON a.ID_CLIENTE=p1.ID_PERSONA 
LEFT JOIN personas p2 ON a.ID_MEDICO=p2.ID_PERSONA 
LEFT JOIN empresas em ON a.ID_PREVISION=em.ID_EMPRESA 
LEFT JOIN centros_contacto cct ON a.ID_CENTRO_CONTACTO=cct.ID_CENTRO_CONTACTO 
WHERE MONTO_ATENCION > 0 AND a.FLAG_ELIMINADO = 0
$busqueda
ORDER BY a.ID_ATENCION DESC
LIMIT ?, ?";
$qatenciones = $mysqli->prepare($consulta);
$qatenciones->bind_param('ii', $inicio, $cant_reg);
$qatenciones->execute();
$qatenciones->bind_result(
  $at_id,
  $at_fecha,
  $at_monto,
  $at_montoPagado,
  $at_obs,
  $at_ordenMedica,
  $at_saldo,
  $at_paciente,
  $at_nroRut,
  $at_dvRut,
  $at_medico,
  $at_prevision,
  $at_procedencia,
  $at_estado
);
$qatenciones->store_result();
$totalRows_atenciones = $qatenciones->num_rows;


$optionsAnios = '';
for ($i = date('Y'); $i >= 2013; $i--) {
  $selected = '';
  if (isset($_GET['anio']) && $_GET['anio'] == $i) {
    $selected = 'selected';
  }
  $optionsAnios .= '<option value="' . $i . '" ' . $selected . '>' . $i . '</option>';
}


$optionsEstados = '<option value="">--Estados--</option>';
$selected = '';
if (isset($_GET['estado']) && $_GET['estado'] == 'N') {
  $selected = 'selected';
}
$optionsEstados .= '<option value="N" ' . $selected . '>No Cerrado</option>';
$selected = '';
if (isset($_GET['estado']) && $_GET['estado'] == 'S') {
  $selected = 'selected';
}
$optionsEstados .= '<option value="S" ' . $selected . '>Cerrado</option>';

ob_start();
?>

<form id="formBuscar" name="formBuscar" method="get" action="" class="smart-form">
  <table class="table table-responsive">
    <tr>
      <td align="left" style="width:6em;">
        <h5>Busqueda:</h5>
      </td>
      <td style="width:16em;">
        <label class="input">
          <input type="search" name="busq" class="input-sm" autofocus="autofocus" placeholder="Atención, Nombre, RUT, Local" value="<?php if (isset($_GET['busq'])) echo $_GET['busq'] ?>" />
        </label>
      </td>
      <td style="width:6em;">
        <label class="select">
          <select name="anio">
            <?php echo $optionsAnios; ?>
          </select><i></i>
        </label>
      </td>
      <td style="width:8em;">
        <label class="select">
          <select name="estado">
            <?php echo $optionsEstados; ?>
          </select><i></i>
        </label>
      </td>
      <td style="width:6em;">
        <a id="buscar" class="btn btn-link" title=""><i class="fa fa-search fa-lg"></i></a>
      </td>
      <td style="width:6em;">
        <a class="btn btn-info btn-sm" tittle="Ver Todo" onclick="location.href='l_atenciones.php'"> Ver Todo </a>
      </td>
      <td>
        <div class="text-right"><?php if ($total_paginas > 1) {
                                  echo paginacion('l_atenciones.php?', $_SERVER['QUERY_STRING'], $total_paginas, $pagina, 2, 2);
                                } ?></div>
      </td>
    </tr>
  </table>
</form>
<table class="table table-hover table-bordered">
  <thead>
    <tr>
      <th>Atención</th>
      <th>Fecha</th>
      <th>Local</th>
      <th>Paciente</th>
      <th>Rut</th>
      <th>Previsión</th>
      <th>Dr(a)</th>
      <th>Monto Atención</th>
      <th>Monto Pagado</th>
      <th>Saldo</th>
      <th>Observaciones</th>
      <th>Examenes<br />y Pagos</th>
      <th>Estado</th>
    </tr>
  </thead>
  <tbody>
    <?php while ($qatenciones->fetch()) {   ?>
      <tr>
        <td><?php echo $at_id; ?></td>
        <td><?php echo $at_fecha; ?></td>
        <td><?php echo $at_procedencia; ?></td>
        <td><?php echo $at_paciente ?></td>
        <td><?php echo number_format($at_nroRut, '0', ',', '.') . "-" . $at_dvRut; ?></td>
        <td><?php echo $at_prevision; ?></td>
        <td><?php echo $at_medico; ?></td>
        <td>$<?php echo number_format($at_monto, '0', ',', '.'); ?></td>
        <td>$<?php echo number_format($at_montoPagado, '0', ',', '.'); ?></td>
        <td>
          <?php if ($at_saldo > 0) { ?>
            <font color="#FF0000">$<?php echo number_format($at_saldo, '0', ',', '.'); ?></font>
          <?php } else { ?>
            <font color="#00CC00">$<?php echo number_format($at_saldo, '0', ',', '.'); ?></font>
          <?php } ?>
        </td>
        <td align="left"><?php echo $at_obs; ?></td>
        <td align="center">
          <a class="btn btn-link" onclick="javascript:popup('pagos.php?idate=<?php echo $at_id ?>', 960, 768)"><i class="fa fa-money fa-lg"></i></a>
        </td>
        <td align="center">
          <?php if ($at_estado == 'N') {
            echo 'No Cerrado';
          } else {
            echo 'Cerrado';
          } ?>
        </td>
      </tr>
    <?php }
    $qatenciones->close(); ?>
  </tbody>
</table>

<?php if ($total_paginas > 1) {
  echo '<div class="text-center" style="padding-top:1em;">' . paginacion('l_atenciones.php?', $_SERVER['QUERY_STRING'], $total_paginas, $pagina) . '</div>';
} ?>

<?php if ($totalRows_atenciones == 0) { ?>
  <div class="text-center" style="padding-top:1em;">No se encontraron resultados para su búsqueda</div>
<?php } ?>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title'],
  "icon" => 'fa fa-cog'
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php

  include("../inc/ribbon.php");
  ?>

  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<script src="../assets/js/popup.js"></script>
<script>
  $(document).ready(function() {
    $('#buscar').click(function() {
      $('#formBuscar').submit();
    });
  })
</script>

<?php
//include footer
include("../inc/google-analytics.php");
?>