<?php
# $pagina = 65;
define('PERMITIDO', true);
require_once("../inc/init.php");

$filtroCodFonasa = $codFonasaExamenesNotNull ? " AND ex.COD_FONASA != ''" : "";
$filtroAnticuerpos = $_POST["id_empresa"] != 37 ? " AND ex.COD_INTERNO not in ('04.05.284', '04.05.384')" : "";

if (isset($_POST["busqueda"])) {
	$busqueda = "%{$_POST['busqueda']}%";
	$qExamenes = $mysqli->prepare("SELECT pe.COD_EXAMEN, ex.NOMBRE, ex.SINONIMOS
	FROM precios_examenes pe
	INNER JOIN examenes ex ON pe.COD_EXAMEN = ex.COD_INTERNO
	WHERE (ex.NOMBRE LIKE ? OR ex.SINONIMOS LIKE ? OR ex.COD_INTERNO LIKE ?)
		AND pe.ID_EMPRESA = ?
		AND ex.FLAG_ELIMINADO IS NULL
		AND (ex.GENERO = ? OR ex.GENERO = 'F/M')
		AND ex.COD_INTERNO NOT IN (SELECT COD_EXAMEN FROM examenes_cotizaciones WHERE ID_COTIZACION = ?)
		$filtroCodFonasa $filtroAnticuerpos
		GROUP BY pe.COD_EXAMEN
	ORDER BY ex.NOMBRE ASC
	LIMIT 30");
	echo $mysqli->error;
	$qExamenes->bind_param('sssisi', $busqueda, $busqueda, $busqueda, $_POST["id_empresa"], $_POST["genero"], $_POST["id_cotizacion"]);
	$qExamenes->execute();
	$qExamenes->bind_result($codExamen, $nombreExamen, $sinonimosExamen);

	$options = array();
	while ($qExamenes->fetch()) {
		$texto = $sinonimosExamen ? "$nombreExamen ($sinonimosExamen)" : $nombreExamen;
		$options[] = array('codExamen' => $codExamen, 'nombreExamen' => $texto);
	}
	$qExamenes->close();


	echo json_encode($options);
	return;
}
