<?php
$pagina = 65;
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");

// function VerResulEmi($NumTransac) {
//   global $urlWsdlImed;

//   try {
//     $client = new SoapClient($urlWsdlImed, ['trace' => 1]);
//     $resVerResulEmi = $client->__soapCall("VerResulEmi", [
//       "CodUsuardio" => "78385630-1",
//       "CodClave" => "78385630",
//       "NumTransac" => $NumTransac
//     ]);
//     return $resVerResulEmi;
//   } catch (SoapFault $sf) {
//     return false; # $sf->getMessage()
//   }
// }

// $options_formaPago = "";
// $qOptionsFormaPago = $mysqli->prepare("SELECT CODIGO, DESCRIPCION_CG FROM codigos_generales WHERE COD_TABLA = 'SIS_FORPAG' AND DESCRIPCION_CG != 'BONO'");
// $qOptionsFormaPago->execute();
// $qOptionsFormaPago->bind_result($codigoMetodoPago, $descripcionMetodoPago);
// $qOptionsFormaPago->store_result();
// while ($qOptionsFormaPago->fetch()) {
//   $options_formaPago .= "<option value='$codigoMetodoPago'> $descripcionMetodoPago </option>";
// }
// $qOptionsFormaPago->close();

$idCotizacion = isset($_GET['idcot']) ? $_GET['idcot'] : "-1";
$urlModal = "md_examenesCotizacion.php?idcot=$idCotizacion";

$qCotizacion = $mysqli->prepare("SELECT a.ID_CENTRO_CONTACTO, a.ID_CONVENIO, a.ID_PREVISION,
CONCAT_WS('-', p.NRO_RUT, p.DV_RUT), p.GENERO, prev.NBR, prev.COD_FINANCIADOR_IMED, conv.NBR, cc.NOMBRE
FROM cotizaciones a
LEFT JOIN personas p ON p.ID_PERSONA = a.ID_CLIENTE
LEFT JOIN empresas prev ON prev.ID_EMPRESA = a.ID_PREVISION
LEFT JOIN empresas conv ON conv.ID_EMPRESA = a.ID_CONVENIO
LEFT JOIN centros_contacto cc ON cc.ID_CENTRO_CONTACTO = a.ID_CENTRO_CONTACTO
WHERE a.ID_COTIZACION = ?");
$qCotizacion->bind_param('i', $idCotizacion);
$qCotizacion->execute();
$qCotizacion->bind_result(
  $ate_idCentroContacto,
  $ate_idConvenio,
  $ate_idPrevision,
  $ate_rutPaciente,
  $ate_generoPaciente,
  $ate_nbrPrevision,
  $ate_codFinanciadorImedPrevision,
  $ate_nbrConvenio,
  $ate_nombreCentroContacto
);
$qCotizacion->store_result();
$qCotizacion->fetch();
$qCotizacion->close();

if ($ate_idPrevision == 31) {
  $ate_idPrevision = 63;
  $ate_nbrPrevision = "COPAGO NIVEL 3";
}

$qExamenes = $mysqli->prepare("SELECT ea.COD_EXAMEN, ea.F_HIJO, ea.PRECIO_EXAMEN, ea.PREV, ea.ID_EXCOT,
ex.NOMBRE, ex.FLAG_AGRUPACION, ex.FLAG_AGRUPACION_HOMOLOGADA_IMED, em.NBR  
FROM examenes_cotizaciones ea
INNER JOIN examenes ex ON ea.COD_EXAMEN = ex.COD_INTERNO 
LEFT JOIN empresas em ON ea.PREV = em.ID_EMPRESA 
WHERE ea.ID_COTIZACION = ? AND ea.F_HIJO IS NULL");
$qExamenes->bind_param('i', $idCotizacion);
$qExamenes->execute();
$qExamenes->bind_result(
  $ex_codExamen,
  $ex_flagHijo,
  $ex_precio,
  $ex_prev,
  $ex_idExcot,
  $ex_nombre,
  $ex_flagAgrupacion,
  $ex_flagAgrupacionHomologada,
  $ex_nbr
);
$qExamenes->store_result();

ob_start();
?>

<div class="modal-header">
  <button type="button" class="close" data-dismiss="modal" aria-hidden="true">
    &times;
  </button>
  <h4 class="modal-title" id="myModalLabel"> Ingreso de exámenes de cotización n° <?= $idCotizacion ?></h4>
</div>

<div class="modal-body smart-form">
  <form action="sql_cod.php" method="post" id="formAgregarExamen" class="smart-form">
    <div class="row">
      <section class="col">
        <div class="inline-group">
          <?php if ($ate_idConvenio) { ?>
            <label class="radio">
              <input type="radio" id="0" name="id_empresa" value="<?= $ate_idConvenio ?>" <?php if ((!isset($_GET["pre"]) && $ate_idConvenio) || $_GET["pre"] == "0") echo "checked" ?>>
              <i></i>Precio Convenio (<?= $ate_nbrConvenio ?>)
            </label>
          <?php } ?>
          <label class="radio">
            <input type="radio" id="1" name="id_empresa" value="<?= $ate_idPrevision ?>" <?php if ((!isset($_GET["pre"]) && !$ate_idConvenio) || $_GET["pre"] == "1") echo "checked" ?>>
            <i></i>Precio Previsión (<?= $ate_nbrPrevision ?>)
          </label>
          <label class="radio">
            <input type="radio" id="2" name="id_empresa" value="37" <?php if ($_GET["pre"] == "2") echo "checked" ?>>
            <i></i>Precio Particular
          </label>
        </div>
      </section>
    </div>
    <div class="row">
      <section class="col col-9">
        <input id="selectExamen" name="cod_examen" style="width: -webkit-fill-available;">
      </section>
      <section class="col col-2">
        <a class="btn btn-sm btn-success btn-agregarExamen" data-form="#formAgregarExamen"> <i class="fa fa-lg fa-plus"> </i> Agregar examen </a>
      </section>
    </div>
    <input type="hidden" name="formAgregarExamen" value="formAgregarExamen" />
    <input type="hidden" name="id_cotizacion" value="<?= $idCotizacion ?>" />
  </form>

  <table class="table table-hover table-responsive">
    <thead>
      <tr bgcolor="#999999">
        <th>Código</th>
        <th>Nombre</th>
        <th>Empresa</th>
        <th>Precio</th>
        <?php if (in_array($ate_idPrevision, [17, 18, 19, 20, 21, 22])) echo '<th>Con descuento</th>'; ?>
        <th>&nbsp;</th>
      </tr>
    </thead>
    <tbody>
      <?php while ($qExamenes->fetch()) {
        $precio_descuento = $ex_precio * (100 - $_GET['pctje_descuento']) / 100; ?>
        <tr>
          <td><?= $ex_codExamen ?></td>
          <td><?= $ex_nombre ?></td>
          <td><?= $ex_prev == 0 ? "PARTICULAR" : $ex_nbr ?></td> <!-- # prev = 0 para examenes con valor particular -->
          <td><?= "$ " . number_format($ex_precio, '0', ',', '.'); ?></td>
          <?php
          if (in_array($idemp, [17, 18, 19, 20, 21, 22])) {
            echo "<td>";
            echo !in_array($ex_prev, [0, 37]) ? "$ " . number_format($precio_descuento, "0", ",", ".") : "-";
            echo "</td>";
          }
          ?>
          <td>
            <a class="btn btn-link btn-eliminarExamen" data-id_exa="<?= $ex_idExcot ?>" data-cod_ex="<?= $ex_codExamen ?>">
              <i class="fa fa-trash-o fa-lg txt-color-red"></i>
            </a>
          </td>
        </tr>
      <?php }
      $qExamenes->close(); ?>
    </tbody>
  </table>
</div>

<div class="modal-footer">
  <button type="button" class="btn btn-default" data-dismiss="modal">
    Cerrar
  </button>
</div>

<script>
  $(document).ready(function() {
    $('#selectExamen').select2({
      placeholder: "Buscar examen",
      minimumInputLength: 1,
      formatInputTooShort: function() {
        return 'Ingrese uno o más caracteres';
      },
      formatSearching: "Buscando...",
      formatNoMatches: "No se encontraron resultados",
      ajax: {
        type: "POST",
        url: "./ajax_examenes.php",
        dataType: 'json',
        quietMillis: 100,
        data: function(term, page) {
          return {
            busqueda: term,
            id_cotizacion: "<?= $idCotizacion ?>",
            genero: "<?= $ate_generoPaciente ?>",
            id_empresa: $("input[name='id_empresa']:checked").val()
          };
        },
        results: function(data) {
          return {
            results: $.map(data, function(item) {
              return {
                id: item.codExamen,
                text: item.codExamen + " - " + item.nombreExamen,
              }
            })
          };
        },
        cache: true
      },
      escapeMarkup: function(m) {
        return m;
      } // we do not want to escape markup since we are displaying html in results
    });

    $(".btn-agregarExamen").on("click", function() {
      // $(this).attr('disabled'); 
      $('.btn-agregarExamen').prop('disabled', true);
      var form = $(this).data("form");
      $.post($(form).attr("action"), $(form).serialize(), function(data) {
        if (data.exito) {
          exito();
          $('#md_examenesCotizacion .modal-content').load("<?= $urlModal ?>"+"&pre="+$('input[name=id_empresa]:checked').attr('id'));
          $('#md_examenesCotizacion').on('hidden.bs.modal', function() {
            location.reload();
          });
        } else {
          // $(this).removeAttr('disabled'); 
          // $('.btn-agregarExamen').prop('disabled', false);
          error(data.mensaje);
        }
      }, 'json');
    });

    $(".btn-eliminarExamen").on("click", function() {
      if (confirm("Desea eliminar el examen de la cotización?")) {
        $.post("sql_cod.php", {
          eliminarExamen: 1,
          id_examen_cotizacion: $(this).data("id_exa"),
          cod_examen: $(this).data("cod_ex"),
          id_cotizacion: "<?= $idCotizacion ?>"
        }, function(data) {
          if (data.exito) {
            exito();
            $('#md_examenesCotizacion .modal-content').load("<?= $urlModal ?>"+"&pre="+$('input[name=id_empresa]:checked').attr('id'));
            $('#md_examenesCotizacion').on('hidden.bs.modal', function() {
              location.reload()
            });
          } else {
            error(data.mensaje);
          }
        }, 'json');
      }
    });
  });
</script>