<?php
$pagina = 65; # Cotizaciones (ver listado, modificación y eliminación)
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once('../Connections/conexionlab.php');
include ('../pdfClasses/class.ezpdf.php');
include('../assets/php/noCache.php');
include(__DIR__ . '/lib.php');
noCache();

$pdf = new Cezpdf('LETTER');
$pdf->selectFont('../pdfClasses/fonts/Helvetica.afm');
$pdf->ezSetCmMargins(1, 1, 1, 1);

$qUrlWebLaboratorio = $mysqli->prepare("SELECT VALOR FROM parametros_sistema WHERE COD_PARAMETRO = 9");
$qUrlWebLaboratorio->execute();
$qUrlWebLaboratorio->bind_result($urlWebLaboratorio);
$qUrlWebLaboratorio->fetch();
$qUrlWebLaboratorio->store_result();
$qUrlWebLaboratorio->close();

$qNombreLaboratorio = $mysqli->prepare("SELECT VALOR FROM parametros_sistema WHERE COD_PARAMETRO = 10");
$qNombreLaboratorio->execute();
$qNombreLaboratorio->bind_result($nombreLaboratorio);
$qNombreLaboratorio->fetch();
$qNombreLaboratorio->store_result();
$qNombreLaboratorio->close();

# cotización
$id_cotizacion = $_GET['id_cot'];
mysql_select_db($database_conexionlab, $conexionlab);
$query_cotizacion = "SELECT c.ID_COTIZACION, c.ID_CLIENTE, DATE_FORMAT(c.FECHA,'%d/%m/%Y') AS F_COTIZACION, c.ID_CENTRO_CONTACTO,
c.ID_MEDICO, c.MONTO_ATENCION, c.MONTO_PAGADO, c.MONTO_DESCUENTO, c.MONTO_CONDONADO, c.ORDEN_MEDICA,
c.OBS, p.NOMBRES, p.APELLIDO_PATERNO, p.APELLIDO_MATERNO, YEAR(CURDATE())-YEAR(p.FECHA_NACIMIENTO) AS EDAD,
(((YEAR(CURDATE())-YEAR(p.FECHA_NACIMIENTO))*12)+(MONTH(CURDATE())-MONTH(p.FECHA_NACIMIENTO))) AS EDAD_MES, 
p.NRO_RUT, p.DV_RUT, DATE_FORMAT(p.FECHA_NACIMIENTO,'%d-%m-%Y') AS NACIMIENTO, m.APELLIDO_PATERNO AS DR,
e.NOMBRE_E, cc.NOMBRE, cg.DESCRIPCION_CG 
FROM cotizaciones c
LEFT JOIN personas p ON c.ID_CLIENTE = p.ID_PERSONA
LEFT JOIN personas m ON c.ID_MEDICO = m.ID_PERSONA
LEFT JOIN empresas e ON c.ID_PREVISION = e.ID_EMPRESA
LEFT JOIN centros_contacto cc ON c.ID_CENTRO_CONTACTO = cc.ID_CENTRO_CONTACTO
LEFT JOIN codigos_generales cg ON c.COD_DIAGNOSTICO = cg.CODIGO AND cg.COD_TABLA ='SIS_DIAGNO'
WHERE c.ID_COTIZACION = $id_cotizacion";
$cotizacion = mysql_query($query_cotizacion, $conexionlab) or die(mysql_error());
$row_cotizacion = mysql_fetch_assoc($cotizacion);

# examenes
mysql_select_db($database_conexionlab, $conexionlab);
$query_examenes_cotizacion = "SELECT ec.COD_EXAMEN, ec.PRECIO_EXAMEN, ex.NOMBRE, ex.NOMBRE_INF, ex.COD_FONASA, p.NBR, cg.DESCRIPCION_CG
FROM examenes_cotizaciones ec
LEFT JOIN examenes ex ON ec.COD_EXAMEN = ex.COD_INTERNO
LEFT JOIN empresas p ON ec.PREV = p.ID_EMPRESA
LEFT JOIN codigos_generales cg ON cg.CODIGO = ex.PREPARACION AND cg.COD_TABLA = 'SIS_PREPAR'
WHERE ID_COTIZACION = $id_cotizacion AND ec.F_HIJO IS NULL";
$examenes_cotizacion = mysql_query($query_examenes_cotizacion, $conexionlab) or die(mysql_error());

#################################################################################################################################################################
#################################################################################################################################################################
#################################################################################################################################################################

$pcrInfo = "El examen PCR SARS-CoV-2 para diagnóstico de Covid-19 no requiere orden médica. Sin embargo, en caso que su resultado sea Positivo, usted debe consultar a un médico para que lo oriente en los cuidados que debe tener, además de notificar su caso en Epivigila, y emitir la licencia médica correspondiente.";
$paciente = $row_cotizacion['NOMBRES']." ".$row_cotizacion['APELLIDO_PATERNO']." ".$row_cotizacion['APELLIDO_MATERNO'];
$rut = number_format($row_cotizacion['NRO_RUT'],0,',','.')."-".$row_cotizacion['DV_RUT'];
$edad = ($row_cotizacion['EDAD_MES'] < "12") ? $row_cotizacion['EDAD_MES']." Meses" : $row_cotizacion['EDAD']." Años";

# tabla cotizacion
$data_ate = [
  ['1' => "Paciente: ".$paciente,          '2' => "Cotización: ".$row_cotizacion['ID_COTIZACION']],
  ['1' => "Rut: ".$rut,                    '2' => "Fecha: ".$row_cotizacion['F_COTIZACION']],
  ['1' => "Edad: ".$edad,                  '2' => "Local: ".$row_cotizacion['NOMBRE']],
  ['1' => "Dr(a): ".$row_cotizacion['DR'], '2' => "",]
];
$titles_ate = [
  '1'=>'',
  '2'=>''
];
$options_ate = [
  'shadeCol' => [0.9, 0.9, 0.9],
  'showLines' => 0, //bordes de la tabla
  'width' => 550,
  'showHeadings' => 0,
  'fontSize'=> 9,
  'rowGap' => 1,
  'shaded' => 0, //gris entrelineas
  'cols'=> ['1'=> ['justification' => 'left', 'width'=>270], '2'=> ['justification' =>'left']]
];

# tabla exámenes
$titles = [
  'COD_EXAMEN' => '<b>Código</b>',
  'NOMBRE' => '<b>Nombre Examen</b>',
  # 'PREP'=>'<b>Preparación</b>'
];
$options = [
  'shadeCol' => [0.9, 0.9, 0.9],
  'showLines' => 1,
  'xOrientation' => 'center',
  'width' => 550,
  'fontSize' => 9,
  'shaded' => 0, # gris entrelineas
  'cols' => [
    'COD_EXAMEN'=>['justification' => 'left', 'width' => 60],
    'NOMBRE' => ['justification' => 'left'],
    # 'PREP' => ['justification' => 'left', 'width' => 120],
  ]
];

# datos exámenes
$flag_pcr = FALSE;

while ($row_exam = mysql_fetch_assoc($examenes_cotizacion)) {
  $data[] = [
    'COD_EXAMEN' => $row_exam['COD_FONASA'],
    'NOMBRE' => $row_exam['NOMBRE_INF'] ? $row_exam['NOMBRE_INF'] : $row_exam['NOMBRE'],
    # 'PREP' => $row_exam['DESCRIPCION_CG'],
  ];
  if ($row_exam['COD_EXAMEN'] == "00.00.069") $flag_pcr = TRUE;
}

# Informe
$logo_empresa = imagecreatefromjpeg('../assets/img/logo_empresa2.jpg');
$pdf->addImage($logo_empresa, 30, 710, 180);

$pdf->addText(378, 745, 9, $urlWebLaboratorio);
$pdf->addText(380, 735, 9, 'Escanea y descarga la App');
$codigo_qr = imagecreatefrompng ("../assets/img/codigo_qr_app.png");
$pdf->addImage($codigo_qr, 500, 720, 50);

$pdf->ezText("\n\n\n\n\n\n\n\n", 5);
$pdf->ezText(strtoupper($nombreLaboratorio), 11);
$pdf->ezText("COTIZACIÓN DE EXÁMENES", 9);
$pdf->ezText("\n", 5);
$pdf->ezTable($data_ate, $titles_ate, "", $options_ate);
$pdf->ezText("\n", 5);
$pdf->ezTable($data, $titles, "", $options);
$pdf->ezSetCmMargins(1,1,1,2.2);
$pdf->ezText("\n", 9);
$pdf->ezSetCmMargins(1,1,1,1);
if($flag_pcr) $pdf->ezText("\n".$pcrInfo, 8);

# Membrete
$date_time = calcularFechaRetiroCotizacion($id_cotizacion);
$hora = $date_time->format('H:i');
$dia = $date_time->format('d-m-Y');

$membrete  = "Cotización realizada con información entregada por el propio paciente.\n";
if (!$flag_pcr) $membrete .= "Los resultados estarían disponibles a partir de las $hora hrs. del día $dia.\n";
$membrete .= "Si cambia la fecha de toma de muestra, también cambia la fecha de entrega de resultados.\n";
$membrete .= "Para más información llamar al teléfono 32-2714189.\nAgradecemos su confianza.";

$pdf->ezText("\n", 5);
$pdf->ezText($membrete, 8);

ob_end_clean();
$pdf->ezStream();
?>