<?php
$pagina = 65; # Cotizaciones (ver listado, modificación y eliminación)
define('PERMITIDO', true);
require_once('../inc/init.php');
$hoy = date('Y-m-d', time());

# ingresar nueva cotizacion
if (isset($_POST["MM_insert"]) && $_POST["MM_insert"] == "formCotizacion") {
  $estado = 'COTIZACION';
  $fecha = $_POST['FECHA'];
  $hora = date("H:i");
  $us = $usuario_id;
  $fechaTR = 'NULL';
  $horaTR = 'NULL';
  $usTR = 'NULL';

  if (!isset($_POST['ID_CLIENTE']) || $_POST['ID_CLIENTE'] == "") mostrarMensajeError("Debe seleccionar Paciente");
  if (!isset($_POST['ID_MEDICO']) || $_POST['ID_MEDICO'] == "")   mostrarMensajeError("Debe seleccionar Médico");

  $insertSQL = sprintf(
    "INSERT INTO cotizaciones (ID_USUARIO, TIPO_CLIENTE, ID_CLIENTE, ESTADO, FECHA, HORA, ID_CENTRO_CONTACTO, ID_MEDICO, COD_DIAGNOSTICO, ID_CONVENIO, PCTJE_DESCUENTO, ID_PREVISION, FECHA_ULT_REGLA, NIVEL_URGENCIA, MONTO_DESCUENTO, FLAG_ACEPTA_C, OBS, CIERRE_ATE, FECHA_TM, HORA_TM, RESP_TM, FECHA_R, HORA_R, RESP_R, TURNO_DIALISIS)
  VALUES ('$us', 'P', %s, '$estado', '$fecha', '$hora',%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, 'N', $fechaTR, $horaTR,$usTR, $fechaTR, $horaTR, $usTR, %s)",
    GetSQLValueString($_POST['ID_CLIENTE'], "int"),
    GetSQLValueString($_POST['ID_CENTRO_CONTACTO'], "int"),
    GetSQLValueString($_POST['ID_MEDICO'], "int"),
    GetSQLValueString($_POST['COD_DIAGNOSTICO'], "int"),
    GetSQLValueString($_POST['ID_CONVENIO'], "int"),
    GetSQLValueString($_POST['PCTJE_DESCUENTO'], "double"),
    GetSQLValueString($_POST['ID_PREVISION'], "int"),
    GetSQLValueString($_POST['FECHA_ULT_REGLA'], "date"),
    GetSQLValueString($_POST['NIVEL_URGENCIA'], "int"),
    GetSQLValueString($_POST['MONTO_DESCUENTO'], "int"),
    GetSQLValueString(isset($_POST['FLAG_ACEPTA_C']) ? "true" : "", "defined", "1", "0"),
    GetSQLValueString($_POST['OBS'], "text"),
    GetSQLValueString($_POST['ID_TURDIA'], "int")
  );
  mysql_select_db($database_conexionlab, $conexionlab);
  $Result1 = mysql_query($insertSQL, $conexionlab) or die(mysql_error());
  $idcot = mysql_insert_id();
  $respuesta = array('exito' => true, 'id' => $idcot);
  echo json_encode($respuesta);
  exit(0);
}

# modificar cotizacion
if ((isset($_POST["MM_update"])) && ($_POST["MM_update"] == "formModificarCotizacion")) {
  $updateSQL = sprintf(
    "UPDATE cotizaciones SET FECHA=%s, ID_CENTRO_CONTACTO=%s, COD_DIAGNOSTICO=%s, ID_CONVENIO=%s, PCTJE_DESCUENTO=%s, FECHA_ULT_REGLA=%s, NIVEL_URGENCIA=%s, MONTO_ATENCION=%s, MONTO_DESCUENTO=%s, ORDEN_MEDICA=%s, FLAG_ACEPTA_C=%s, OBS=%s, TURNO_DIALISIS=%s WHERE ID_COTIZACION=%s",
    GetSQLValueString($_POST['FECHA'], "date"),
    GetSQLValueString($_POST['ID_CENTRO_CONTACTO'], "int"),
    GetSQLValueString($_POST['COD_DIAGNOSTICO'], "int"),
    GetSQLValueString($_POST['ID_CONVENIO'], "int"),
    GetSQLValueString($_POST['PCTJE_DESCUENTO'], "double"),
    GetSQLValueString($_POST['FECHA_ULT_REGLA'], "date"),
    GetSQLValueString($_POST['NIVEL_URGENCIA'], "int"),
    GetSQLValueString($_POST['MONTO_ATENCION'], "int"),
    GetSQLValueString($_POST['MONTO_DESCUENTO'], "int"),
    GetSQLValueString($_POST['ORDEN_MEDICA'], "text"),
    GetSQLValueString(isset($_POST['FLAG_ACEPTA_C']) ? "true" : "", "defined", "1", "0"),
    GetSQLValueString($_POST['OBS'], "text"),
    GetSQLValueString($_POST['ID_TURDIA'], "int"),
    GetSQLValueString($_POST['ID_COTIZACION'], "int")
  );
  mysql_select_db($database_conexionlab, $conexionlab);
  $Result1 = mysql_query($updateSQL, $conexionlab) or die(mysql_error());
  $respuesta = array('exito' => true);
  echo json_encode($respuesta);
  exit(0);
}

# eliminar cotización
if ((isset($_POST['eliminar_cot'])) && ($_POST['eliminar_cot'] != "")) {
  $qEliminarCotizacion = $mysqli->prepare("DELETE FROM cotizaciones WHERE ID_COTIZACION = ?");
  $qEliminarCotizacion->bind_param('i', $_POST['id_cot']);
  $qEliminarCotizacion->execute();
  $respuesta = array('exito' => true, 'mensaje' => 'Cotización eliminada correctamente');
  echo json_encode($respuesta);
}

if ((isset($_POST['cambiarPaciente'])) && ($_POST['cambiarPaciente'] != "")) {
  $qSelectNuevaPrevision = $mysqli->prepare("SELECT ID_PREVISION FROM personas WHERE ID_PERSONA = ?");
  $qSelectNuevaPrevision->bind_param('i', $_POST['id_paciente']);
  $qSelectNuevaPrevision->execute();
  $qSelectNuevaPrevision->bind_result($id_nueva_prev);
  $qSelectNuevaPrevision->store_result();
  $qSelectNuevaPrevision->fetch();
  $qUpdatePrevisionAtencion = $mysqli->prepare("UPDATE cotizaciones SET ID_CLIENTE = ?, ID_PREVISION = ? WHERE ID_COTIZACION = ?");
  $qUpdatePrevisionAtencion->bind_param('iii', $_POST['id_paciente'], $id_nueva_prev, $_POST['id_cotizacion']);
  $qUpdatePrevisionAtencion->execute();
  $qSelectNuevaPrevision->close();
  $respuesta = array('exito' => true, 'mensaje' => 'Paciente cambiado correctamente');
  echo json_encode($respuesta);
  exit(0);
}

if ((isset($_POST['cambiarMedico'])) && ($_POST['cambiarMedico'] != "")) {
  $qUpdateMedicoAtencion = $mysqli->prepare("UPDATE cotizaciones SET ID_MEDICO = ? WHERE ID_COTIZACION = ?");
  $qUpdateMedicoAtencion->bind_param('ii', $_POST['id_medico'], $_POST['id_cotizacion']);
  $qUpdateMedicoAtencion->execute();
  $respuesta = array('exito' => true, 'mensaje' => 'Médico cambiado correctamente');
  echo json_encode($respuesta);
}

if (isset($_POST['formAgregarExamen']) && $_POST['formAgregarExamen'] != "") {
  if ($_POST['cod_examen'] == "") mostrarMensajeError("Debe seleccionar un exámen");
  # Busco datos de examen
  $qExamen = $mysqli->prepare("SELECT e.FLAG_AGRUPACION, e.TIPO_TUBO, e.NRO_HOJA_TRABAJO, pex.PRECIO
  FROM examenes e
  INNER JOIN (
      SELECT COD_EXAMEN, MAX(ID_PEX) AS MAX_ID
      FROM precios_examenes
      WHERE ID_EMPRESA = ?
      GROUP BY COD_EXAMEN
  ) max_pex ON e.COD_INTERNO = max_pex.COD_EXAMEN
  INNER JOIN precios_examenes pex ON max_pex.COD_EXAMEN = pex.COD_EXAMEN AND max_pex.MAX_ID = pex.ID_PEX
  WHERE e.COD_INTERNO = ? AND pex.ID_EMPRESA = ?
  LIMIT 1");
  $qExamen->bind_param("isi", $_POST['id_empresa'], $_POST['cod_examen'], $_POST['id_empresa']);
  $qExamen->execute();
  $qExamen->bind_result($ex_flagAgrupacion, $ex_tipoTubo, $ex_nroHojaTrabajo, $ex_precio);
  $qExamen->store_result();
  $qExamen->fetch();
  $qExamen->close();
  $qInsertExamen = $mysqli->prepare("INSERT INTO examenes_cotizaciones (ID_COTIZACION, COD_EXAMEN, TIPO_TUBO, NRO_HOJA_TRABAJO, PRECIO_EXAMEN, COBRADO, PREV)
  VALUES (?, ?, ?, ?, ?, 'N', ?)");
  $qInsertExamen->bind_param("isiiii", $_POST['id_cotizacion'], $_POST['cod_examen'], $ex_tipoTubo, $ex_nroHojaTrabajo, $ex_precio, $_POST['id_empresa']);
  $qInsertExamen->execute();
  $qInsertExamen->close();

  # Si el examen es agrupación, se insertan sus hijos pero sin precio
  if ($ex_flagAgrupacion == "S") {
    $qExamenesHijos = $mysqli->prepare("SELECT ae.COD_EXAMEN_AGRUPADO, e.TIPO_TUBO, e.NRO_HOJA_TRABAJO
    FROM agrupaciones_examenes ae
    INNER JOIN examenes e ON ae.COD_EXAMEN_AGRUPADO = e.COD_INTERNO
    WHERE ae.COD_INTERNO = ?");
    $qExamenesHijos->bind_param("s", $_POST['cod_examen']);
    $qExamenesHijos->execute();
    $qExamenesHijos->bind_result($hijo_codExamen, $hijo_tipoTubo, $hijo_nroHojaTrabajo);
    $qExamenesHijos->store_result();
    while ($qExamenesHijos->fetch()) {
      $qInsertExamenHijo = $mysqli->prepare("INSERT INTO examenes_cotizaciones (ID_COTIZACION, PADRE, COD_EXAMEN, F_HIJO, TIPO_TUBO, NRO_HOJA_TRABAJO, COBRADO) 
      VALUES (?, ?, ?, 'S', ?, ?, 'N')");
      $qInsertExamenHijo->bind_param("issii", $_POST['id_cotizacion'], $_POST['cod_examen'], $hijo_codExamen, $hijo_tipoTubo, $hijo_nroHojaTrabajo);
      $qInsertExamenHijo->execute();
      $qInsertExamenHijo->close();
    }
    $qExamenesHijos->close();
  }
  # EXAMENES ADICIONALES
  if (in_array($_POST['cod_examen'], ["02.02.057", "02.02.576", "02.02.023", "00.00.288", "00.00.286", "00.00.291", "00.00.289", "00.00.290"])) {
    $codExamenesAdicionales = "";
    if ($_POST['cod_examen'] == "02.02.057") $codExamenesAdicionales = ["02.02.157"]; # UREMIA | nitrogeno ureico
    if ($_POST['cod_examen'] == "02.02.576") $codExamenesAdicionales = ["02.02.557"]; # UREMIA POST | nitrogeno ureico post
    if ($_POST['cod_examen'] == "02.02.023") $codExamenesAdicionales = ["00.00.042"]; # C. CREATININEMIA | velocidad de filtracion glomerular
    if ($_POST['cod_examen'] == "00.00.288") $codExamenesAdicionales = ["04.05.046"]; # LINFOCITOS T CD3, RECUENTO ABSOLUTO | LINFOCITOS T CD3, RECUENTO RELATIVO
    if ($_POST['cod_examen'] == "00.00.286") $codExamenesAdicionales = ["04.05.043"]; # LINFOCITOS B CD19, RECUENTO ABSOLUTO | LINFOCITOS B CD19, RECUENTO RELATIVO
    if ($_POST['cod_examen'] == "00.00.291") $codExamenesAdicionales = ["00.00.152"]; # LINFOCITOS NK CELLS, NATURAL KILLER (CD16/CD56), RECUENTO ABSOLUTO | LINFOCITOS NK CELLS, NATURAL KILLER (CD16/CD56), RECUENTO RELATIVO 
    if ($_POST['cod_examen'] == "00.00.289") $codExamenesAdicionales = ["04.05.145"]; # LINFOCITOS T CD4, RECUENTO ABSOLUTO | LINFOCITOS T CD4, RECUENTO RELATIVO
    if ($_POST['cod_examen'] == "00.00.290") $codExamenesAdicionales = ["04.05.245" , "00.00.285"]; # LINFOCITOS T CD8, RECUENTO ABSOLUTO | LINFOCITOS T CD8, RECUENTO RELATIVO - RELACION CD4/CD8
    # Busco datos de examen adicional y lo inserto 
    foreach ($codExamenesAdicionales as $key => $codigoExamenAdicional) {
      $qAdicional = $mysqli->prepare("SELECT e.FLAG_AGRUPACION, e.TIPO_TUBO, e.NRO_HOJA_TRABAJO, pex.PRECIO
      FROM examenes e
      INNER JOIN (
        SELECT COD_EXAMEN, MAX(ID_PEX) AS MAX_ID
        FROM precios_examenes
        WHERE ID_EMPRESA = ?
        GROUP BY COD_EXAMEN
      ) max_pex ON e.COD_INTERNO = max_pex.COD_EXAMEN
      INNER JOIN precios_examenes pex ON max_pex.COD_EXAMEN = pex.COD_EXAMEN AND max_pex.MAX_ID = pex.ID_PEX
      WHERE e.COD_INTERNO = ? AND pex.ID_EMPRESA = ?
      LIMIT 1");
      $qAdicional->bind_param("isi", $_POST['id_empresa'], $codigoExamenAdicional, $_POST["id_empresa"]);
      $qAdicional->execute();
      $qAdicional->bind_result($ad_tipoTubo, $ad_nroHojaTrabajo, $ad_precio);
      $qAdicional->store_result();
      $qAdicional->fetch();
      $qAdicional->close();
      $qInsertExamenAdicional = $mysqli->prepare("INSERT INTO examenes_cotizaciones (ID_COTIZACION, COD_EXAMEN, TIPO_TUBO, NRO_HOJA_TRABAJO, PRECIO_EXAMEN, COBRADO, PREV)
      VALUES (?, ?, ?, ?, ?, 'N', ?)");
      $qInsertExamenAdicional->bind_param("isiiii", $_POST['id_cotizacion'], $codigoExamenAdicional, $ad_tipoTubo, $ad_nroHojaTrabajo, $ad_precio, $_POST['id_empresa']);
      $qInsertExamenAdicional->execute();
      $qInsertExamenAdicional->close();
    }
  }
  # Actualizo monto total
  $qUpdateMonto = $mysqli->prepare("UPDATE cotizaciones SET MONTO_ATENCION = (SELECT SUM(PRECIO_EXAMEN) FROM examenes_cotizaciones WHERE ID_COTIZACION = ?)
  WHERE ID_COTIZACION = ?");
  $qUpdateMonto->bind_param("ii", $_POST['id_cotizacion'], $_POST['id_cotizacion']);
  $qUpdateMonto->execute();
  $qUpdateMonto->close();

  echo json_encode(array('exito' => true, 'mensaje' => 'Examen agregado correctamente'));
  exit(0);
}

if ((isset($_POST['eliminarExamen'])) && ($_POST['eliminarExamen'] != "")) {
  # Borra padre
  $qDeletePadre = $mysqli->prepare("DELETE FROM examenes_cotizaciones WHERE ID_EXCOT = ?");
  $qDeletePadre->bind_param("i", $_POST['id_examen_cotizacion']);
  $qDeletePadre->execute();
  $qDeletePadre->close();
  # Borra hijos
  $qDeleteHijo = $mysqli->prepare("DELETE FROM examenes_cotizaciones WHERE PADRE = ? AND ID_COTIZACION = ?");
  $qDeleteHijo->bind_param("si", $_POST['cod_examen'], $_POST['id_cotizacion']);
  $qDeleteHijo->execute();
  $qDeleteHijo->close();
  # Actualizo monto atención
  $qUpdateMonto = $mysqli->prepare("UPDATE cotizaciones SET MONTO_ATENCION = (SELECT SUM(PRECIO_EXAMEN) FROM examenes_cotizaciones WHERE ID_COTIZACION = ?)
  WHERE ID_COTIZACION = ?");
  $qUpdateMonto->bind_param("ii", $_POST['id_cotizacion'], $_POST['id_cotizacion']);
  $qUpdateMonto->execute();
  $qUpdateMonto->close();

  echo json_encode(array('exito' => true, 'mensaje' => 'Examen eliminado correctamente'));
  exit(0);
}

###########################################################################################################################################################################
###########################################################################################################################################################################
###########################################################################################################################################################################
# SE TRASPASAN LOS DATOS DE LA COTIZACION A UNA NUEVA ATENCION
if ((isset($_POST['ingresarComoAtencion'])) && ($_POST['ingresarComoAtencion'] != "")) {
  $hora_actual = date("H:i");
  $qSelect = $mysqli->prepare("SELECT ID_USUARIO, TIPO_CLIENTE, ID_CLIENTE, FECHA, HORA, ID_CENTRO_CONTACTO, ID_MEDICO, COD_DIAGNOSTICO, ID_CONVENIO,
  PCTJE_DESCUENTO, ID_PREVISION, FECHA_ULT_REGLA, NIVEL_URGENCIA, MONTO_DESCUENTO, FLAG_ACEPTA_C, OBS, CIERRE_ATE, FECHA_TM, HORA_TM, RESP_TM,
  FECHA_R, HORA_R, RESP_R, TURNO_DIALISIS
  FROM cotizaciones
  WHERE ID_COTIZACION = ?");
  $qSelect->bind_param('i', $_POST['id_cot']);
  $qSelect->execute();
  $qSelect->bind_result(
    $id_usuario,
    $tipo_cliente,
    $id_cliente,
    $fecha_cot,
    $hora_cot,
    $id_cc,
    $id_medico,
    $cod_diag,
    $id_convenio,
    $pctje_descuento,
    $id_prevision,
    $fecha_ult_regla,
    $nivel_urgencia,
    $monto_descuento,
    $flag_acepta_c,
    $obs,
    $cierre_ate,
    $fecha_tm,
    $hora_tm,
    $resp_tm,
    $fecha_r,
    $hora_r,
    $resp_r,
    $turno_dialisis
  );
  $qSelect->store_result();
  $qSelect->fetch();
  $qSelect->close();

  $qInsert = $mysqli->prepare("INSERT INTO atenciones (ID_USUARIO, TIPO_CLIENTE, ID_CLIENTE, FECHA, HORA, ID_CENTRO_CONTACTO, ID_MEDICO, COD_DIAGNOSTICO, ID_CONVENIO, 
  PCTJE_DESCUENTO, ID_PREVISION, FECHA_ULT_REGLA, NIVEL_URGENCIA, MONTO_ATENCION, MONTO_PAGADO, MONTO_DESCUENTO, FLAG_ACEPTA_C, OBS, CIERRE_ATE, FECHA_TM, HORA_TM, RESP_TM, 
  FECHA_R, HORA_R, RESP_R, TURNO_DIALISIS)
  VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 0, 0, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
  $qInsert->bind_param(
    'isissiisidisiiissssissii',
    $id_usuario,
    $tipo_cliente,
    $id_cliente,
    $hoy,
    $hora_actual,
    $id_cc,
    $id_medico,
    $cod_diag,
    $id_convenio,
    $pctje_descuento,
    $id_prevision,
    $fecha_ult_regla,
    $nivel_urgencia,
    $monto_descuento,
    $flag_acepta_c,
    $obs,
    $cierre_ate,
    $fecha_tm,
    $hora_tm,
    $resp_tm,
    $fecha_r,
    $hora_r,
    $resp_r,
    $turno_dialisis
  );
  $qInsert->execute();
  $id_nueva_atencion = $qInsert->insert_id;

  $qSelectExamenesCotizacion = $mysqli->prepare("SELECT ec.COD_EXAMEN, ec.F_HIJO, ec.PADRE, ec.TIPO_TUBO, ec.CORRELATIVO_TUBO, ec.NRO_HOJA_TRABAJO, ec.CORRELATIVO_HOJA_T,
  ec.PRECIO_EXAMEN, ec.COBRADO, ec.PREV, ec.USUARIO_VAL, ec.FECHA_VAL, ec.RESULTADO, ec.ID_USUARIO_REG, pe.PRECIO
  FROM examenes_cotizaciones ec
  LEFT JOIN (
      SELECT COD_EXAMEN, MAX(ID_PEX) AS MAX_ID_PEX
      FROM precios_examenes
      WHERE ID_EMPRESA = 31
      GROUP BY COD_EXAMEN
  ) max_pe ON max_pe.COD_EXAMEN = ec.COD_EXAMEN
  LEFT JOIN precios_examenes pe ON pe.COD_EXAMEN = max_pe.COD_EXAMEN AND pe.ID_PEX = max_pe.MAX_ID_PEX
  WHERE ID_COTIZACION = ?");
  $qSelectExamenesCotizacion->bind_param('i', $_POST['id_cot']);
  $qSelectExamenesCotizacion->execute();
  $qSelectExamenesCotizacion->bind_result(
    $cod_examen,
    $f_hijo,
    $padre,
    $tipo_tubo,
    $correlativo_tubo,
    $nro_hoja_tra,
    $correlativo_hota_t,
    $precio_examen,
    $cobrado,
    $prev,
    $usuario_val,
    $fecha_val,
    $resultado,
    $id_usuario_reg,
    $precio_fonasa
  );
  $qSelectExamenesCotizacion->store_result();
  $id_fonasa = 31;

  $id_ultimo_examen_atencion = null;

  while ($qSelectExamenesCotizacion->fetch()) {
    # Se transfroma el precio y el id de empresa (columna 'PREV') de todos los exámenes con PREV = 63 (COPAGO NIVEL 3).
    # Se inserta $precio_fonasa y $id_fonasa (31).

    if ($prev == 63) {
      $precio_final = $precio_fonasa;
      $prevision_final = $id_fonasa;
    } else {
      $precio_final = $precio_examen;
      $prevision_final = $prev;
    }

    if ($f_hijo != 'S') {
      $id_ultimo_examen_atencion = null;
    }

    $qInsertEA = $mysqli->prepare("INSERT INTO examenes_atenciones (ID_ATENCION, COD_EXAMEN, F_HIJO, PADRE, TIPO_TUBO, CORRELATIVO_TUBO, NRO_HOJA_TRABAJO, 
			CORRELATIVO_HOJA_T, PRECIO_EXAMEN, COBRADO, PREV, USUARIO_VAL, FECHA_VAL, RESULTADO, ID_USUARIO_REG, ID_EXAMEN_PADRE)
			VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $qInsertEA->bind_param(
      'isssiiiiisiissii',
      $id_nueva_atencion,
      $cod_examen,
      $f_hijo,
      $padre,
      $tipo_tubo,
      $correlativo_tubo,
      $nro_hoja_tra,
      $correlativo_hota_tm,
      $precio_final,
      $cobrado,
      $prevision_final,
      $usuario_val,
      $fecha_val,
      $resultado,
      $id_usuario_reg,
      $id_ultimo_examen_atencion
    );
    $qInsertEA->execute();

    if ($f_hijo != 'S') {
      $id_ultimo_examen_atencion = $qInsertEA->insert_id;
    }
  }

  $qSelectExamenesCotizacion->close();

  $qUpdate = $mysqli->prepare("UPDATE cotizaciones SET ID_ATENCION = ?, ESTADO = 'ATENCION' WHERE ID_COTIZACION = ?");
  $qUpdate->bind_param('ii', $id_nueva_atencion, $_POST['id_cot']);
  $qUpdate->execute();

  $respuesta = array('exito' => true, 'mensaje' => "Cotización ingresada como atención");
  echo json_encode($respuesta);
  exit(0);
}
