<?php
define('PERMITIDO', true);
$pagina = 9;
include('../pdfClasses/class.ezpdf.php');
require_once("../inc/init.php");
require_once('../lib/valido.php');
require_once('../lib/util.php');
require_once('../lib/connection.php');
require_once("../lib/config.php");

$pdf = new Cezpdf('LETTER');
$pdf->selectFont('../pdfClasses/fonts/Helvetica.afm');
$pdf->ezSetCmMargins(1, 1, 1, 1);
$pdf->ezStartPageNumbers(330, 18, 9, '', 'Página {PAGENUM} de {TOTALPAGENUM}', 1);

$dataCreator = array(
	'Title' => 'Hoja de Trabajo',
	'Author' => 'RIPIT',
	'Subject' => $nombre_archivo,
	'Creator' => 'SIL RIPIT',
	'Producer' => 'www.ripit.cl'
);

$idHoja = "-1";
if (isset($_GET['idhoja'])) $idHoja = $_GET['idhoja'];
$informe = array('Content-Disposition' => "Hoja general $idHoja"); // array para ezStream con el nombre del archovo
$pdf->addInfo($dataCreator); // informacion del archivo

$filtroLocal = "";
$nombreLocal = "";
if (isset($_GET['loc']) && $_GET['loc'] != "") {
	$filtroLocal = " AND a.ID_CENTRO_CONTACTO = " . $_GET['loc'];
	$stmt = $mysqli->prepare("SELECT NOMBRE FROM centros_contacto WHERE ID_CENTRO_CONTACTO = ?");
	$stmt->bind_param("i", $_GET['loc']);
	$stmt->execute();
	$stmt->bind_result($nombreLocal);
	$stmt->store_result();
	$stmt->fetch();
	$stmt->close();
}

$stmt = $mysqli->prepare("SELECT AREA FROM hojas_trabajo WHERE ID_HOJA = ?");
$stmt->bind_param("i", $idHoja);
$stmt->execute();
$stmt->bind_result($nombreArea);
$stmt->store_result();
$stmt->fetch();
$stmt->close();

$stmt = $mysqli->prepare("SELECT ea.ID_ATENCION, a.OBS, DATE_FORMAT(a.FECHA,'%d/%m/%Y') AS FECHA, DATE_FORMAT(a.FECHA_TM,'%d/%m/%Y') AS FECHA_TM, a.HORA_TM, 
cct.NOMBRE AS CCTO, e.NBR AS CONVENIO,
p.NOMBRES, p.APELLIDO_PATERNO, p.APELLIDO_MATERNO, p.NRO_RUT, p.DV_RUT, DATE_FORMAT(p.FECHA_NACIMIENTO,'%d/%m/%Y') AS NACIM,
YEAR(CURDATE())-YEAR(p.FECHA_NACIMIENTO) AS EDAD,
(((YEAR(CURDATE())-YEAR(p.FECHA_NACIMIENTO))*12)+(MONTH(CURDATE())-MONTH(p.FECHA_NACIMIENTO))) AS EDAD_MES,
m.APELLIDO_PATERNO AS MEDICO, cg2.DESCRIPCION_CG AS NIVUR
FROM examenes_atenciones ea 
INNER JOIN atenciones a ON ea.ID_ATENCION = a.ID_ATENCION
INNER JOIN centros_contacto cct ON cct.ID_CENTRO_CONTACTO = a.ID_CENTRO_CONTACTO
LEFT JOIN empresas e ON a.ID_CONVENIO = e.ID_EMPRESA
LEFT JOIN personas p ON a.ID_CLIENTE = p.ID_PERSONA
LEFT JOIN personas m ON a.ID_MEDICO= m.ID_PERSONA
LEFT JOIN codigos_generales cg2 ON a.NIVEL_URGENCIA = cg2.CODIGO AND cg2.COD_TABLA = 'SIS_NIVURG'
WHERE ea.CORRELATIVO_HOJA_T = ? AND a.FLAG_ELIMINADO = 0 $filtroLocal
GROUP BY ID_ATENCION ORDER BY ID_ATENCION ASC");
$stmt->bind_param('i', $idHoja);
$stmt->execute();
$resultado = $stmt->get_result();
$datos_atenciones = [];
while ($fila = $resultado->fetch_array(MYSQLI_ASSOC)) {
	$datos_atenciones[] = $fila;
}

$stmt = $mysqli->prepare("SELECT MAX(a.FECHA) AS MAXF, MIN(a.FECHA) AS MINF, MAX(a.ID_ATENCION) AS MAXA, MIN(a.ID_ATENCION) AS MINA, MAX(a.FECHA_TM) AS MAX_TM, MIN(a.FECHA_TM) AS MIN_TM
FROM examenes_atenciones ea
LEFT JOIN atenciones a ON ea.ID_ATENCION = a.ID_ATENCION 
WHERE ea.CORRELATIVO_HOJA_T = ?");
$stmt->bind_param('i', $idHoja);
$stmt->execute();
$resultado = $stmt->get_result();
$datos_fechas = $resultado->fetch_array(MYSQLI_ASSOC);

/*********************************************************************************************************************************************************************************/
/*********************************************************************************************************************************************************************************/
/*********************************************************************************************************************************************************************************/

$fecha = date("d/m/Y", time());

$maxf = date("d/m/Y", strtotime($datos_fechas['MAXF']));
$minf = date("d/m/Y", strtotime($datos_fechas['MINF']));

$maxa = $datos_fechas['MAXA'];
$mina = $datos_fechas['MINA'];

$max_tm = date("d/m/Y", strtotime($datos_fechas['MAX_TM']));
$min_tm = date("d/m/Y", strtotime($datos_fechas['MIN_TM']));

$pdf->ezText($cliente_nombreLaboratorio, 12);
$pdf->ezText($fecha, 10, array('justification' => 'right'));
$pdf->ezText("<b>HOJA DE TRABAJO GENERAL</b>", 15, array('justification' => 'center'));
$pdf->ezText($nombreArea, 12, array('justification' => 'center'));
$pdf->ezText($nombreLocal, 11, array('justification' => 'center'));

$pdf->ezText("Correlativo HT: " . $idHoja, 10);
$pdf->ezText("Números de atención: [$mina - $maxa]", 10);
$pdf->ezText("Fechas de atención: [$minf - $maxf]", 10);
if ($nombreArea == "DERIVADOS") $pdf->ezText("Fechas de toma muestra: " . $min_tm . " hasta " . $max_tm, 10);

foreach ($datos_atenciones as $atencion) {
	$obse = $atencion['OBS'] != NULL ? $atencion['OBS'] : "";
	$edad = ($atencion['EDAD_MES'] < "12") ? $atencion['EDAD_MES'] . " Meses" : $atencion['EDAD'] . " Años";
	$rut = number_format($atencion['NRO_RUT'], '0', ',', '.') . "-" . $atencion['DV_RUT'];
	$ccto = $atencion['CCTO'];
	$convenio = $atencion['CONVENIO'] != "" ? $atencion['CONVENIO'] : '-';
	$medico = $atencion['MEDICO'] != "" ? "Dr(a): " . $atencion['MEDICO'] : "";

	$pdf->ezText("________________________________________________________________________________________\n", 10);
	if ($nombreArea == "DERIVADOS") {
		$pdf->ezText("Atención: " . $atencion['ID_ATENCION'] . "        Fecha: " . $atencion['FECHA'] . "        Fecha TM: " . $atencion['FECHA_TM'] . "        Hora TM: " . $atencion['HORA_TM'] . "        " . "Local: " . $ccto . "        " . $medico . "        " . "Convenio: " . $convenio . "\n" .
			$atencion['NOMBRES'] . " " . $atencion['APELLIDO_PATERNO'] . " " . $atencion['APELLIDO_MATERNO'] . "        " . $rut . "        " . $atencion['NACIM'] . "        " . $edad . "        " . $obse . "\n" . $atencion['NIVUR'] . "\n", 10);
	} else {
		$pdf->ezText("Atención: " . $atencion['ID_ATENCION'] . "        Fecha: " . $atencion['FECHA'] . "        " . "Local: " . $ccto . "        " . $medico . "        " . "Convenio: " . $convenio . "\n" .
			$atencion['NOMBRES'] . " " . $atencion['APELLIDO_PATERNO'] . " " . $atencion['APELLIDO_MATERNO'] . "        " . $rut . "        " . $atencion['NACIM'] . "        " . $edad . "        " . $obse . "\n" . $atencion['NIVUR'] . "\n", 10);
	}

	$query = "SELECT ea.COD_EXAMEN, ea.F_HIJO, ex.NOMBRE, ex.FLAG_AGRUPACION
	FROM examenes_atenciones ea
	INNER JOIN examenes ex ON ea.COD_EXAMEN = ex.COD_INTERNO
	WHERE ea.ID_ATENCION = ? AND ea.CORRELATIVO_HOJA_T = ?
	ORDER BY ea.ID_ATENCION ASC, ID_EXATE ASC, FLAG_AGRUPACION DESC";
	echo $query;
	$stmt = $mysqli->prepare($query);
	$stmt->bind_param('ii', $atencion['ID_ATENCION'], $idHoja);
	$stmt->execute();
	$stmt->bind_result($codExamen, $flagHijo, $nombreExamen, $flagAgrupacion);
	$stmt->store_result();

	while ($stmt->fetch()) {
		if ($flagAgrupacion == "S" && $flagHijo == NULL) { # AGRUPACION
			$codigo = $codExamen;
			$nombre = $nombreExamen;
		} elseif ($flagAgrupacion == "N" && $flagHijo == "S") { # HIJO
			$codigo = "                        ";
			$nombre = "  > " . $nombreExamen . "     _______";
		} elseif ($flagAgrupacion == "N" && $flagHijo == NULL) { # INDIVIDUAL
			$codigo = $codExamen;
			$nombre = $nombreExamen . "     _______";
		}
		$pdf->ezText($nombre, 10, array('justification' => 'left'));
	}

	$pdf->ezSetCmMargins(1.5, 1.5, 1, 1);
}

ob_end_clean();
$pdf->ezStream($informe);
