<?php
define('PERMITIDO', true);
$pagina = 1;
require_once("../inc/init.php");
require('../lib/valido.php');
require_once('../lib/util.php');
require_once("../lib/func.global.php");
require_once('../lib/connection.php');
require_once("../lib/config.php");
require_once '../assets/php/PHPExcel.php';

error_reporting(E_ALL);
ini_set('display_errors', TRUE);
ini_set('display_startup_errors', TRUE);

if (PHP_SAPI == 'cli') die('This file should only be run from a Web Browser');
$objPHPExcel = new PHPExcel();
$objPHPExcel->getProperties()->setCreator('RIPIT')->setTitle('Hoja de trabajo');

$idHoja = "-1";
if (isset($_GET['idhoja'])) $idHoja = $_GET['idhoja'];

$filtroLocal = "";
$nombreLocal = "";
if (isset($_GET['loc']) && $_GET['loc'] != "") {
	$filtroLocal = " AND a.ID_CENTRO_CONTACTO = " . $_GET['loc'];
	$stmt = $mysqli->prepare("SELECT NOMBRE FROM centros_contacto WHERE ID_CENTRO_CONTACTO = ?");
	$stmt->bind_param("i", $_GET['loc']);
	$stmt->execute();
	$stmt->bind_result($nombreLocal);
	$stmt->store_result();
	$stmt->fetch();
	$stmt->close();
}

$stmt = $mysqli->prepare("SELECT AREA FROM hojas_trabajo WHERE ID_HOJA = ?");
$stmt->bind_param("i", $idHoja);
$stmt->execute();
$stmt->bind_result($nombreArea);
$stmt->store_result();
$stmt->fetch();
$stmt->close();

$qAtencionesConvenio = $mysqli->prepare("SELECT ea.ID_ATENCION, a.OBS, DATE_FORMAT(a.FECHA,'%d/%m/%Y') AS FECHA, 
DATE_FORMAT(a.FECHA_TM,'%d/%m/%Y') AS FECHA_TM, a.HORA_TM,
cct.NOMBRE AS CCTO, e.NBR AS CONVENIO, 
CONCAT_WS(' ', p.NOMBRES, p.APELLIDO_PATERNO, p.APELLIDO_MATERNO), p.NRO_RUT, p.DV_RUT, DATE_FORMAT(p.FECHA_NACIMIENTO,'%d/%m/%Y') AS NACIM,
YEAR(CURDATE())-YEAR(p.FECHA_NACIMIENTO) AS EDAD,
(((YEAR(CURDATE())-YEAR(p.FECHA_NACIMIENTO))*12)+(MONTH(CURDATE())-MONTH(p.FECHA_NACIMIENTO))) AS EDAD_MES,
m.APELLIDO_PATERNO AS MEDICO, cg2.DESCRIPCION_CG AS NIVUR
FROM examenes_atenciones ea
INNER JOIN atenciones a ON ea.ID_ATENCION = a.ID_ATENCION AND a.FLAG_ELIMINADO = 0 
INNER JOIN centros_contacto cct ON cct.ID_CENTRO_CONTACTO = a.ID_CENTRO_CONTACTO
LEFT JOIN empresas e ON a.ID_CONVENIO = e.ID_EMPRESA
LEFT JOIN personas p ON a.ID_CLIENTE = p.ID_PERSONA
LEFT JOIN personas m ON a.ID_MEDICO= m.ID_PERSONA
LEFT JOIN codigos_generales cg2 ON a.NIVEL_URGENCIA = cg2.CODIGO AND cg2.COD_TABLA = 'SIS_NIVURG'
WHERE ea.CORRELATIVO_HOJA_T = ?
GROUP BY ID_ATENCION
ORDER BY ID_ATENCION ASC");
$qAtencionesConvenio->bind_param('i', $idHoja);
$qAtencionesConvenio->execute();
$qAtencionesConvenio->bind_result(
  $idAtencion,
  $observacionesAtencion,
  $fechaAtencion,
  $fechaTomaMuestraAtencion,
  $horaTomaMuestraAtencion,
  $nombreLocal,
  $nbrConvenio,
  $nombrePaciente,
  $nroRutPaciente,
  $dvRutPaciente,
  $fechaNacimientoPaciente,
  $edadPaciente,
  $edadMesesPaciente,
  $apellidoMedico,
  $nivelUrgencia
);
$qAtencionesConvenio->store_result();

$qCount = $mysqli->prepare("SELECT COUNT(DISTINCT ea.ID_EXATE)
FROM examenes_atenciones ea
INNER JOIN atenciones a ON ea.ID_ATENCION = a.ID_ATENCION AND a.FLAG_ELIMINADO = 0 
WHERE ea.CORRELATIVO_HOJA_T = ?");
$qCount->bind_param('i', $idHoja);
$qCount->execute();
$qCount->bind_result($countIdExamenesAtencion);
$qCount->store_result();
$qCount->fetch();
$qCount->close();
$countIdExamenesAtencion = $countIdExamenesAtencion + 1;

# ESTILO PARA LA CABECERA
$styleArray = array(
  'font'  => array(
    'bold'  => true,
    'color' => array('rgb' => 'FFFFFF'),
    'size'  => 11
    //'name'  => 'Verdana'
  ),
  'fill' => array(
    'type' => PHPExcel_Style_Fill::FILL_SOLID,
    'color' => array('rgb' => '4F81BD')
  ),
  'alignment' => array(
    'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,
  ),
  'borders' => array(
    'allborders' => array(
      'style' => PHPExcel_Style_Border::BORDER_THIN
    )
  )
);
$objPHPExcel->getActiveSheet()->getStyle('A1:L1')->applyFromArray($styleArray);
$objPHPExcel->getActiveSheet()->getStyle("A2:L$countIdExamenesAtencion")->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_TEXT);

$objPHPExcel->getActiveSheet()
  ->setCellValue("A1", "N° Atención")
  ->setCellValue("B1", "Fecha")
  ->setCellValue("C1", "Fecha\nToma Muestra")
  ->setCellValue("D1", "Hora\nToma Muestra")
  ->setCellValue("E1", "Local")
  # ->setCellValue("F1", "Convenio")
  ->setCellValue("F1", "RUT\nPaciente")
  ->setCellValue("G1", "Nombre\nPaciente")
  ->setCellValue("H1", "Fecha Nacimiento\nPaciente")
  ->setCellValue("I1", "Edad\nPaciente")
  ->setCellValue("J1", "Médico")
  # ->setCellValue("L1", "Nivel Urgencia")
  ->setCellValue("K1", "Observaciones")
  ->setCellValue("L1", "Exámenes");

$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('B1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('C1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('D1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('E1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('F1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('G1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('H1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('I1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('J1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('K1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('L1')->getAlignment()->setWrapText(true);
// $objPHPExcel->getActiveSheet()->getStyle('M1')->getAlignment()->setWrapText(true);
// $objPHPExcel->getActiveSheet()->getStyle('N1')->getAlignment()->setWrapText(true);

$f = 2;
while ($qAtencionesConvenio->fetch()) {
  $qExamenes = $mysqli->prepare("SELECT ea.COD_EXAMEN, ea.F_HIJO, ex.NOMBRE
  FROM examenes_atenciones ea   
  INNER JOIN examenes ex ON ea.COD_EXAMEN = ex.COD_INTERNO
  WHERE ea.ID_ATENCION = ? AND ea.CORRELATIVO_HOJA_T = ?
  ORDER BY ea.ID_EXATE, FLAG_AGRUPACION DESC");
  $qExamenes->bind_param('ii', $idAtencion, $idHoja);
  $qExamenes->execute();
  $qExamenes->bind_result($codigoExamen, $flagHijo, $nombreExamen);
  $qExamenes->store_result();

  $celdaExamenes = "";
  $primeraFilaAtencion = $f;
  while ($qExamenes->fetch()) {
    $celdaExamenes = $flagHijo == "S" ? "> $nombreExamen" : "$nombreExamen";
    $campoEdad = ($edadMesesPaciente < "12") ? $edadMesesPaciente . " MESES" : $edadPaciente . " AÑOS";
    $objPHPExcel->getActiveSheet()->setCellValue('A' . $f, $idAtencion);
    $objPHPExcel->getActiveSheet()->setCellValue('B' . $f, $fechaAtencion);
    $objPHPExcel->getActiveSheet()->setCellValue('C' . $f, $fechaTomaMuestraAtencion);
    $objPHPExcel->getActiveSheet()->setCellValue('D' . $f, $horaTomaMuestraAtencion);
    $objPHPExcel->getActiveSheet()->setCellValue('E' . $f, $nombreLocal);
    #$objPHPExcel->getActiveSheet()->setCellValue('F' . $f, $nbrConvenio ? $nbrConvenio : "-");
    $objPHPExcel->getActiveSheet()->setCellValue('F' . $f, number_format($nroRutPaciente, '0', ',', '.') . '-' . $dvRutPaciente);
    $objPHPExcel->getActiveSheet()->setCellValue('G' . $f, $nombrePaciente);
    $objPHPExcel->getActiveSheet()->setCellValue('H' . $f, $fechaNacimientoPaciente);
    $objPHPExcel->getActiveSheet()->setCellValue('I' . $f, $campoEdad);
    $objPHPExcel->getActiveSheet()->setCellValue('J' . $f, $apellidoMedico);
    #$objPHPExcel->getActiveSheet()->setCellValue('L' . $f, $nivelUrgencia);
    $objPHPExcel->getActiveSheet()->setCellValue('K' . $f, $observacionesAtencion ? $observacionesAtencion : "-");
    $objPHPExcel->getActiveSheet()->setCellValue('L' . $f, $celdaExamenes);
    $f++;
  }
  foreach(range('A','L') as $columnID) $objPHPExcel->getActiveSheet()->getColumnDimension($columnID)->setAutoSize(true);
  $objPHPExcel->getActiveSheet()->calculateColumnWidths();
  foreach(range('A','L') as $columnID) $objPHPExcel->getActiveSheet()->getColumnDimension($columnID)->setAutoSize(false);
  $k = $f - 1;

  # foreach(range('A','K') as $columnID) $objPHPExcel->getActiveSheet()->mergeCells("$columnID$primeraFilaAtencion:$columnID$k");

  $objPHPExcel->setActiveSheetIndex(0)->mergeCells("A$primeraFilaAtencion:A$k");
  $objPHPExcel->setActiveSheetIndex(0)->mergeCells("B$primeraFilaAtencion:B$k");
  $objPHPExcel->setActiveSheetIndex(0)->mergeCells("C$primeraFilaAtencion:C$k");
  $objPHPExcel->setActiveSheetIndex(0)->mergeCells("D$primeraFilaAtencion:D$k");
  $objPHPExcel->setActiveSheetIndex(0)->mergeCells("E$primeraFilaAtencion:E$k");
  $objPHPExcel->setActiveSheetIndex(0)->mergeCells("F$primeraFilaAtencion:F$k");
  $objPHPExcel->setActiveSheetIndex(0)->mergeCells("G$primeraFilaAtencion:G$k");
  $objPHPExcel->setActiveSheetIndex(0)->mergeCells("H$primeraFilaAtencion:H$k");
  $objPHPExcel->setActiveSheetIndex(0)->mergeCells("I$primeraFilaAtencion:I$k");
  $objPHPExcel->setActiveSheetIndex(0)->mergeCells("J$primeraFilaAtencion:J$k");
  $objPHPExcel->setActiveSheetIndex(0)->mergeCells("K$primeraFilaAtencion:K$k");
}
$qAtencionesConvenio->close();

// PHPExcel_Settings::(PHPExcel_Settings::PCLZIP);

$objPHPExcel->getActiveSheet()->setTitle('Hoja de Trabajo'); # Rename worksheet
$objPHPExcel->getActiveSheet(); # Set active sheet index to the first sheet, so Excel opens this as the first sheet
header('Content-Type: application/vnd.ms-excel'); # Redirect output to a client’s web browser (Excel5)
// header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'); # Para xlsx, no funciona en servidor
header('Content-Disposition: attachment;filename="Hoja ' . $idHoja . ' ' . $nombreArea . ' ' . $nombreLocal .'.xls"');
header('Cache-Control: max-age=0');

// // If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header('Pragma: public'); // HTTP/1.0

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter->setPreCalculateFormulas(false);
$objWriter->save('php://output');
exit();
