<?php
define('PERMITIDO', true);
$pagina = 9;
include ('../pdfClasses/class.ezpdf.php');
require_once("../inc/init.php");
require_once('../lib/valido.php');
require_once('../lib/util.php');
require_once('../lib/connection.php');
require_once("../lib/config.php");
header('Content-type: application/pdf');
require_once('../Connections/conexionlab.php');

$pdf = new Cezpdf('LETTER');
$pdf->selectFont('../pdfClasses/fonts/Helvetica.afm');
$pdf->ezSetCmMargins(1, 1, 1, 1);
$pdf->ezStartPageNumbers(330, 18, 9, '', 'Página {PAGENUM} de {TOTALPAGENUM}', 1);

$datacreator = array(
	'Title' => 'Hoja de Trabajo',
	'Author' => 'RIPIT',
	'Subject' => $nombre_archivo,
	'Creator' => 'SIL RIPIT',
	'Producer' => 'www.ripit.cl'
);

$idHoja = "-1";
if (isset($_GET['idhoja'])) $idHoja = $_GET['idhoja'];
$informe = array('Content-Disposition' => "Hoja $idHoja"); // array para ezStream con el nombre del archovo
$pdf->addInfo($datacreator); // informacion del archivo

$filtroLocal = "";
$nombreLocal = "";
if (isset($_GET['loc']) && $_GET['loc'] != "") {
	$filtroLocal = " AND a.ID_CENTRO_CONTACTO = " . $_GET['loc'];
	$qAtencionesConvenio = $mysqli->prepare("SELECT NOMBRE FROM centros_contacto WHERE ID_CENTRO_CONTACTO = ?");
	$qAtencionesConvenio->bind_param("i", $_GET['loc']);
	$qAtencionesConvenio->execute();
	$qAtencionesConvenio->bind_result($nombreLocal);
	$qAtencionesConvenio->store_result();
	$qAtencionesConvenio->fetch();
	$qAtencionesConvenio->close();
}

$qAtencionesConvenio = $mysqli->prepare("SELECT AREA FROM hojas_trabajo WHERE ID_HOJA = ?");
$qAtencionesConvenio->bind_param("i", $idHoja);
$qAtencionesConvenio->execute();
$qAtencionesConvenio->bind_result($nombreArea);
$qAtencionesConvenio->store_result();
$qAtencionesConvenio->fetch();
$qAtencionesConvenio->close();

# info paciente, medico Y atencion
mysql_select_db($database_conexionlab, $conexionlab);
$query_paciente = "SELECT ea.ID_ATENCION, a.OBS, DATE_FORMAT(a.FECHA,'%d/%m/%Y') AS FECHA, DATE_FORMAT(a.FECHA_TM,'%d/%m/%Y') AS FECHA_TM, a.HORA_TM, 
cct.NOMBRE AS CCTO, e.NBR AS CONVENIO,
p.NOMBRES, p.APELLIDO_PATERNO, p.APELLIDO_MATERNO, p.NRO_RUT, p.DV_RUT, DATE_FORMAT(p.FECHA_NACIMIENTO,'%d/%m/%Y') AS NACIM,
YEAR(CURDATE())-YEAR(p.FECHA_NACIMIENTO) AS EDAD,
(((YEAR(CURDATE())-YEAR(p.FECHA_NACIMIENTO))*12)+(MONTH(CURDATE())-MONTH(p.FECHA_NACIMIENTO))) AS EDAD_MES,
m.APELLIDO_PATERNO AS MEDICO, cg2.DESCRIPCION_CG AS NIVUR
FROM examenes_atenciones ea 
INNER JOIN atenciones a ON ea.ID_ATENCION = a.ID_ATENCION
INNER JOIN centros_contacto cct ON cct.ID_CENTRO_CONTACTO = a.ID_CENTRO_CONTACTO
LEFT JOIN empresas e ON a.ID_CONVENIO = e.ID_EMPRESA
LEFT JOIN personas p ON a.ID_CLIENTE = p.ID_PERSONA
LEFT JOIN personas m ON a.ID_MEDICO= m.ID_PERSONA
LEFT JOIN codigos_generales cg2 ON a.NIVEL_URGENCIA = cg2.CODIGO AND cg2.COD_TABLA = 'SIS_NIVURG'
WHERE ea.CORRELATIVO_HOJA_T = $idHoja AND a.FLAG_ELIMINADO = 0 $filtroLocal
GROUP BY ID_ATENCION ORDER BY ID_ATENCION ASC";
$paciente = mysql_query($query_paciente, $conexionlab) or die(mysql_error());
$row_paciente = mysql_fetch_assoc($paciente);

// RANGO FECHAS Y ATENCIONES
mysql_select_db($database_conexionlab, $conexionlab);
$consulta = "SELECT MAX(a.FECHA) AS MAXF, MIN(a.FECHA) AS MINF, MAX(a.ID_ATENCION) AS MAXA, MIN(a.ID_ATENCION) AS MINA, MAX(a.FECHA_TM) AS MAX_TM, MIN(a.FECHA_TM) AS MIN_TM
FROM examenes_atenciones ea
LEFT JOIN atenciones a ON ea.ID_ATENCION = a.ID_ATENCION 
WHERE ea.CORRELATIVO_HOJA_T = $idHoja";
$resultados = mysql_query($consulta, $conexionlab) or die(mysql_error());
$row_resul = mysql_fetch_assoc($resultados);

/*********************************************************************************************************************************************************************************/

date_default_timezone_set("America/Santiago");
$fecha = date("d/m/Y", time());

$maxf = date("d/m/Y", strtotime($row_resul['MAXF']));
$minf = date("d/m/Y", strtotime($row_resul['MINF']));

$maxa = $row_resul['MAXA'];
$mina = $row_resul['MINA'];

$max_tm = date("d/m/Y", strtotime($row_resul['MAX_TM']));
$min_tm = date("d/m/Y", strtotime($row_resul['MIN_TM']));

$pdf->ezText("Laboratorio Clínico CHEUL ETCHEVERRY Ltda.", 12);
$pdf->ezText($fecha, 10, array('justification' => 'right'));
$pdf->ezText("<b>HOJA DE TRABAJO</b>", 15, array('justification' => 'center'));
$pdf->ezText($nombreArea, 12, array('justification' => 'center'));
$pdf->ezText($nombreLocal, 11, array('justification' => 'center'));

$pdf->ezText("Correlativo HT: " . $idHoja, 10);
$pdf->ezText("Atenciones desde: " . $mina . " hasta " . $maxa, 10);
$pdf->ezText("Fechas de atención: " . $minf . " hasta " . $maxf, 10);
if ($nombreArea == "DERIVADOS") $pdf->ezText("Fechas de toma muestra: " . $min_tm . " hasta " . $max_tm, 10);

do {
	$obse = $row_paciente['OBS'] != NULL ? $row_paciente['OBS'] : "";
	$edad = ($row_paciente['EDAD_MES'] < "12") ? $row_paciente['EDAD_MES'] . " Meses" : $row_paciente['EDAD'] . " Años";
	$rut = number_format($row_paciente['NRO_RUT'], '0', ',', '.') . "-" . $row_paciente['DV_RUT'];
	$ccto = $row_paciente['CCTO'];
	$convenio = $row_paciente['CONVENIO'] != "" ? $row_paciente['CONVENIO'] : '-';
	$medico = $row_paciente['MEDICO'] != "" ? "Dr(a): " . $row_paciente['MEDICO'] : "";

	$pdf->ezText("________________________________________________________________________________________\n", 10);
	if ($nombreArea == "DERIVADOS") {
		$pdf->ezText("Atención: " . $row_paciente['ID_ATENCION'] . "        Fecha: " . $row_paciente['FECHA'] . "        Fecha TM: " . $row_paciente['FECHA_TM'] . "        Hora TM: " . $row_paciente['HORA_TM'] . "        " . "Local: " . $ccto . "        " . $medico . "        " . "Convenio: " . $convenio . "\n" .
			$row_paciente['NOMBRES'] . " " . $row_paciente['APELLIDO_PATERNO'] . " " . $row_paciente['APELLIDO_MATERNO'] . "        " . $rut . "        " . $row_paciente['NACIM'] . "        " . $edad . "        " . $obse . "\n" . $row_paciente['NIVUR']. "\n", 10);
	} else {
		$pdf->ezText("Atención: " . $row_paciente['ID_ATENCION'] . "        Fecha: " . $row_paciente['FECHA'] . "        " . "Local: " . $ccto . "        " . $medico . "        " . "Convenio: " . $convenio . "\n" .
			$row_paciente['NOMBRES'] . " " . $row_paciente['APELLIDO_PATERNO'] . " " . $row_paciente['APELLIDO_MATERNO'] . "        " . $rut . "        " . $row_paciente['NACIM'] . "        " . $edad . "        " . $obse . "\n" . $row_paciente['NIVUR']. "\n", 10);
	}

	$qAtencionesConvenio = $mysqli->prepare("SELECT ea.COD_EXAMEN, ea.F_HIJO, ex.NOMBRE, ex.FLAG_AGRUPACION
	FROM examenes_atenciones ea
	INNER JOIN examenes ex ON ea.COD_EXAMEN = ex.COD_INTERNO
	WHERE ea.ID_ATENCION = {$row_paciente['ID_ATENCION']} AND ea.CORRELATIVO_HOJA_T = $idHoja $filtroLocal
	ORDER BY ea.ID_ATENCION ASC, ID_EXATE, FLAG_AGRUPACION DESC");
	$qAtencionesConvenio->execute();
	$qAtencionesConvenio->bind_result($codExamen, $flagHijo, $nombreExamen, $flagAgrupacion);
	$qAtencionesConvenio->store_result();

	while($qAtencionesConvenio->fetch()) {
		if ($flagAgrupacion == "S" && $flagHijo == NULL) { # AGRUPACION
			$codigo = $codExamen;
			$nombre = $nombreExamen;
		} elseif ($flagAgrupacion == "N" && $flagHijo == "S") { # HIJO
			$codigo = "                        ";
			$nombre = "  > " . $nombreExamen . "     _______";
		} elseif ($flagAgrupacion == "N" && $flagHijo == NULL) { # INDIVIDUAL
			$codigo = $codExamen;
			$nombre = $nombreExamen . "     _______";
		}
		$pdf->ezText($nombre, 10, array('justification' => 'left'));
	}

	$pdf->ezSetCmMargins(1.5, 1.5, 1, 1);
} while ($row_paciente = mysql_fetch_assoc($paciente));

ob_end_clean();
$pdf->ezStream($informe);

mysql_free_result($hoja);
mysql_free_result($paciente);
mysql_free_result($examenes);
