<?php 
define('PERMITIDO', true);

$pantalla_actual = 'TOM_REC_MUE_COD_BARRAS';

require_once __DIR__ . '/../inc/init.php';

function validarFechas($fecha_tm_solicitud, $hora_tm_solicitud, $fecha_tm, $hora_tm, $fecha_rm_solicitud, $hora_rm_solicitud, $fecha_rm, $hora_rm) {		
	$tm = $fecha_tm_solicitud == null ? $fecha_tm . ' ' . $hora_tm : $fecha_tm_solicitud . ' ' . $hora_tm_solicitud;
	$rm = $fecha_rm_solicitud == null ? $fecha_rm . ' ' . $hora_rm : $fecha_rm_solicitud . ' ' . $hora_rm_solicitud;
	
	if ($tm == null || $rm == null) {
		return true;
	}
	
	$datetime_tm = DateTime::createFromFormat('Y-m-d H:i', $tm);
	$datetime_rm = DateTime::createFromFormat('Y-m-d H:i', $rm);
	
	if ($datetime_tm >= $datetime_rm) {
		return false;
	}
	return true;
}

function actualizarAtención($id_atención, $tm, $rm) {
	global $mysqli;
	
	$mensajes = [];
	$errores = [];
	
	$sql_tm_tubos = "SELECT ea.TIPO_TUBO, tm_rm.FECHA_TM, tm_rm.HORA_TM, tm_rm.RESPONSABLE_TM
		FROM examenes_atenciones ea
		LEFT JOIN toma_recepcion_muestras tm_rm ON ea.ID_ATENCION = tm_rm.ID_ATENCION AND ea.TIPO_TUBO = tm_rm.TIPO_TUBO
		WHERE ea.ID_ATENCION = '{$id_atención}' AND ea.TIPO_TUBO != 17
		GROUP BY ea.TIPO_TUBO
		ORDER BY tm_rm.FECHA_TM, tm_rm.HORA_TM";
	
	$resultado_tm_tubos = $mysqli->query($sql_tm_tubos);
	
	$actualizar_tm = true;		
	while ($tubo = $resultado_tm_tubos->fetch_assoc()) {
		if ($tubo['FECHA_TM'] == null) {
			$actualizar_tm = false;
			break;
		} else {
			$fecha_tm = $tubo['FECHA_TM'];
			$hora_tm = $tubo['HORA_TM'];
			$responsable_tm = $tubo['RESPONSABLE_TM'];
			break;
		}
	}
	
	if ($actualizar_tm) {
		$sql_tm_atención = "UPDATE atenciones SET FECHA_TM = '{$fecha_tm}', HORA_TM = '{$hora_tm}', RESP_TM = '{$responsable_tm}' WHERE ID_ATENCION = '{$id_atención}' LIMIT 1";
		
		$mysqli->query($sql_tm_atención);
		
		$mensajes[] = "Fecha de toma de muestra registrada correctamente para la atención {$id_atención}.";
	}
	
	$sql_rm_atención = "SELECT a.FECHA_TM, a.HORA_TM, tm_rm.FECHA_RM, tm_rm.HORA_RM, tm_rm.RESPONSABLE_RM 
		FROM atenciones a
		JOIN toma_recepcion_muestras tm_rm ON a.ID_ATENCION = tm_rm.ID_ATENCION
		WHERE a.ID_ATENCION = {$id_atención} AND a.FECHA_R IS NULL
		ORDER BY tm_rm.ID_TM_RM
		LIMIT 1";
		
	$resultado_rm_atención = $mysqli->query($sql_rm_atención);
	
	if ($resultado_rm_atención->num_rows > 0) {				
		$rm_atención = $resultado_rm_atención->fetch_assoc();
		
		$fecha_rm = $rm_atención['FECHA_RM'];
		$hora_rm = $rm_atención['HORA_RM'];
		$responsable_rm = $rm_atención['RESPONSABLE_RM'];
		$fecha_tm_atención = $rm_atención['FECHA_TM'];
		$hora_tm_atención = $rm_atención['HORA_TM'];
		
		if (($fecha_rm . ' ' . $hora_rm) <= ($fecha_tm_atención . ' ' . $hora_tm_atención)) {
			$errores[] = "No se pudo registrar la fecha de recepción de muestra para la atención {$id_atención}. La fecha de recepción es anterior a la fecha de toma de muestra.";
		} else {
			$sql_rm_atención = "UPDATE atenciones SET FECHA_R = '{$fecha_rm}', HORA_R = '{$hora_rm}', RESP_R = '{$responsable_rm}', PARCIAL_R = 'S' WHERE ID_ATENCION = '{$id_atención}' LIMIT 1";
			$mysqli->query($sql_rm_atención);
			
			$mensajes[] = "Se recepcionó parcialmente la atención {$id_atención}.";
		}
	}
	
	$sql_rm_tubos_pendientes = "SELECT tm_rm.ID_TM_RM
	FROM examenes_atenciones ea
	LEFT JOIN toma_recepcion_muestras tm_rm ON ea.ID_ATENCION = tm_rm.ID_ATENCION AND ea.TIPO_TUBO = tm_rm.TIPO_TUBO
	WHERE ea.ID_ATENCION = '{$id_atención}' AND ea.TIPO_TUBO != 17 AND tm_rm.ID_TM_RM IS NULL
	GROUP BY ea.TIPO_TUBO";
	
	$resultado_rm_tubos_pendientes = $mysqli->query($sql_rm_tubos_pendientes);
		
	if ($resultado_rm_tubos_pendientes->num_rows == 0) {
		$sql_rm_atención = "SELECT a.FECHA_TM, DATE_FORMAT(a.HORA_TM, '%H:%i') AS HORA_TM
			FROM atenciones a
			WHERE a.ID_ATENCION = {$id_atención} AND a.PARCIAL_R = 'S'";
		$resultado_rm_atención = $mysqli->query($sql_rm_atención);
		
		if ($resultado_rm_atención->num_rows > 0) {
			$sql_rm_atención = "UPDATE atenciones SET PARCIAL_R = NULL WHERE ID_ATENCION = '{$id_atención}' LIMIT 1";
			$mysqli->query($sql_rm_atención);
			
			$mensajes[] = "Se recepcionó completamente la atención {$id_atención}.";
		}
	}
	
	return ['mensajes' => $mensajes, 'errores' => $errores];
}

function grabar($datos_solicitud) {	
	global $mysqli;
	global $usuario_id;
	
	$código_tubo = $datos_solicitud['codTubo'];
	
	$coincidencias = [];
	if (!preg_match('/^([0-9]+)-([0-9]+)$/', $código_tubo, $coincidencias)) {
		return ['éxito' => false, 'mensaje' => 'Verifique el formato del valor ingresado.'];
	}
	
	$id_atención = $coincidencias[1];
	$tipo_tubo = $coincidencias[2];
	
  $sql_observaciones = "SELECT OBS FROM atenciones WHERE ID_ATENCION = '{$id_atención}'";
	$resultado_observaciones = $mysqli->query($sql_observaciones);
  $observaciones = $resultado_observaciones->fetch_assoc();

	$sql_tm_rm_tubo = "SELECT ea.ID_EXATE, tm_rm.ID_TM_RM, a.FECHA_TM AS FECHA_TM_ATE, a.FECHA_R AS FECHA_RM_ATE, tm_rm.FECHA_TM, DATE_FORMAT(tm_rm.HORA_TM, '%H:%i') AS HORA_TM, tm_rm.FECHA_RM, DATE_FORMAT(tm_rm.HORA_RM, '%H:%i') AS HORA_RM FROM examenes_atenciones ea
	LEFT JOIN toma_recepcion_muestras tm_rm ON ea.ID_ATENCION = tm_rm.ID_ATENCION AND ea.TIPO_TUBO = tm_rm.TIPO_TUBO
	JOIN atenciones a ON ea.ID_ATENCION = a.ID_ATENCION
	WHERE ea.ID_ATENCION = '{$id_atención}' AND ea.TIPO_TUBO = '{$tipo_tubo}' AND ea.TIPO_TUBO != 17";
	$resultado_tm_rm_tubo = $mysqli->query($sql_tm_rm_tubo);
	
	if ($resultado_tm_rm_tubo->num_rows == 0) {
		return ['éxito' => false, 'mensaje' => 'El tipo de tubo no corresponde a la atención o la atención no existe.'];
	}
	
	$mensajes = [];
	$advertencias = [];
	$errores = [];
	
	$tm_rm_tubo = $resultado_tm_rm_tubo->fetch_assoc();
	
	if ($tm_rm_tubo['FECHA_TM_ATE'] != null) {
		$advertencias[] = "La atención {$id_atención} ya posee fecha de toma de muestra, la que no será modificada por valores ingresados en esta pantalla.";
	}
	if ($tm_rm_tubo['FECHA_RM_ATE'] != null) {
		$advertencias[] = "La atención {$id_atención} ya posee fecha de recepción de muestra, la que no será modificada por valores ingresados en esta pantalla.";
	}
	
	if ($tm_rm_tubo['FECHA_TM'] != null && $datos_solicitud['fechaTm'] != null && !$datos_solicitud['sobrescribir']) {
		$advertencias[] = "El tubo {$código_tubo} ya posee fecha de toma de muestra. Considere habilitar la opción 'Sobrescribir'.";
	}
	if ($tm_rm_tubo['FECHA_RM'] != null && $datos_solicitud['fechaRm'] != null && !$datos_solicitud['sobrescribir']) {
		$advertencias[] = "El tubo {$código_tubo} ya posee fecha de recepción de muestra. Considere habilitar la opción 'Sobrescribir'.";
	}
	
	if ($datos_solicitud['rmAuto'] && $datos_solicitud['fechaRm'] != null) {
		$datos_solicitud['fechaRm'] = date('Y-m-d');
		$datos_solicitud['horaRm'] = date('H:i');
	}
	
	if ($tm_rm_tubo['FECHA_TM_ATE'] == null && $datos_solicitud['fechaRm'] != null) {
		$errores[] = "Para registrar la fecha de recepción de muestra de un tubo, es necesario ingresar previamente la fecha de toma de muestra de la atención.";
	}
	
	elseif (validarFechas($datos_solicitud['fechaTm'], $datos_solicitud['horaTm'], $tm_rm_tubo['FECHA_TM'], $tm_rm_tubo['HORA_TM'], $datos_solicitud['fechaRm'], $datos_solicitud['horaRm'], $tm_rm_tubo['FECHA_RM'], $tm_rm_tubo['HORA_RM'])) {
		$sql_grabación = '';
		if ($tm_rm_tubo['ID_TM_RM'] == null) {
			$sql_grabación .= "INSERT INTO toma_recepcion_muestras (ID_ATENCION, TIPO_TUBO, FECHA_TM, HORA_TM, RESPONSABLE_TM, ID_USUARIO_TM, FECHA_RM, HORA_RM, RESPONSABLE_RM, ID_USUARIO_RM) ";
			
			$fecha_tm = $datos_solicitud['fechaTm'] != null ? "'{$datos_solicitud['fechaTm']}'" : 'NULL';
			$hora_tm = $datos_solicitud['horaTm'] != null ? "'{$datos_solicitud['horaTm']}'" : 'NULL';
			$responsable_tm = $datos_solicitud['responsableTm'] != null ? $datos_solicitud['responsableTm'] : 'NULL';
			$id_usuario_tm = $datos_solicitud['fechaTm'] != null ? $usuario_id : 'NULL';
			
			$fecha_rm = $datos_solicitud['fechaRm'] != null ? "'{$datos_solicitud['fechaRm']}'" : 'NULL';
			$hora_rm = $datos_solicitud['horaRm'] != null ? "'{$datos_solicitud['horaRm']}'" : 'NULL';
			$responsable_rm = $datos_solicitud['responsableRm'] != null ? $datos_solicitud['responsableRm'] : 'NULL';
			$id_usuario_rm = $datos_solicitud['fechaRm'] != null ? $usuario_id : 'NULL';
			
			$sql_grabación .= "VALUES ({$id_atención}, {$tipo_tubo}, {$fecha_tm}, {$hora_tm}, {$responsable_tm}, {$id_usuario_tm}, {$fecha_rm}, {$hora_rm}, {$responsable_rm}, {$id_usuario_rm})";
		} else {
			if ($datos_solicitud['fechaTm'] != null && ($tm_rm_tubo['FECHA_TM'] == null || $datos_solicitud['sobrescribir'])) {
				$sql_grabación .= "FECHA_TM = '{$datos_solicitud['fechaTm']}', HORA_TM = '{$datos_solicitud['horaTm']}', RESPONSABLE_TM = {$datos_solicitud['responsableTm']}, ID_USUARIO_TM = {$usuario_id}";
			}
			if ($datos_solicitud['fechaRm'] != null && ($tm_rm_tubo['FECHA_RM'] == null || $datos_solicitud['sobrescribir'])) {
				if ($sql_grabación != '') {
					$sql_grabación .= ', ';
				}
				$sql_grabación .= "FECHA_RM = '{$datos_solicitud['fechaRm']}', HORA_RM = '{$datos_solicitud['horaRm']}', RESPONSABLE_RM = {$datos_solicitud['responsableRm']}, ID_USUARIO_RM = {$usuario_id}";
			}
			if ($sql_grabación != '') {
				$sql_grabación = 'UPDATE toma_recepcion_muestras SET ' . $sql_grabación . " WHERE ID_TM_RM = {$tm_rm_tubo['ID_TM_RM']} LIMIT 1";
			}
		}
		
		if ($sql_grabación != '') {
			$mysqli->query($sql_grabación);
			$mensajes[] = "Tubo {$código_tubo} registrado correctamente.";
		} else {
			$advertencias[] = "No se realizó ninguna operación sobre el tubo {$código_tubo}.";
		}
	} else {
		$errores[] = "La fecha de toma de muestra del tubo {$código_tubo} debe ser anterior a su fecha de recepción.";
	}
	
	$resultado_actualización_atención = actualizarAtención($id_atención);
	
	$mensajes = array_merge($mensajes, $resultado_actualización_atención['mensajes']);
	$errores = array_merge($errores, $resultado_actualización_atención['errores']);

	$respuesta = ['éxito' => true, 'mensajes' => $mensajes, 'advertencias' => $advertencias, 'errores' => $errores, 'observaciones' => $observaciones['OBS']];
	
	return $respuesta;
}

function consultar($datos_solicitud) {
	global $mysqli;
	
	$código_tubo = $datos_solicitud['codTubo'];
	
	$coincidencias = [];
	if (!preg_match('/^([0-9]+)-?([0-9]*)$/', $código_tubo, $coincidencias)) {
		return ['éxito' => false, 'mensaje' => 'Verifique el formato del valor ingresado.'];
	}
	
	$id_atención = $coincidencias[1];
	
	$sql_tubos = "SELECT CONCAT(ea.ID_ATENCION, '-', ea.TIPO_TUBO) AS COD_TUBO, cg.DESCRIPCION_CG AS DESC_TUBO, CONCAT(DATE_FORMAT(tm_rm.FECHA_TM, '%d-%m-%Y'), ' ', DATE_FORMAT(tm_rm.HORA_TM, '%H:%i')) AS TM_TUBO,
	CONCAT(DATE_FORMAT(tm_rm.FECHA_RM, '%d-%m-%Y'), ' ', DATE_FORMAT(tm_rm.HORA_RM, '%H:%i')) AS RM_TUBO, DATE_FORMAT(a.FECHA_TM, '%d-%m-%Y') AS FECHA_TM_ATE, DATE_FORMAT(a.HORA_TM, '%H:%i') AS HORA_TM_ATE,
	DATE_FORMAT(a.FECHA_R, '%d-%m-%Y') AS FECHA_RM_ATE, DATE_FORMAT(a.HORA_R, '%H:%i') AS HORA_RM_ATE
	FROM examenes_atenciones ea
	LEFT JOIN codigos_generales cg ON cg.COD_TABLA = 'SIS_TIPTUB' AND ea.TIPO_TUBO = cg.CODIGO
	LEFT JOIN toma_recepcion_muestras tm_rm ON ea.ID_ATENCION = tm_rm.ID_ATENCION AND ea.TIPO_TUBO = tm_rm.TIPO_TUBO
	LEFT JOIN atenciones a ON ea.ID_ATENCION = a.ID_ATENCION
	WHERE ea.ID_ATENCION = '{$id_atención}' AND ea.TIPO_TUBO != 17
	GROUP BY ea.TIPO_TUBO";
	
	$resultado_tubos = $mysqli->query($sql_tubos);
	
	if ($resultado_tubos->num_rows == 0) {
		return ['éxito' => false, 'mensaje' => "No se encontró información para la atención {$id_atención}. Verifique que la atención exista y tenga al menos un tubo asociado."];
	}
	
	$atención = null;
	$tubos = [];
	while ($tubo = $resultado_tubos->fetch_assoc()) {
		if ($atención == null) {
			$atención = ['nAtención' => $id_atención, 'fechaTm' => $tubo['FECHA_TM_ATE'], 'horaTm' => $tubo['HORA_TM_ATE'], 'fechaRm' => $tubo['FECHA_RM_ATE'], 'horaRm' => $tubo['HORA_RM_ATE']];
		}
		
		$tubos[] = ['codTubo' => $tubo['COD_TUBO'], 'descTubo' => $tubo['DESC_TUBO'], 'tmTubo' => $tubo['TM_TUBO'], 'rmTubo' => $tubo['RM_TUBO']];
	}
	
	return ['éxito' => true, 'atención' => $atención, 'tubos' => $tubos];
}

function responder($respuesta) {
	header('Content-Type: application/json');
	echo json_encode($respuesta);
	die();
}

$metodo_solicitud = $_SERVER['REQUEST_METHOD'];
$id_usuario = $usuario_id;

$respuesta = [];

switch ($metodo_solicitud) {
	case 'GET':
		break;
	case 'POST':
		$json_solicitud = file_get_contents('php://input');
		$datos_solicitud = json_decode($json_solicitud, true);
		
		if (isset($datos_solicitud['grabar'])) {
			$respuesta = grabar($datos_solicitud);
		} else if (isset($datos_solicitud['consultar'])) {
			$respuesta = consultar($datos_solicitud);
		}
		
		break;
	default:
}

responder($respuesta);
?>