<?php
define('PERMITIDO', true);
require_once("../inc/init.php");

$consultaAtenciones = "SELECT a.ID_ATENCION, a.FECHA, a.ID_CENTRO_CONTACTO, cc.NOMBRE
FROM atenciones a
LEFT JOIN centros_contacto cc ON cc.ID_CENTRO_CONTACTO = a.ID_CENTRO_CONTACTO
LEFT JOIN empresas e ON e.ID_EMPRESA = a.ID_PREVISION
LEFT JOIN personas p ON p.ID_PERSONA = a.ID_CLIENTE
LEFT JOIN empresas e2 ON e2.ID_EMPRESA = p.ID_PREVISION
WHERE a.ID_CENTRO_CONTACTO = 136 AND FECHA IN ('2023-09-06', '2023-09-07')
AND a.FLAG_ELIMINADO = 0
# AND a.ID_ATENCION != 559104
# LIMIT 2";
$qAtenciones = $mysqli->prepare($consultaAtenciones);
$qAtenciones->execute();
$qAtenciones->bind_result($idAtencion, $fechaAtencion, $idCentroContacto, $nombreCentroContacto);
$qAtenciones->store_result();
$num_atenciones = $qAtenciones->num_rows();

echo "Número de atenciones: $num_atenciones <br><br>";
while ($qAtenciones->fetch()) {

  $codExamen = "02.02.046";

  echo "Atencion: $idAtencion, Fecha: $fechaAtencion, nombreCentroContacto: $nombreCentroContacto<br>";
  $qExamenes = $mysqli->prepare("SELECT ea.ID_EXATE, ex.COD_INTERNO, ex.NOMBRE, ea.RESULTADO
  FROM examenes_atenciones ea
  LEFT JOIN examenes ex ON ex.COD_INTERNO = ea.COD_EXAMEN
  WHERE ea.ID_ATENCION = ? AND ea.COD_EXAMEN = ?");
  $qExamenes->bind_param('is', $idAtencion, $codExamen);
  $qExamenes->execute();
  $qExamenes->bind_result($idExate, $codExamen, $nombreExamen, $resultadoExamen);
  $qExamenes->store_result();
  while ($qExamenes->fetch()) {
    if ($resultadoExamen == "" || $resultadoExamen === null) break;
    $nuevoResultado = $resultadoExamen * 1.12;
    echo "$idExate - $codExamen <br>resultadoExamen: $resultadoExamen <br>nuevoResultado: $nuevoResultado </br>";
    // $qUpdate = $mysqli->prepare("UPDATE examenes_atenciones SET RESULTADO = ? WHERE ID_EXATE = ? LIMIT 1");
    // $qUpdate->bind_param('ss', $nuevoResultado, $idExate);
    // $qUpdate->execute();
    // $qUpdate->close();
  }
  $qExamenes->close();
  echo "<br>";

  // $qUpdate = $mysqli->prepare("UPDATE atenciones SET ID_PREVISION = ? WHERE ID_ATENCION = ?");
  // $qUpdate->bind_param("ii", $idPrevisionObjetivo, $idAtencion);
  // $qUpdate->execute();
  // $qUpdate->close();
  
  // $qUpdate = $mysqli->prepare("UPDATE atenciones
  // SET MONTO_ATENCION = (SELECT SUM(PRECIO_EXAMEN) FROM examenes_atenciones WHERE ID_ATENCION = ?)
  // WHERE ID_ATENCION = ?");
  // $qUpdate->bind_param("ii", $idAtencion, $idAtencion);
  // $qUpdate->execute();
  // $qUpdate->close();
}
$qAtenciones->close();
