<?php
define('PERMITIDO', true);
require_once("../inc/init.php");

function obtenerEstadoNotificacionExamen2($idUsuarioValidador, $flagEntregaPresencialExamen, $horasProcesoExamen, $fechaHoraAtencion) {
    $ahora = date("Y-m-d H:i:s");
    $ahora = "2013-12-31 10:34:59";
    $horaEntregaExamen = date("Y-m-d H:i:s", strtotime("$fechaHoraAtencion +$horasProcesoExamen hours"));
    echo "$fechaHoraAtencion <br> $horasProcesoExamen <br>  $horaEntregaExamen <br> <br>";
    if ($flagEntregaPresencialExamen == 1) {
        if ($ahora >= $horaEntregaExamen) return "<b style='color:blue;'>INFORMADO (ENTREGA PRESENCIAL)</b>";
        if ($ahora < $horaEntregaExamen) return "<b style='color:red;'>PENDIENTE (ENTREGA PRESENCIAL)</b>";
    }
    if ($idUsuarioValidador != "") return "<b style='color:green;'>INFORMADO</b>";
    if ($idUsuarioValidador == "") return "<b style='color:red;'>PENDIENTE</b>";
    return "";
  }

$idAtencion = 10000;

$qAtencion = $mysqli->prepare("SELECT DATE_FORMAT(a.FECHA,'%d/%m/%Y'), CONCAT(a.FECHA, ' ', a.HORA), a.ID_CONVENIO, 
CONCAT_WS(' ', p.NOMBRES, p.APELLIDO_PATERNO, p.APELLIDO_MATERNO), p.MAIL, aa.URL
FROM atenciones a
LEFT JOIN personas p ON p.ID_PERSONA = a.ID_CLIENTE
LEFT JOIN archivos_atenciones aa ON aa.ID_ATENCION = a.ID_ATENCION AND aa.ID_ARCHIVO = (SELECT MAX(z.ID_ARCHIVO) FROM archivos_atenciones z WHERE z.ID_ATENCION = a.ID_ATENCION AND z.TIPO = 'INFORME')
WHERE a.ID_ATENCION = ?
LIMIT 1");
$qAtencion->bind_param('i', $idAtencion);
$qAtencion->execute();
$qAtencion->bind_result($fechaAtencion, $fechaHoraAtencion, $idConvenioAtencion, $nombrePaciente, $correoPaciente, $urlInformeAtencion);
$qAtencion->fetch();
$qAtencion->store_result();
$qAtencion->close();

$qExamenesAtencion = $mysqli->prepare("SELECT COD_EXAMEN, IFNULL(ex.NOMBRE_INF, NOMBRE), ea.USUARIO_VAL, ea.F_HIJO, ex.FLAG_ENTREGA_PRESENCIAL_RESULTADO, ex.HORAS_PROCESO
FROM examenes_atenciones ea
INNER JOIN examenes ex ON ex.COD_INTERNO = ea.COD_EXAMEN
WHERE ID_ATENCION = ?");
$qExamenesAtencion->bind_param('i', $idAtencion);
$qExamenesAtencion->execute();
$qExamenesAtencion->bind_result($codigoExamen, $nombreExamen, $idUsuarioValidador, $flagHijoExamen, $flagEntregaPresencialExamen, $horasProcesoExamen);
$qExamenesAtencion->store_result();

$examenesAtencion = "";
while($qExamenesAtencion->fetch()) {
  if (strpos($nombreExamen, 'TOMA DE') === false && strpos($codigoExamen, '07.07') === false) {
    $prefijo = ($flagHijoExamen == "S") ? "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" : "•"; # que el "exámen" no sea toma de muestra
    $estadoNotificacion = obtenerEstadoNotificacionExamen2($idUsuarioValidador, $flagEntregaPresencialExamen, $horasProcesoExamen, $fechaHoraAtencion);
    $examenesAtencion .= "$prefijo $nombreExamen - $estadoNotificacion <br>";
  }
}
$qExamenesAtencion->close();

echo $examenesAtencion;
