<?php
$pantalla_actual = 'LIS_VAR_EXA';

define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$qexamenes = $mysqli->prepare('SELECT examenes.COD_INTERNO, examenes.NOMBRE FROM examenes WHERE examenes.FLAG_AGRUPACION=\'N\' ORDER BY NOMBRE');
$qexamenes->execute();
$qexamenes->bind_result($ex_codInterno, $ex_nombre);
$qexamenes->store_result();


ob_start();
?>
<table class="table table-bordered table-hover" id="dataTable">
  <thead>
      <tr>
        <th>Código Interno</th>
        <th>Nombre</th>
        <th>Modificar</th>
      </tr>
  </thead>
  <tbody>
	  <?php while($qexamenes->fetch()) { ?>
      <tr>
        <td><?php echo $ex_codInterno; ?></td>
        <td><?php echo $ex_nombre; ?></td>
        <td align="center"><a href="e_variable.php?idex=<?php echo $ex_codInterno; ?>" title="Modificar" class="btn btn-link"><i class="fa fa-edit fa-lg"></i></a></td>
      </tr>
      <?php } $qexamenes->close(); ?>
  </tbody>
</table>

<?php 
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
    "title" => $datos_pantallas[$pantalla_actual]['body_title'],
    "icon" => 'fa fa-cog',
	'toolbar' => array(
		array(
			"id" => "toolbar-id",
			"content" => '<a href="examenes_pdf.php" class="btn btn-primary" title="Lista de Exámenes" target="_blank"><span class="fa fa-file-pdf-o"></span> Archivo PDF</a>',
			"class" => 'smart-form'
		)
	)
);
$widget->body('content', $contenido);
?>

<!-- ==========================CONTENT STARTS HERE ========================== -->
<div id="main" role="main">
<?php include("../inc/ribbon.php");	?>
 <div id="content">	
		<?php
            $widget->print_html();
        ?>
	</div>
	<!-- END MAIN CONTENT -->
        
</div> 



<!-- END MAIN PANEL -->
<!-- ==========================CONTENT ENDS HERE ========================== -->

<!-- PAGE FOOTER -->
<?php
	// include page footer
	include("../inc/footer.php");
?>
<!-- END PAGE FOOTER -->

<?php 
	//include required scripts
	include("../inc/scripts.php");
?>

<!-- PAGE RELATED PLUGIN(S) 
<script src="<?php echo ASSETS_URL; ?>/js/plugin/YOURJS.js"></script>-->

<script>

	$(document).ready(function() {
		$('#dataTable').DataTable({
				 'lengthMenu': [[50, 100, 200], [50, 100, 200]],
				 'language': {
						"sProcessing":   "Procesando...",
						"sZeroRecords":  "No se encontraron resultados",
						"sInfoPostFix":  "",
						"sUrl":          "",
						"oPaginate": {
							"sFirst":    "Primero",
							"sPrevious": "Anterior",
							"sNext":     "Siguiente",
							"sLast":     "Último"
						},
					 "sInfo": "_START_ a _END_ de _TOTAL_ Registros",
					 "sInfoEmpty":    "0 Registros",
					 "sInfoFiltered": "(de _MAX_ Registros en total)",
					 "sLengthMenu":"Mostrar _MENU_ Registros",
					 "sSearch":"Buscar: "
				 },
				 'pageLength' : 100,
				 'order' : [ 1, "asc" ],
				 'columns': [
					 null,
					 null,
					 {"orderable": false}
				 ],
				 'destroy': true
		});//DataTables
	})

</script>

<?php 
	//include footer
	include("../inc/google-analytics.php");
?>