<?php
define('PERMITIDO', true);
$pagina = 7;
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = " Rangos";
$page_css[] = "your_style.css";
include("../inc/header.php");
$page_nav['Admin_Sistema']['sub']['examenes']['sub']['VarExamenes']["active"] = true;
include("../inc/nav.php");
$breadcrumbs["Configuracion de Variables"] = "l_examenes.php";
$breadcrumbs["Modificación de Variables"] = "e_variable.php?idex=" . $_GET['idex'];


$codExamen = isset($_GET['idex']) ? $_GET['idex'] : "-1";

$qNombreExamen = $mysqli->prepare("SELECT NOMBRE FROM examenes WHERE COD_INTERNO = ?");
$qNombreExamen->bind_param("s", $codExamen);
$qNombreExamen->execute();
$qNombreExamen->bind_result($nombreExamen);
$qNombreExamen->store_result();
$qNombreExamen->fetch();
$qNombreExamen->close();

$qRegistrosRango = $mysqli->prepare("SELECT ID_RANGOS, GENERO, EDAD_MIN, EDAD_MAX, RC_MIN, RC_MAX, RR_MIN, RR_MAX, RV_MIN, RV_MAX, DATE_FORMAT(F_REGISTRO, '%d/%m/%Y')
FROM rangos_variables 
WHERE COD_INTERNO = ?
ORDER BY F_REGISTRO DESC, GENERO ASC, EDAD_MIN ASC");
$qRegistrosRango->bind_param("s", $codExamen);
$qRegistrosRango->execute();
$qRegistrosRango->bind_result($rv_idRegistroRangos, $rv_genero, $rv_edadMin, $rv_edadMax, $rv_rangoCriticoMin, $rv_rangoCriticoMax, $ward1, $ward2, $rv_rangoValidoMin, $rv_rangoValidoMax, $rv_fechaRegistro);
$qRegistrosRango->store_result();

ob_start();
?>

<a href="l_rangos.php?idex=<?= $codExamen ?>" class="btn btn-warning"> Version anterior </a>

<p class="font-md">
  Examen: <?= $codExamen ?> - <?= $nombreExamen ?>
</p>

<form id="formAgregarRegistroRangos" action="sql_cod.php" method="post">
  <table class="table table-hover table-bordered" style="width:80%">
    <tbody>
      <tr>
        <td>
          <select name="GENERO" class="form-control">
            <option value="AMBOS">AMBOS</option>
            <option value="M">MASCULINO</option>
            <option value="F">FEMENINO</option>
          </select>
        </td>
        <td><input type="text" name="EDAD_MIN" placeholder="Edad desde" class="form-control" required pattern="[0-9]{1,4}" maxlength="4" /></td>
        <td><input type="text" name="EDAD_MAX" placeholder="Edad hasta" class="form-control" required pattern="[0-9]{1,4}" maxlength="4" /></td>
        <td><input type="number" name="RC_MIN" placeholder="Crítico Inferior" class="form-control" required /></td>
        <td><input type="number" name="RV_MIN" placeholder="Válido Inferior" class="form-control" required /></td>
        <td><input type="number" name="RV_MAX" placeholder="Válido Superior" class="form-control" required /></td>
        <td><input type="number" name="RC_MAX" placeholder="Crítico Superior" class="form-control" required /></td>
        <td><a class="btn btn-primary btn-agregarRegistroRangos"> <i class="fa fa-plus fa-lg"></i> Agregar </a></td>
      </tr>
    </tbody>
    <input type="hidden" name="COD_INTERNO" value="<?= $codExamen ?>" />
    <input type="hidden" name="agregarRegistroRangos" value="agregarRegistroRangos" />
  </table>
</form>

<div class="row">
  <div class="col-md-6">
  </div>
</div>

<div class="table-responsive">
  <table class="table table-hover table-bordered" style="width:80%">
    <thead>
      <tr>
        <th style="text-align:center">Género</th>
        <th style="text-align:center">Rango Edad en Meses</th>
        <th style="text-align:center">Rango Crítico Inferior</th>
        <th style="text-align:center">Rango Válido</th>
        <th style="text-align:center">Rango Crítico Superior</th>
        <th style="text-align:center">Fecha</th>
        <th style="text-align:center">Acciones</th>
      </tr>
    </thead>
    <tbody>
      <?php while ($qRegistrosRango->fetch()) {
        $rv_genero = $rv_genero == "M" ? "Masculino" : "Femenino";
        $rv_edadMinAños = $rv_edadMin / 12; # prueba
        $rv_edadMaxAños = $rv_edadMax / 12; # prueba
      ?>
        <tr>
          <td align="center"><?= $rv_genero ?></td>
          <td align="center"><?= $rv_edadMin ?> - <?= $rv_edadMax ?></td>
          <td align="center"><?= $rv_rangoCriticoMin ?></td>
          <td align="center"><?= $rv_rangoValidoMin ?> - <?= $rv_rangoValidoMax ?></td>
          <td align="center"><?= $rv_rangoCriticoMax ?></td>
          <td align="center"><?= $rv_fechaRegistro ?></td>
          <td class="text-center">
            <a href="e_rango.php?idrr=<?= $rv_idRegistroRangos ?>" data-toggle="modal" data-target="#myModalEdit" class="btn btn-link">
              <i class="fa fa-edit fa-lg"></i>
            </a>
            <a class="btn btn-link btn-eliminarRegistroRangos" data-id="<?= $rv_idRegistroRangos ?>">
              <i class="fa fa-trash-o fa-lg txt-color-red"></i>
            </a>
          </td>
        </tr>
      <?php }
      $qRegistrosRango->close(); ?>
    </tbody>
  </table>
</div>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => '<h2><strong>Configuración de Rangos </strong></h2>',
  "icon" => 'fa fa-cog',
  'toolbar' => array(
    // array(
    //   "id" => "toolbar-id",
    //   "content" => '<a class="btn btn-success"  href="#"  data-toggle="modal" data-target="#myModalNew"><i class="fa fa-plus"></i> Agregar</a>',
    //   "class" => 'smart-form'
    // )
  )
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php
  include("../inc/ribbon.php");
  ?>

  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>

  <div class="modal fade Edit" id="myModalEdit" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog" style="width:80%">
      <div class="modal-content">
      </div>
    </div>
  </div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<!-- PAGE RELATED PLUGIN(S) 
<script src="<?= ASSETS_URL; ?>/js/plugin/YOURJS.js"></script>-->

<script>
  $(document).ready(function() {

    $('.btn-eliminarRegistroRangos').on('click', function() {
      if (confirm('¿Desea eliminar el rango de validación?')) {
        $.post("sql_cod.php", {
          idRegistroRangos: $(this).data('id'),
          eliminarRegistroRangos: '1'
        }, function(data) {
          if (data.exito) {
            exito();
            location.reload();
          } else {
            error("Error: " + data.mensaje);
          }
        }, 'json');
      }
    });

    $('.btn-agregarRegistroRangos').on('click', function() {
      var form = $("#formAgregarRegistroRangos");
      $.post($(form).attr('action'), $(form).serialize(), function(data) {
        if (data.exito) {
          exito();
          location.reload();
        } else {
          error(data.mensaje);
        }
      }, 'json');
    });
  })
</script>

<?php
include("../inc/google-analytics.php");
?>