<?php
$pantalla_actual = 'CON_RES';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$current_date = date("Y-m-d");
$date = strtotime($current_date . ' -6 months');
$final = date('Y-m-d', $date);
if (!isset($_GET['f_desde'])) echo "<script>location.href='l_atenciones_c.php?f_desde=" . $final . "';</script>";

$f_desde = '';
if (isset($_GET['f_desde']) && $_GET['f_desde'] != '') $f_desde = " AND a.FECHA >= '{$_GET['f_desde']}'";

$f_hasta = '';
if (isset($_GET['f_hasta']) && $_GET['f_hasta'] != '') $f_hasta = " AND a.FECHA <= '{$_GET['f_hasta']}'";

ob_start();
?>

<form action="" method="get" class="smart-form">
  <section>
    <div class="row">
      <div class="col col-2">
        <label class="input">
          <input name="f_desde" class="input-sm" type="date" value="<?php if (isset($_GET['f_desde'])) echo $_GET['f_desde'] ?>" />
          <div class="note">Fecha Desde</div>
        </label>
      </div>
      <div class="col col-2">
        <label class="input">
          <input name="f_hasta" class="input-sm" type="date" value="<?php if (isset($_GET['f_hasta'])) echo $_GET['f_hasta'] ?>" />
          <div class="note">Fecha Hasta</div>
        </label>
      </div>
      <div class="col-md-2">
        <div class="btn-group">
          <button class="btn btn-sm btn-success" type="submit"> <i class="fa fa-search"> </i> Filtrar </button>
          <a class="btn btn-sm btn-info" href="l_atenciones_c.php" style="margin-left: 5px">Ver todo</a>
        </div>
      </div>
    </div>
  </section>
</form>

<div class="table-responsive">
  <table class="table table-bordered table-hover" id="datable-atenciones" style="width:100%">
    <thead>
      <tr>
        <th>Atención</th>
        <th>Fecha</th>
        <th>Procedencia</th>
        <th>RUT Paciente</th>
        <th>Nombre Paciente</th>
        <th>Nivel Urgencia</th>
        <th>Resultados</th>
      </tr>
    </thead>
  </table>
</div>

<?php
$contenido = ob_get_contents();
ob_end_clean();
$botonPDF = "";
if ($_GET['otros'] == 'rechazadas') {
  $url = explode('?', $_SERVER["REQUEST_URI"]);
  $botonPDF = "<a target='_blank' href=atenciones_pdf.php?'.$url[1].' class='btn btn-sm btn-primary'><i class='fa fa-file-pdf-o'></i> PDF</a>";
}
$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title'],
  "icon" => 'fa fa-cog',
  'toolbar' => array(
    array(
      "id" => "toolbar-id",
      "content" => $botonPDF,
      "class" => 'smart-form'
    )
  )
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php
  include("../inc/ribbon.php");
  ?>

  <!-- MAIN CONTENT -->
  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>
  <!-- END MAIN PANEL -->
</div>
<!-- END MAIN PANEL -->
<!-- ==========================CONTENT ENDS HERE ========================== -->

<!-- PAGE FOOTER -->
<?php
// include page footer
include("../inc/footer.php");
?>
<!-- END PAGE FOOTER -->

<?php
//include required scripts
include("../inc/scripts.php");
?>

<script>
  var totalQuery = 0;
  $(document).ready(function() {
    var table = $('#datable-atenciones').DataTable({
      "processing": true,
      "serverSide": true,
      "paging": true,
      'lengthMenu': [
        [50, 100, 200, 500],
        [50, 100, 200, 500]
      ],
      "language": {
        "sProcessing": "Procesando...",
        "sZeroRecords": "No se encontraron resultados",
        "sInfoPostFix": "",
        "sUrl": "",
        "oPaginate": {
          "sFirst": "Primero",
          "sPrevious": "Anterior",
          "sNext": "Siguiente",
          "sLast": "Último"
        },
        "sInfo": "_START_ a _END_ de _TOTAL_ Registros",
        "sInfoEmpty": "0 Registros",
        "sInfoFiltered": "(de _MAX_ Registros en total)",
        "sLengthMenu": "Mostrar _MENU_ Registros",
        "sSearch": "Buscar: "
      },
      "order": [0, 'desc'],
      "ajax": {
        url: "ajax_atenciones_c.php",
        type: "POST",
        data: [{
          'estadoAtenciones': 1,
          'desde': "<?= $f_desde ?>",
          'hasta': "<?= $f_hasta ?>",
          'estadoCierre': "<?= $f_estadoCierre ?>",
          'local': "<?= $f_local ?>",
          'otros': "<?= $f_otros ?>",
          'totalQuery': totalQuery
        }]
      },
      "initComplete": function(settings, json) {
        totalQuery = json.recordsTotal;
      },
      'columnDefs': [{
        "targets": 6,
        "className": "text-center"
      }, ],
      'columns': [
        null,
        null,
        null,
        null,
        null,
        null,
        {
          "orderable": false
        }
      ]
    });
  });
</script>

<?php
//include footer
include("../inc/google-analytics.php");
?>