<?php
$pantalla_actual = 'CON_RES_HIS';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");


$optionsExamenes = '<option value=""> Seleccione </option>';
$qExamenes = $mysqli->prepare('SELECT COD_INTERNO, NOMBRE
FROM examenes
WHERE FLAG_AGRUPACION = "N"
GROUP BY COD_INTERNO
ORDER BY NOMBRE ASC');
$qExamenes->execute();
$qExamenes->bind_result($ex_codInterno, $ex_nombre);
while ($qExamenes->fetch()) {
	if ($ex_codInterno == $_GET['id_ex']) $optionsExamenes .= '<option selected value="' . $ex_codInterno . '">' . $ex_nombre . '</option>';
	else $optionsExamenes .= '<option value="' . $ex_codInterno . '">' . $ex_nombre . '</option>';
}

$optionsProcedencias = '<option value=""> Seleccione </option>';
$qProced = $mysqli->prepare('SELECT ID_CENTRO_CONTACTO, NOMBRE FROM centros_contacto ORDER BY NOMBRE ASC');
$qProced->execute();
$qProced->bind_result($pr_idCentroContacto, $pr_nombre);
while ($qProced->fetch()) {
	if ($pr_idCentroContacto == $_GET['id_proc']) $optionsProcedencias .= '<option selected value="' . $pr_idCentroContacto . '">' . $pr_nombre . '</option>';
	else $optionsProcedencias .= '<option value="' . $pr_idCentroContacto . '">' . $pr_nombre . '</option>';
}

// filtro default
if (($_GET['desde'] == "")) {
	$filtro = ' AND a.FECHA >= (date_sub(CURDATE(), INTERVAL 1 MONTH))';
}

if ((isset($_GET['id_ex'])) && ($_GET['id_ex'] != "")) {
	$filtro_examen = $_GET['id_ex'];
	$filtro = ' AND (ex.COD_INTERNO = \'' . $filtro_examen . '\')';
}

if ((isset($_GET['id_proc'])) && ($_GET['id_proc'] != "")) {
	$filtro_procedencia = $_GET['id_proc'];
	$filtro .= ' AND (ccto.ID_CENTRO_CONTACTO = \'' . $filtro_procedencia . '\')';
}

if ((isset($_GET['desde'])) && ($_GET['desde'] != "")) {
	$filtro_fechaDesde = $_GET['desde'];
	$filtro .= ' AND (a.FECHA >= \'' . $filtro_fechaDesde . '\')';
}

if ((isset($_GET['hasta'])) && ($_GET['hasta'] != "")) {
	$filtro_fechaHasta = $_GET['hasta'];
	$filtro .= ' AND (a.FECHA <= \'' . $filtro_fechaHasta . '\')';
}

$cant_reg = 100;		//Limito la busqueda
$inicio = 0;
$pagina = 1;
if (isset($_GET["pag"])) { //examino la página a mostrar y el inicio del registro a mostrar
	$pagina = $_GET["pag"];
	$inicio = ($pagina - 1) * $cant_reg;
}
/* Consulta para saber total de paginas */
if (isset($_GET['tpag'])) {
	$total_paginas = $_GET['tpag'];
} else {
	$consultaTotal = "SELECT a.ID_ATENCION
	FROM atenciones a
	LEFT JOIN examenes_atenciones ea ON ea.ID_ATENCION = a.ID_ATENCION
	LEFT JOIN examenes ex ON ex.COD_INTERNO = ea.COD_EXAMEN
	INNER JOIN personas p ON p.ID_PERSONA = a.ID_CLIENTE
	LEFT JOIN centros_contacto ccto ON ccto.ID_CENTRO_CONTACTO = a.ID_CENTRO_CONTACTO
	WHERE ex.FLAG_AGRUPACION = 'N' AND ea.RESULTADO IS NOT NULL AND a.FLAG_ELIMINADO = 0 $filtro";
	$qtotal = $mysqli->prepare($consultaTotal);
	$qtotal->execute();
	$qtotal->store_result();
	$totalRows_total = $qtotal->num_rows;
	$qtotal->close();
	$total_paginas = ceil($totalRows_total / $cant_reg);
}

$consulta = "SELECT a.ID_ATENCION, DATE_FORMAT(a.FECHA, '%d/%m/%Y'), p.NOMBRES, p.APELLIDO_PATERNO, p.APELLIDO_MATERNO, p.NRO_RUT, p.DV_RUT, cg.DESCRIPCION_CG, ccto.NOMBRE,
ea.ID_EXATE, ea.COD_EXAMEN, DATE_FORMAT(ea.FECHA_VAL,'%d/%m/%Y %H:%i') AS FECHA_VALI, ea.RESULTADO,
ex.NOMBRE AS EXAMEN, ex.FLAG_AGRUPACION
FROM atenciones a
LEFT JOIN examenes_atenciones ea ON ea.ID_ATENCION = a.ID_ATENCION
LEFT JOIN examenes ex ON ex.COD_INTERNO = ea.COD_EXAMEN
INNER JOIN personas p ON p.ID_PERSONA = a.ID_CLIENTE
LEFT JOIN codigos_generales cg ON cg.CODIGO = a.NIVEL_URGENCIA AND cg.COD_TABLA = 'SIS_NIVURG'
LEFT JOIN centros_contacto ccto ON ccto.ID_CENTRO_CONTACTO = a.ID_CENTRO_CONTACTO
WHERE ex.FLAG_AGRUPACION = 'N' AND ea.RESULTADO IS NOT NULL AND a.FLAG_ELIMINADO = 0 $filtro 
ORDER BY a.ID_ATENCION DESC
LIMIT ?, ? ";
$qatenciones = $mysqli->prepare($consulta);
$qatenciones->bind_param('ii', $inicio, $cant_reg);
$qatenciones->execute();
$qatenciones->bind_result(
	$at_id,
	$at_fecha,
	$at_nombrePaciente,
	$at_apPaterno,
	$at_apMaterno,
	$at_nroRut,
	$at_dvRut,
	$at_nivelUrgencia,
	$at_local,
	$at_idExate,
	$at_codExamen,
	$at_fechaVali,
	$at_resultado,
	$at_nombreExamen,
	$at_flagAgrupacion
);
$qatenciones->store_result();
$totalRows_atenciones = $qatenciones->num_rows;

ob_start();
?>

<form id="formBuscar" name="formBuscar" method="get" class="smart-form" action="">
	<section>
		<div class="row">
			<div class="col col-2">
				<label class="label">Desde <?php if (isset($_GET['desde']) && $_GET['desde'] != '') echo '<i class="fa fa-filter txt-color-red" title="Filtro Aplicado"></i>' ?></label>
				<label class="input">
					<input type="date" name="desde" value="<?php if (isset($_GET['desde'])) echo $_GET['desde'] ?>" class="input-sm"> </input>
				</label>
			</div>
			<div class="col col-2">
				<label class="label">Hasta <?php if (isset($_GET['hasta']) && $_GET['hasta'] != '') echo '<i class="fa fa-filter txt-color-red" title="Filtro Aplicado"></i>' ?></label>
				<label class="input">
					<input type="date" name="hasta" value="<?php if (isset($_GET['hasta'])) echo $_GET['hasta'] ?>" class="input-sm"> </input>
				</label>
			</div>
			<div class="col col-4">
				<label class="label">Examen <?php if (isset($_GET['id_ex']) && $_GET['id_ex'] != '') echo '<i class="fa fa-filter txt-color-red" title="Filtro Aplicado"></i>' ?></label>
				<label class="select">
					<select class="select2" name="id_ex" style="width:100%">
						<?= $optionsExamenes ?>
					</select>
				</label>
			</div>
			<div class="col col-2">
				<label class="label">Procedencia <?php if (isset($_GET['id_proc']) && $_GET['id_proc'] != '') echo '<i class="fa fa-filter txt-color-red" title="Filtro Aplicado"></i>' ?></label>
				<label class="select">
					<select class="select2" name="id_proc" style="width:100%">
						<?= $optionsProcedencias ?>
					</select>
				</label>
			</div>
			<div class="col col-1" style="padding-top:24px;">
				<button type="submit" class="btn btn-sm btn-primary btn-block">
					Filtrar
				</button>
			</div>
			<div class="col col-1" style="padding-top:24px;">
				<button type="button" class="btn btn-sm btn-default btn-block" onclick="location.href='l_atenciones_c_h.php'">
					Limpiar
				</button>
			</div>
		</div>
	</section>
	<table class="table">
		<tr>
			<?php if (isset($_GET['desde']) && $_GET['desde'] != '' && isset($_GET['hasta']) && $_GET['hasta'] != '' && isset($_GET['id_ex']) && $_GET['id_ex'] != '') { ?>
				<td>
					<a class="btn btn-sm btn-success" href="xls_atenciones_c_h.php?desde=<?= $_GET['desde']; ?>&hasta=<?= $_GET['hasta']; ?>&id_ex=<?= $_GET['id_ex']; ?>&id_proc=<?= $_GET['id_proc']; ?>">
						<i class="fa fa-file-excel-o"> </i> Exportar resultados a Excel
					</a>
				</td>
			<?php } else { ?>
				<td>
					Filtre por tipo de examen y rango de fechas para exportar a Excel
				</td>
			<?php } ?>
			<td>
				<div class="text-right"><?php if ($total_paginas > 1)  echo paginacion('l_atenciones_c_h.php?', $_SERVER['QUERY_STRING'], $total_paginas, $pagina, 2, 2) ?></div>
			</td>
		</tr>
	</table>
</form>

<table class="table table-responsive table-hover table-bordered">
	<thead>
		<tr bgcolor="#999999">
			<!-- <th>Rut Paciente</th> -->
			<th>Atención</th>
			<th>Fecha Atención</th>
			<th>Apellidos Paciente</th>
			<th>Nombres Paciente</th>
			<th>Procedencia</th>
			<th>Examen</th>
			<th>Resultado</th>
		</tr>
	</thead>
	<tbody>
		<?php if ($totalRows_atenciones > 0) { // Show if recordset not empty 
		?>
			<?php while ($qatenciones->fetch()) {
				//if($filtro_examen == "00.00.069") $aux = preg_split('/\r\n|\r|\n/', $at_resultado); // PARA ACORTAR EL RESULTADO DE LOS EXAMENES COVID (SOLO LA PRIMERA LINEA)
			?>
				<tr>
					<!-- <td><?php echo number_format($at_nroRut, '0', ',', '.') . "-" . $at_dvRut; ?></td> -->
					<td><?php echo $at_id; ?></td>
					<td><?php echo $at_fecha; ?></td>
					<td><?php echo $at_apPaterno . ' ' . $at_apMaterno; ?></td>
					<td><?php echo $at_nombrePaciente; ?></td>
					<td><?php echo $at_local; ?></td>
					<td><?php echo $at_nombreExamen; ?></td>
					<td><?php /*if($filtro_examen == "00.00.069") echo $aux[0]; else */ echo $at_resultado; ?></td>
				</tr>
			<?php }
			$qatenciones->close(); ?>
		<?php } else echo '<tr><td colspan="7"></td></tr>' ?>
	</tbody>
</table>

<?php if ($total_paginas > 1)  echo '<div class="text-center" style="padding-top:1em;">' . paginacion('l_atenciones_c_h.php?', $_SERVER['QUERY_STRING'], $total_paginas, $pagina) . '</div>' ?>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
	"title" => $datos_pantallas[$pantalla_actual]['body_title'],
	"icon" => 'fa fa-wrench'
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
	<?php
	include("../inc/ribbon.php");
	?>

	<div id="content">
		<?php
		$widget->print_html();
		?>
	</div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<script>
	$(document).ready(function() {
		$('#buscar').click(function() {
			$('#formBuscar').submit();
		})
	})
</script>

<?php
include("../inc/google-analytics.php");
?>